/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.model.objing;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IMetaclassReference;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IProfile;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITaggedValue;
import com.modeliosoft.modelio.xmi.generation.ProfileExportVisitorImpl;
import com.modeliosoft.modelio.xmi.model.objing.profile.PExportProfile;
import com.modeliosoft.modelio.xmi.util.GenerationProperties;
import com.modeliosoft.modelio.xmi.util.ObjingModelNavigation;
import com.modeliosoft.modelio.xmi.util.ProfileUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.uml2.uml.Element;

public class OElement {
    private IElement objingElt;

    public IElement getObjingElement() {
        return this.objingElt;
    }

    public String getObjingID() {
        return this.objingElt.getIdentifier();
    }

    public OElement(IElement element) {
        this.objingElt = element;
        if (element instanceof IModelElement) {
            IModelElement modelElement = (IModelElement)element;
            for (IStereotype obStereotype : modelElement.getExtension()) {
                if (!ObjingModelNavigation.mustBeExported((IStereotype)obStereotype)) continue;
                this.exportStereotypeProfile(obStereotype);
                GenerationProperties.getInstance().addStereotypeExported(modelElement);
            }
            for (ITaggedValue obTaggedValue : modelElement.getTag()) {
                IMetaclassReference reference = obTaggedValue.getDefinition().getOwnerReference();
                if (reference == null || !ObjingModelNavigation.mustBeExported((IMetaclassReference)reference)) continue;
                this.exportReferenceProfile(reference);
                GenerationProperties.getInstance().addStereotypeExported(modelElement);
            }
        }
    }

    private void exportStereotypeProfile(IStereotype stereotype) {
        this.exportProfile(stereotype.getOwner());
    }

    private void exportReferenceProfile(IMetaclassReference reference) {
        this.exportProfile(reference.getOwnerProfile());
    }

    public List<String> getEcoreClassName() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Element");
        return result;
    }

    private void exportProfile(IProfile profile) {
        Element ecoreProfile = GenerationProperties.getInstance().getMappedElement((IElement)profile);
        if (ecoreProfile == null) {
            ProfileExportVisitorImpl profileVisitor = new ProfileExportVisitorImpl();
            PExportProfile pprofile = new PExportProfile(ProfileUtils.getProfileRoot((IProfile)profile));
            profileVisitor.visit(pprofile);
        }
    }
}

