/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.model.objing.profile;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IMetaclassReference;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IProfile;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.statik.IModelTree;
import com.modeliosoft.modelio.xmi.generation.ProfileExportVisitorImpl;
import com.modeliosoft.modelio.xmi.generation.TotalExportMap;
import com.modeliosoft.modelio.xmi.model.objing.profile.IExportProfileElement;
import com.modeliosoft.modelio.xmi.model.objing.profile.PExportReference;
import com.modeliosoft.modelio.xmi.model.objing.profile.PExportStereotype;
import com.modeliosoft.modelio.xmi.util.GenerationProperties;
import com.modeliosoft.modelio.xmi.util.ObjingEAnnotation;
import com.modeliosoft.modelio.xmi.util.ObjingModelNavigation;
import com.modeliosoft.modelio.xmi.util.ProfileUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Profile;

public class PExportProfile
implements IExportProfileElement {
    private IProfile objingElt = null;
    private TotalExportMap totalMap = TotalExportMap.getInstance();

    public PExportProfile(IProfile profile) {
        this.objingElt = profile;
    }

    public void accept(ProfileExportVisitorImpl visitor) {
        visitor.visit(this);
    }

    public void visit() {
        Profile ecoreElt = (Profile)GenerationProperties.getInstance().getMappedElement((IElement)this.objingElt);
        if (ecoreElt == null) {
            ecoreElt = ProfileUtils.createEcoreProfile((IProfile)this.objingElt);
            this.totalMap.put(this.objingElt.getIdentifier(), (Element)ecoreElt);
        }
        this.setProperties(ecoreElt);
        this.attach(ecoreElt);
    }

    private void setProperties(Profile ecoreElt) {
        ObjingEAnnotation.setModule((Profile)ecoreElt, (String)this.objingElt.getOwnerModule().getIdentifier());
        ObjingEAnnotation.addObjingID((Element)ecoreElt, (String)this.objingElt.getIdentifier());
        String name = ProfileUtils.getName((IProfile)this.objingElt);
        ecoreElt.setName(name);
    }

    public List<PExportProfile> getSubProfiles() {
        ArrayList<PExportProfile> subProfiles = new ArrayList<PExportProfile>();
        for (IModelTree sub : this.objingElt.getOwnedElement()) {
            if (!(sub instanceof IProfile)) continue;
            PExportProfile temp = new PExportProfile((IProfile)sub);
            subProfiles.add(temp);
        }
        return subProfiles;
    }

    public List<PExportStereotype> getStereotypes() {
        ArrayList<PExportStereotype> result = new ArrayList<PExportStereotype>();
        for (IStereotype sub : this.objingElt.getDefinedStereotype()) {
            if (!ObjingModelNavigation.mustBeExported((IStereotype)sub)) continue;
            PExportStereotype temp = new PExportStereotype(sub);
            result.add(temp);
        }
        return result;
    }

    public List<PExportReference> getReferences() {
        ArrayList<PExportReference> result = new ArrayList<PExportReference>();
        for (IMetaclassReference sub : this.objingElt.getOwnedReference()) {
            PExportReference temp = new PExportReference(sub);
            result.add(temp);
        }
        return result;
    }

    public IProfile getObjElt() {
        return this.objingElt;
    }

    private void attach(Profile ecoreElt) {
        GenerationProperties genProp = GenerationProperties.getInstance();
        if (this.objingElt.getOwner() instanceof IProfile) {
            Profile ecoreOwner = (Profile)genProp.getMappedElement((IElement)this.objingElt.getOwner());
            ecoreOwner.getPackagedElements().add((Object)ecoreElt);
        } else {
            IProfile owner = ProfileUtils.getProfileOwner((IProfile)this.objingElt);
            Profile ecoreOwner = null;
            if (owner != null && owner instanceof IProfile) {
                PExportProfile export = new PExportProfile(owner);
                export.visit();
                ecoreOwner = (Profile)genProp.getMappedElement((IElement)owner);
                if (ecoreOwner != null && !ecoreOwner.equals(ecoreElt)) {
                    ecoreOwner.getPackagedElements().add((Object)ecoreElt);
                }
            }
        }
    }
}

