/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.model.objing.profile;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IMetaclassReference;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INoteType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagType;
import com.modeliosoft.modelio.xmi.generation.ProfileExportVisitorImpl;
import com.modeliosoft.modelio.xmi.generation.TotalExportMap;
import com.modeliosoft.modelio.xmi.model.objing.profile.IExportProfileElement;
import com.modeliosoft.modelio.xmi.model.objing.profile.PExportAttribut;
import com.modeliosoft.modelio.xmi.model.objing.profile.PExportNoteType;
import com.modeliosoft.modelio.xmi.util.ObjingEAnnotation;
import com.modeliosoft.modelio.xmi.util.ObjingModelNavigation;
import com.modeliosoft.modelio.xmi.util.ProfileUtils;
import com.modeliosoft.modelio.xmi.util.UMLMetamodel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class PExportReference
implements IExportProfileElement {
    private IMetaclassReference objingElt = null;
    private TotalExportMap totalMap = TotalExportMap.getInstance();

    public PExportReference(IMetaclassReference reference) {
        this.objingElt = reference;
    }

    public void accept(ProfileExportVisitorImpl visitor) {
        visitor.visit(this);
    }

    private Stereotype createEcoreStereotype() {
        Profile profile = (Profile)this.totalMap.get(this.objingElt.getOwnerProfile().getIdentifier());
        Stereotype stereotype = ProfileUtils.createStereotype((IMetaclassReference)this.objingElt, (Profile)profile);
        ObjingEAnnotation.setReference((Element)stereotype, (boolean)true);
        return stereotype;
    }

    private void setProperties(Stereotype stereotype) {
        this.setInheritance(stereotype);
        ObjingEAnnotation.addObjingID((Element)stereotype, (String)this.objingElt.getIdentifier());
    }

    private void setInheritance(Stereotype stereotype) {
        Profile profile = (Profile)this.totalMap.get(this.objingElt.getOwnerProfile().getIdentifier());
        Stereotype stereotypeEcore = (Stereotype)this.totalMap.get(this.objingElt.getIdentifier());
        for (String newMetaclassName : ProfileUtils.getEcoreNameClass((String)this.objingElt.getReferencedClassName())) {
            Class metaclassClass = (Class)UMLMetamodel.getInstance().getUMLMetamodel().getOwnedType(newMetaclassName);
            boolean found = false;
            Class reference = metaclassClass;
            for (Object metaclass : profile.getMetaclassReferences()) {
                if (!((Class)((ElementImport)metaclass).getImportedElement()).getName().equals(metaclassClass.getName())) continue;
                reference = (Class)((ElementImport)metaclass).getImportedElement();
                found = true;
            }
            if (!found) {
                profile.createMetaclassReference((PackageableElement)reference);
                stereotypeEcore.createExtension(reference, false);
                continue;
            }
            boolean typed = false;
            for (Object extension : reference.getExtensions()) {
                for (Object extensionEnd : ((Extension)extension).getOwnedEnds()) {
                    if (!((Property)extensionEnd).getType().equals(stereotypeEcore)) continue;
                    typed = true;
                }
            }
            if (typed) continue;
            stereotypeEcore.createExtension(reference, false);
        }
    }

    public List<PExportAttribut> getAttribute() {
        ArrayList<PExportAttribut> result = new ArrayList<PExportAttribut>();
        for (ITagType part : this.objingElt.getDefinedTagType()) {
            PExportAttribut attribut = new PExportAttribut(part);
            result.add(attribut);
        }
        return result;
    }

    public List<PExportNoteType> getNoteTypes() {
        ArrayList<PExportNoteType> result = new ArrayList<PExportNoteType>();
        for (INoteType part : this.objingElt.getDefinedNoteType()) {
            PExportNoteType attribut = new PExportNoteType(part);
            result.add(attribut);
        }
        return result;
    }

    public IElement getElt() {
        return this.objingElt;
    }

    public void visit() {
        Stereotype ecoreElt = (Stereotype)this.totalMap.get(this.objingElt.getIdentifier());
        if (ecoreElt == null && ObjingModelNavigation.mustBeExported((IMetaclassReference)this.objingElt)) {
            ecoreElt = this.createEcoreStereotype();
            this.totalMap.put(this.objingElt.getIdentifier(), (Element)ecoreElt);
            this.setProperties(ecoreElt);
        }
    }
}

