/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.model.objing.profile;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INoteType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IProfile;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagParameter;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITaggedValue;
import com.modeliosoft.modelio.xmi.generation.ProfileExportVisitorImpl;
import com.modeliosoft.modelio.xmi.generation.TotalExportMap;
import com.modeliosoft.modelio.xmi.model.objing.profile.IExportProfileElement;
import com.modeliosoft.modelio.xmi.model.objing.profile.PExportAttribut;
import com.modeliosoft.modelio.xmi.model.objing.profile.PExportNoteType;
import com.modeliosoft.modelio.xmi.model.objing.profile.PExportProfile;
import com.modeliosoft.modelio.xmi.util.GenerationProperties;
import com.modeliosoft.modelio.xmi.util.ObjingEAnnotation;
import com.modeliosoft.modelio.xmi.util.ObjingModelNavigation;
import com.modeliosoft.modelio.xmi.util.ProfileUtils;
import com.modeliosoft.modelio.xmi.util.ResourceLoader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public class PExportStereotype
implements IExportProfileElement {
    private IStereotype objingElt = null;
    private GenerationProperties genProp = GenerationProperties.getInstance();
    private TotalExportMap totalMap = TotalExportMap.getInstance();
    private ProfileExportVisitorImpl _visitor = null;

    public PExportStereotype(IStereotype stereotype) {
        this.objingElt = stereotype;
    }

    public void accept(ProfileExportVisitorImpl visitor) {
        this._visitor = visitor;
        visitor.visit(this);
    }

    private Stereotype createEcoreStereotype() {
        return ProfileUtils.createStereotype((IStereotype)this.objingElt);
    }

    private void setProperties(Stereotype stereotype) {
        this.setInheritance(stereotype);
        ObjingEAnnotation.addObjingID((Element)stereotype, (String)this.objingElt.getIdentifier());
        if (this.genProp.isRoundtripEnabled()) {
            this.setHidden(stereotype);
            this.setLabel(stereotype);
            this.setBaseClass(stereotype);
        }
    }

    private void setLabel(Stereotype stereotype) {
        ObjingEAnnotation.setLabel((Element)stereotype, (String)this.objingElt.getLabel());
    }

    private void setHidden(Stereotype stereotype) {
        ObjingEAnnotation.setHidden((Element)stereotype, (boolean)this.objingElt.isHidden());
    }

    private void setIcon(Stereotype stereotype) {
        String iconPath = null;
        String smallIconPath = null;
        String explorerIconPath = null;
        for (ITaggedValue tag : this.objingElt.getTag()) {
            String typeName = tag.getDefinition().getName();
            if (typeName.equals("icon")) {
                for (ITagParameter actual : tag.getActual()) {
                    iconPath = actual.getValue();
                }
                continue;
            }
            if (typeName.equals("smallIcon")) {
                for (ITagParameter actual : tag.getActual()) {
                    smallIconPath = actual.getValue();
                }
                continue;
            }
            if (!typeName.equals("explorerIcon")) continue;
            for (ITagParameter actual : tag.getActual()) {
                explorerIconPath = actual.getValue();
            }
        }
        String genroot = ResourceLoader.getInstance().getProjectRoot();
        if (iconPath != null && !iconPath.equals("")) {
            ProfileUtils.setStereotypeImage((String)(String.valueOf(genroot) + iconPath), (Stereotype)stereotype);
        } else if (smallIconPath != null && !smallIconPath.equals("")) {
            ProfileUtils.setStereotypeImage((String)(String.valueOf(genroot) + smallIconPath), (Stereotype)stereotype);
        } else if (explorerIconPath != null && !explorerIconPath.equals("")) {
            ProfileUtils.setStereotypeImage((String)(String.valueOf(genroot) + explorerIconPath), (Stereotype)stereotype);
        }
    }

    private void setInheritance(Stereotype stereotype) {
        IStereotype parent = this.objingElt.getParent();
        if (parent != null && ProfileUtils.isInScope((IStereotype)parent)) {
            Stereotype parentEcore = (Stereotype)this.genProp.getMappedElement((IElement)parent);
            if (parentEcore == null) {
                IProfile obParentProfile = this.objingElt.getParent().getOwner();
                PExportProfile parentProfile = new PExportProfile(obParentProfile);
                this._visitor.visit(parentProfile);
                Profile ecoreParentProfile = (Profile)this.genProp.getMappedElement((IElement)obParentProfile);
                Profile ecoreProfile = (Profile)this.genProp.getMappedElement((IElement)this.objingElt.getOwner());
                this.genProp.inverseProfiles(ecoreParentProfile, ecoreProfile);
                parentEcore = (Stereotype)this.genProp.getMappedElement((IElement)parent);
            }
            if (!stereotype.getSuperClasses().contains((Object)parentEcore)) {
                stereotype.getSuperClasses().add((Object)parentEcore);
            }
        }
    }

    public List<PExportAttribut> getAttribute() {
        ArrayList<PExportAttribut> result = new ArrayList<PExportAttribut>();
        for (ITagType part : this.objingElt.getDefinedTagType()) {
            PExportAttribut attribut = new PExportAttribut(part);
            result.add(attribut);
        }
        return result;
    }

    public IElement getElt() {
        return this.objingElt;
    }

    public void visit() {
        Stereotype ecoreElt = (Stereotype)this.totalMap.get(this.objingElt.getIdentifier());
        if (ecoreElt == null && ObjingModelNavigation.mustBeExported((IStereotype)this.objingElt)) {
            ecoreElt = this.createEcoreStereotype();
            this.totalMap.put(this.objingElt.getIdentifier(), (Element)ecoreElt);
            this.setProperties(ecoreElt);
        }
    }

    private void setBaseClass(Stereotype stereotype) {
        ObjingEAnnotation.addBaseClass((Stereotype)stereotype, (String)this.objingElt.getBaseClassName());
    }

    public List<PExportNoteType> getNoteTypes() {
        ArrayList<PExportNoteType> result = new ArrayList<PExportNoteType>();
        for (INoteType part : this.objingElt.getDefinedNoteType()) {
            PExportNoteType attribut = new PExportNoteType(part);
            result.add(attribut);
        }
        return result;
    }
}

