/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.model.objing.sequence;

import com.modeliosoft.modelio.api.model.uml.behavior.common.ISignal;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IGate;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteraction;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteractionFragment;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteractionOperand;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.ILifeline;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IPartDecomposition;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IConstraint;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IDependency;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INote;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.xmi.generation.TotalExportMap;
import com.modeliosoft.modelio.xmi.model.objing.OConstraint;
import com.modeliosoft.modelio.xmi.model.objing.ODependency;
import com.modeliosoft.modelio.xmi.model.objing.OElement;
import com.modeliosoft.modelio.xmi.model.objing.ONote;
import com.modeliosoft.modelio.xmi.model.objing.sequence.MainMapper;
import com.modeliosoft.modelio.xmi.model.objing.sequence.PartDecompositionMapper;
import com.modeliosoft.modelio.xmi.util.CompositionOwnerVisitor;
import com.modeliosoft.modelio.xmi.util.GenerationProperties;
import java.lang.reflect.Method;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.PackageableElement;

public abstract class BaseMapper {
    protected IElement objingElement;
    protected MainMapper mapper;

    public abstract Element createEcoreElt();

    public BaseMapper(IElement param, MainMapper mapper) {
        GenerationProperties genProp = GenerationProperties.getInstance();
        this.objingElement = param;
        if (!genProp.isMappedElement(param)) {
            this.mapper = mapper;
            Element ecoreElt = this.createEcoreElt();
            if (!(this.objingElement instanceof IOperation) && !(this.objingElement instanceof ISignal)) {
                TotalExportMap.getInstance().put(this.objingElement.getIdentifier(), ecoreElt);
            }
            this.setName(ecoreElt);
            this.attach(ecoreElt);
            this.setProperties(ecoreElt);
            if (this.objingElement instanceof IModelElement) {
                this.setCommonRelations(ecoreElt);
            }
        }
    }

    public abstract void attach(Element var1);

    public abstract void setProperties(Element var1);

    public void attachInteractionFragment(Element ecoreElt) {
        GenerationProperties genProp = GenerationProperties.getInstance();
        ObList objingLifeline = ((IInteractionFragment)this.objingElement).getCovered();
        IInteraction interaction = this.getInteraction((IInteractionFragment)this.objingElement);
        IInteractionOperand interactionOperand = ((IInteractionFragment)this.objingElement).getEnclosingOperand();
        if (interaction != null || interactionOperand != null) {
            InteractionOperand ecoreInteractionOperand;
            for (ILifeline lifeline : objingLifeline) {
                Lifeline ecoreLifeline = (Lifeline)genProp.getMappedElement((IElement)lifeline);
                if (ecoreLifeline == null) continue;
                try {
                    ecoreLifeline.getCoveredBys().add((Object)((InteractionFragment)ecoreElt));
                }
                catch (ArrayStoreException e) {
                    e.printStackTrace();
                }
            }
            if (interaction != null) {
                Interaction ecoreInteraction = (Interaction)genProp.getMappedElement((IElement)interaction);
                if (ecoreInteraction != null) {
                    this.addFragementToInteraction(ecoreInteraction, ecoreElt);
                }
            } else if (interactionOperand != null && (ecoreInteractionOperand = (InteractionOperand)genProp.getMappedElement((IElement)interactionOperand)) != null) {
                this.addFragementToInteractionOperand(ecoreInteractionOperand, ecoreElt);
            }
        }
    }

    protected IInteraction getInteraction(IInteractionFragment objingElement) {
        return objingElement.getEnclosingInteraction();
    }

    protected void addFragementToInteraction(Interaction ecoreInteraction, Element ecoreElt) {
        if (ecoreInteraction != null && ecoreElt instanceof InteractionFragment) {
            ecoreInteraction.getFragments().add((Object)((InteractionFragment)ecoreElt));
        }
    }

    protected void attachEvent(OccurrenceSpecification ecoreOccSpec, Element ecoreElt) {
        if (ecoreOccSpec != null && ecoreElt instanceof PackageableElement) {
            EList list = ecoreOccSpec.getNearestPackage().getPackagedElements();
            int size = list.size();
            if (size > 0) {
                PackageableElement last = (PackageableElement)list.get(list.size() - 1);
                if (last.getClass().equals(ecoreElt.getClass()) && last.getName().equals(((PackageableElement)ecoreElt).getName())) {
                    list.remove((Object)last);
                    last.destroy();
                }
                list.add((Object)((PackageableElement)ecoreElt));
            } else {
                list.add((Object)((PackageableElement)ecoreElt));
            }
        }
    }

    protected IInteraction getOwnerInteraction(IElement objingElement) {
        CompositionOwnerVisitor ownerVisitor = this.mapper.getGenericOwner();
        IElement owner = ownerVisitor.getCompositionOwner(objingElement);
        while (owner != null && !(owner instanceof IInteraction)) {
            owner = ownerVisitor.getCompositionOwner(owner);
        }
        if (owner == null) {
            if (objingElement instanceof IGate && ((IGate)objingElement).getOwnerUse() instanceof IPartDecomposition) {
                return PartDecompositionMapper.getIInteraction((IPartDecomposition)((IPartDecomposition)((IGate)objingElement).getOwnerUse()));
            }
            if (objingElement instanceof IPartDecomposition) {
                return PartDecompositionMapper.getIInteraction((IPartDecomposition)((IPartDecomposition)objingElement));
            }
        }
        return (IInteraction)owner;
    }

    protected void addFragementToInteractionOperand(InteractionOperand ecoreInteractionOperand, Element ecoreElt) {
        if (ecoreElt instanceof InteractionFragment) {
            ecoreInteractionOperand.getFragments().add((Object)((InteractionFragment)ecoreElt));
        }
    }

    private void setName(Element element) {
        try {
            Method methode = this.objingElement.getClass().getMethod("getName", null);
            String mame = (String)methode.invoke((Object)this.objingElement, new Object[0]);
            Object[] params = new Object[]{mame};
            methode = element.getClass().getMethod("setName", String.class);
            methode.invoke((Object)element, params);
        }
        catch (Exception e) {
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
        }
    }

    private void setCommonRelations(Element ecoreElt) {
        this.setNotes();
        this.setStereotypes();
        this.setDependencies();
        this.setConstraints();
    }

    private void setStereotypes() {
        new OElement(this.objingElement);
    }

    private void setDependencies() {
        Element ecoreDep;
        ODependency odep;
        for (IDependency dep : ((IModelElement)this.objingElement).getDependsOnDependency()) {
            if (GenerationProperties.getInstance().getMappedElement((IElement)dep.getImpacted()) == null) continue;
            odep = new ODependency(dep);
            ecoreDep = GenerationProperties.getInstance().getMappedElement((IElement)dep);
            if (ecoreDep == null) {
                ecoreDep = odep.createEcoreElt();
            }
            odep.attach(ecoreDep, new CompositionOwnerVisitor());
            odep.setProperties(ecoreDep);
        }
        for (IDependency dep : ((IModelElement)this.objingElement).getImpactedDependency()) {
            if (GenerationProperties.getInstance().getMappedElement((IElement)dep.getDependsOn()) == null) continue;
            odep = new ODependency(dep);
            ecoreDep = GenerationProperties.getInstance().getMappedElement((IElement)dep);
            if (ecoreDep == null) {
                ecoreDep = odep.createEcoreElt();
            }
            odep.attach(ecoreDep, new CompositionOwnerVisitor());
            odep.setProperties(ecoreDep);
        }
    }

    private void setConstraints() {
        for (IConstraint constraint : ((IModelElement)this.objingElement).getConstraintDefinition()) {
            boolean allExist = true;
            for (IModelElement constrainted : constraint.getConstrainedElement()) {
                if (GenerationProperties.getInstance().getMappedElement((IElement)constrainted) != null) continue;
                allExist = false;
                break;
            }
            if (!allExist) continue;
            OConstraint oConstraint = new OConstraint(constraint);
            Element ecoreConstraint = GenerationProperties.getInstance().getMappedElement((IElement)constraint);
            if (ecoreConstraint == null) {
                ecoreConstraint = oConstraint.createEcoreElt();
            }
            oConstraint.attach(ecoreConstraint, new CompositionOwnerVisitor());
            oConstraint.setProperties(ecoreConstraint);
        }
    }

    private void setNotes() {
        for (INote note : ((IModelElement)this.objingElement).getDescriptor()) {
            ONote oNote = new ONote(note);
            Element ecoreNote = GenerationProperties.getInstance().getMappedElement((IElement)note);
            if (ecoreNote == null) {
                ecoreNote = oNote.createEcoreElt();
            }
            oNote.attach(ecoreNote, new CompositionOwnerVisitor());
            oNote.setProperties(ecoreNote);
        }
    }
}

