/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.preferences;

import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.ui.ktable.types.BooleanType;
import com.modeliosoft.modelio.core.ui.ktable.types.IPropertyType;
import com.modeliosoft.modelio.core.ui.ktable.types.ListStringType;
import com.modeliosoft.modelio.core.ui.ktable.types.StringType;
import com.modeliosoft.modelio.xmi.plugin.XMI;
import com.modeliosoft.modelio.xmi.preferences.IPreferencesModel;
import com.modeliosoft.modelio.xmi.preferences.PreferenceData;
import java.util.ArrayList;
import java.util.List;

public class XmiPreferenceModel
implements IPreferencesModel {
    private List<PreferenceData> data = null;
    private StringType labelStringType = null;
    private ListStringType compatibilityListType = null;
    private ListStringType extensionListType = null;
    private BooleanType checkType = null;

    public XmiPreferenceModel(IModelingSession modelingSession, List<PreferenceData> data) {
        this.data = data;
        this.labelStringType = new StringType(false);
        this.checkType = new BooleanType();
        List compatibilityItems = this.getDefaultCompatibilities();
        this.compatibilityListType = new ListStringType(false, compatibilityItems);
        List extensionItems = this.getDefaultExtensions();
        this.extensionListType = new ListStringType(false, extensionItems);
    }

    private List<String> getDefaultExtensions() {
        ArrayList<String> defaultExtensions = new ArrayList<String>();
        defaultExtensions.add(XMI.I18N.getString("Ui.Parameter.Extension.XMI"));
        defaultExtensions.add(XMI.I18N.getString("Ui.Parameter.Extension.UML"));
        return defaultExtensions;
    }

    private List<String> getDefaultCompatibilities() {
        ArrayList<String> defaultCompatibilities = new ArrayList<String>();
        defaultCompatibilities.add("UML211");
        defaultCompatibilities.add("UML22");
        defaultCompatibilities.add("UML23");
        defaultCompatibilities.add("UML241");
        defaultCompatibilities.add("EMF300");
        return defaultCompatibilities;
    }

    public int getColumnNumber() {
        return 2;
    }

    public String getDescriptionKey(int row) {
        if (row > 0) {
            return String.valueOf(((PreferenceData)this.data.get(row)).getKey()) + ".Description";
        }
        return null;
    }

    public int getRowsNumber() {
        return this.data.size();
    }

    public IPropertyType getTypeAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.labelStringType;
            }
            case 1: {
                switch (row) {
                    case 0: {
                        return this.labelStringType;
                    }
                    case 1: {
                        return this.checkType;
                    }
                    case 2: {
                        return this.compatibilityListType;
                    }
                    case 3: {
                        return this.extensionListType;
                    }
                }
                return null;
            }
        }
        return null;
    }

    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return String.valueOf(((PreferenceData)this.data.get(row)).getKey()) + ".Label";
            }
            case 1: {
                if (row == 0) {
                    return String.valueOf(((PreferenceData)this.data.get(row)).getValue()) + ".Value";
                }
                return ((PreferenceData)this.data.get(row)).getValue();
            }
        }
        return null;
    }

    public boolean isEditable(int row, int col) {
        switch (col) {
            case 0: {
                return false;
            }
            case 1: {
                switch (row) {
                    case 0: {
                        return false;
                    }
                    case 1: {
                        return true;
                    }
                    case 2: {
                        return true;
                    }
                    case 3: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public void setValueAt(int row, int col, Object value) {
        switch (col) {
            case 0: {
                return;
            }
            case 1: {
                if (row == 1) {
                    ((PreferenceData)this.data.get(row)).setValue(value.toString());
                } else if (row != 0) {
                    ((PreferenceData)this.data.get(row)).setValue((String)value);
                }
                return;
            }
        }
    }
}

