/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.preferences;

import com.modeliosoft.modelio.api.ui.UIColor;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.IProjectPropertiesService;
import com.modeliosoft.modelio.xmi.plugin.XMI;
import com.modeliosoft.modelio.xmi.preferences.IPreferencesModel;
import com.modeliosoft.modelio.xmi.preferences.KTableModel;
import com.modeliosoft.modelio.xmi.preferences.PreferenceData;
import com.modeliosoft.modelio.xmi.preferences.XmiPreferenceModel;
import com.modeliosoft.modelio.xmi.preferences.XmiPreferencePage;
import de.kupzog.ktable.KTable;
import de.kupzog.ktable.KTableCellSelectionListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class XmiPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    KTableModel preferencesModel = null;
    private List<PreferenceData> data = null;
    private IModelingSession modelingSession = null;
    Text descriptionText = null;
    private ScrolledComposite scrolledComposite = null;
    private KTable table = null;

    public XmiPreferencePage() {
        this.noDefaultAndApplyButton();
        this.modelingSession = XMI.getInstance().getModelingSession();
    }

    public XmiPreferencePage(String title) {
        super(title);
        this.noDefaultAndApplyButton();
        this.modelingSession = XMI.getInstance().getModelingSession();
    }

    public XmiPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
        this.noDefaultAndApplyButton();
        this.modelingSession = XMI.getInstance().getModelingSession();
    }

    protected Control createContents(Composite parent) {
        this.createTableViewer(parent);
        this.createDescription(parent);
        return null;
    }

    private void createTableViewer(Composite parent) {
        int tableStyle = 200448;
        this.table = new KTable(parent, 200448);
        GridData tableData = new GridData(4, 4, true, true);
        this.table.setLayoutData((Object)tableData);
        this.initPreferences();
        this.preferencesModel = new KTableModel(this.table, (IPreferencesModel)new XmiPreferenceModel(this.modelingSession, this.data));
        this.table.setModel((de.kupzog.ktable.KTableModel)this.preferencesModel);
        this.table.setSelection(0, 1, true);
        this.table.addCellSelectionListener((KTableCellSelectionListener)new TableSelectionListener(this, null));
    }

    private void createDescription(Composite parent) {
        this.scrolledComposite = new ScrolledComposite(parent, 512);
        GridLayout gl_scrolledComposite = new GridLayout(1, false);
        this.scrolledComposite.setLayout((Layout)gl_scrolledComposite);
        this.descriptionText = new Text((Composite)this.scrolledComposite, 66);
        this.descriptionText.setEditable(false);
        this.descriptionText.setForeground(UIColor.LABEL_TIP_FG);
        GridData gd_descriptionText = new GridData(4, 4, true, true);
        this.descriptionText.setLayoutData((Object)gd_descriptionText);
        this.scrolledComposite.setContent((Control)this.descriptionText);
        Point point = parent.getSize();
        this.scrolledComposite.setMinSize(point);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setExpandHorizontal(true);
        GridData gd_scrolledComposite = new GridData(4, 1024, true, false);
        gd_scrolledComposite.heightHint = 80;
        gd_scrolledComposite.widthHint = 400;
        this.scrolledComposite.setLayoutData((Object)gd_scrolledComposite);
        this.table.addCellSelectionListener((KTableCellSelectionListener)new TableSelectionListener(this, null));
    }

    public void initPreferences() {
        IProjectPropertiesService propertiesService = this.modelingSession.getProjectPropertiesService();
        this.data = new ArrayList();
        String key = null;
        String value = null;
        key = "Preferences.Option";
        value = "Preferences.Option";
        this.data.add(new PreferenceData(key, value));
        key = "Ui.Parameter.CompatibilityActivated";
        value = propertiesService.readProperty("Modelio", key);
        this.data.add(new PreferenceData(key, value));
        key = "Ui.Parameter.VersionExport";
        value = propertiesService.readProperty("Modelio", key);
        this.data.add(new PreferenceData(key, value));
        key = "Ui.Parameter.FileExtension";
        value = propertiesService.readProperty("Modelio", key);
        this.data.add(new PreferenceData(key, value));
    }

    public boolean performOk() {
        IProjectPropertiesService propertiesService = this.modelingSession.getProjectPropertiesService();
        String key = null;
        String value = null;
        for (PreferenceData pref : this.data) {
            key = pref.getKey();
            value = pref.getValue();
            propertiesService.writeProperty("Modelio", key, value);
        }
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
    }
}

