/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.reverse;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.IModelTree;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.api.utils.exceptions.ObElementNotFoundException;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.xmi.gui.ProgressBarComposite;
import com.modeliosoft.modelio.xmi.model.ecore.IEElement;
import com.modeliosoft.modelio.xmi.plugin.XMI;
import com.modeliosoft.modelio.xmi.reverse.PartialImportMap;
import com.modeliosoft.modelio.xmi.reverse.TotalImportMap;
import com.modeliosoft.modelio.xmi.util.ReverseProperties;
import com.modeliosoft.modelio.xmi.util.XMILogs;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;

public class ImportModel {
    private ProgressBarComposite progressBar = null;
    private boolean external = false;

    public void importXMI(IEElement ieelem) {
        Object objingElt;
        PartialImportMap partialCreationMap = PartialImportMap.getInstance();
        TotalImportMap totalCreationMap = TotalImportMap.getInstance();
        boolean isNamespace = false;
        Element ecoreElt = ieelem.getEcoreElement();
        if (ecoreElt instanceof Namespace) {
            isNamespace = true;
        }
        if ((objingElt = totalCreationMap.get((Object)ecoreElt)) == null) {
            objingElt = partialCreationMap.get(ecoreElt);
            if (objingElt == null && this.isMapperOfCurrentElt(this.getCurrentClassName(ieelem), ieelem.getEcoreElement())) {
                objingElt = ieelem.createObjingElt();
                if (objingElt != null) {
                    partialCreationMap.put(ecoreElt, objingElt);
                }
                if (isNamespace && this.progressBar != null) {
                    this.progressBar.addValue();
                    this.progressBar.addElement();
                }
            }
            if (objingElt != null) {
                this.setMapping(objingElt, ieelem);
                partialCreationMap.remove((Object)ecoreElt);
                totalCreationMap.put((Object)ecoreElt, objingElt);
                if (this.progressBar != null) {
                    this.progressBar.addElement();
                    if (isNamespace) {
                        this.progressBar.addValue();
                    }
                }
            }
        }
    }

    public ImportModel(ProgressBarComposite progressBar) {
        this.progressBar = progressBar;
    }

    private void setMapping(Object objingElt, IEElement ieelem) {
        XMILogs log = XMILogs.getInstance();
        try {
            if (objingElt != null && objingElt instanceof IElement && ((IElement)objingElt).getElementStatus().isModifiable()) {
                if (this.external) {
                    if (objingElt instanceof IModelTree) {
                        ((IModelTree)objingElt).setOwner((IModelTree)ReverseProperties.getInstance().getExternalPackage());
                        this.external = false;
                    }
                } else {
                    ieelem.attach((IElement)objingElt);
                }
                ieelem.setProperties((IElement)objingElt);
                ieelem.setStereotypes();
            } else if (objingElt instanceof ArrayList) {
                ieelem.attach((List)((ArrayList)objingElt));
                for (IElement elt : (ArrayList)objingElt) {
                    if (!elt.getElementStatus().isModifiable()) continue;
                    ieelem.setProperties(elt);
                    ieelem.setStereotypes();
                }
            }
        }
        catch (ObElementNotFoundException e) {
            String eltName = "";
            if (ieelem.getEcoreElement() instanceof NamedElement) {
                eltName = ((NamedElement)ieelem.getEcoreElement()).getName();
            }
            log.writelnInLog(XMI.I18N.getMessage("logFile.warning.import.unknowObjingElement", new String[]{eltName, ieelem.getEcoreElement().getClass().getCanonicalName()}));
        }
        catch (InvalidModelManipulationException e) {
            if (objingElt != null && objingElt instanceof IModelElement) {
                String eltName = ((IModelElement)objingElt).getName();
                log.writelnInLog(XMI.I18N.getMessage("logFile.warning.import.invalidObjingModelManipulation", new String[]{eltName, objingElt.getClass().getCanonicalName()}));
            }
        }
        catch (RuntimeException e) {
            if ("Joni Element Not Found".equals(e.getMessage())) {
                PartialImportMap.getInstance().remove((Object)ieelem.getEcoreElement());
            }
            LOG.warning((String)"org.modelio.xmi.internal", (Throwable)e);
        }
    }

    private String getCurrentClassName(IEElement ieelem) {
        String name = ieelem.getClass().getSimpleName();
        return name.substring(1, name.length());
    }

    public ImportModel() {
    }

    private boolean isMapperOfCurrentElt(String mapperName, Element ecoreElement) {
        String ecoreEltName = ecoreElement.getClass().getSimpleName();
        return ecoreEltName.contains(mapperName);
    }
}

