/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.util;

import com.modeliosoft.modelio.core.log.LOG;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Parseur {
    private DocumentBuilderFactory factory;
    private DocumentBuilder builder;
    private Document doc;
    private Element nroot;
    private File file;

    public Parseur(File file) {
        try {
            this.factory = DocumentBuilderFactory.newInstance();
            this.builder = this.factory.newDocumentBuilder();
            this.doc = this.builder.parse(file);
            this.nroot = this.doc.getDocumentElement();
            this.file = file;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void clean() {
        if (this.isEAModel()) {
            this.deleteDefaultValues();
            this.deleteEAnone();
            this.deleteNoAnnotatedElement();
            this.deleteWriteVariableAction();
            this.ecrireDocument();
        }
    }

    private boolean isEAModel() {
        boolean isEAModel = false;
        NodeList listeparcours = this.nroot.getElementsByTagName("xmi:Documentation");
        int nbparcours = listeparcours.getLength();
        int i = 0;
        while (i < nbparcours) {
            Element e = (Element)listeparcours.item(i);
            if (e != null && e.hasAttribute("exporter") && e.getAttribute("exporter").equals("Enterprise Architect")) {
                isEAModel = true;
            }
            ++i;
        }
        return isEAModel;
    }

    private void deleteDefaultValues() {
        NodeList listeparcours = this.nroot.getElementsByTagName("defaultValue");
        int nbparcours = listeparcours.getLength();
        int i = 0;
        while (i < nbparcours) {
            Element e = (Element)listeparcours.item(i);
            if (e != null && !e.hasAttribute("xmi:type")) {
                ((Element)e.getParentNode()).removeAttribute("type");
                e.getParentNode().removeChild(e);
            }
            ++i;
        }
    }

    private void deleteWriteVariableAction() {
        Element e;
        NodeList listeparcours = this.nroot.getElementsByTagName("node");
        ArrayList<String> listId = new ArrayList<String>();
        ArrayList<Element> toDelete = new ArrayList<Element>();
        int nbparcours = listeparcours.getLength();
        int i = 0;
        while (i < nbparcours) {
            e = (Element)listeparcours.item(i);
            if (e.hasAttribute("xmi:type") && e.getAttribute("xmi:type").equals("uml:WriteVariableAction")) {
                NodeList childList = e.getChildNodes();
                int nbChild = childList.getLength();
                int j = 0;
                while (j < nbChild) {
                    Element child = (Element)listeparcours.item(j);
                    if (child.getNodeName().equals("incoming") && child.hasAttribute("xmi:idref")) {
                        listId.add(child.getAttribute("xmi:idref"));
                    } else if (child.getNodeName().equals("output")) {
                        NodeList outputChildList = child.getChildNodes();
                        int nbOutputChild = outputChildList.getLength();
                        int z = 0;
                        while (z < nbOutputChild) {
                            if (child.getNodeName().equals("outgoing") && child.hasAttribute("xmi:idref")) {
                                listId.add(child.getAttribute("xmi:idref"));
                            }
                            ++z;
                        }
                    }
                    ++j;
                }
                toDelete.add(e);
            }
            ++i;
        }
        listeparcours = this.nroot.getElementsByTagName("edge");
        nbparcours = listeparcours.getLength();
        i = 0;
        while (i < nbparcours) {
            e = (Element)listeparcours.item(i);
            if (e != null && e.hasAttribute("xmi:id") && listId.contains(e.getAttribute("xmi:id"))) {
                toDelete.add(e);
            }
            ++i;
        }
        for (Element e2 : toDelete) {
            e2.getParentNode().removeChild(e2);
        }
    }

    private void deleteEAnone() {
        NodeList listeparcours = this.nroot.getElementsByTagName("ownedParameter");
        ArrayList<Element> toDelete = new ArrayList<Element>();
        int nbparcours = listeparcours.getLength();
        int i = 0;
        while (i < nbparcours) {
            Element e = (Element)listeparcours.item(i);
            if (e != null && e.hasAttribute("type") && e.getAttribute("type").equals("EAnone_void")) {
                toDelete.add(e);
            }
            ++i;
        }
        for (Element e : toDelete) {
            e.getParentNode().removeChild(e);
        }
    }

    private void deleteNoAnnotatedElement() {
        NodeList listeparcours = this.nroot.getElementsByTagName("annotatedElement");
        ArrayList<String> listId = new ArrayList<String>();
        int nbparcours = listeparcours.getLength();
        int i = 0;
        while (i < nbparcours) {
            Element e = (Element)listeparcours.item(i);
            if (e.hasAttribute("xmi:idref")) {
                listId.add(e.getAttribute("xmi:idref"));
            }
            ++i;
        }
        List all = this.getAllElement();
        for (Element e : all) {
            if (!e.hasAttribute("xmi:id") || !listId.contains(e.getAttribute("xmi:id"))) continue;
            listId.remove(e.getAttribute("xmi:id"));
        }
        ArrayList<Element> toDelete = new ArrayList<Element>();
        int i2 = 0;
        while (i2 < nbparcours) {
            Element e = (Element)listeparcours.item(i2);
            if (e.hasAttribute("xmi:idref") && listId.contains(e.getAttribute("xmi:idref"))) {
                toDelete.add(e);
            }
            ++i2;
        }
        for (Element e : toDelete) {
            e.getParentNode().removeChild(e);
        }
    }

    private List<Element> getAllElement() {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList nodeList = this.nroot.getChildNodes();
        int nbChild = nodeList.getLength();
        ArrayList<Element> current = new ArrayList<Element>();
        int i = 0;
        while (i < nbChild) {
            if (nodeList.item(i) instanceof Element) {
                current.add((Element)nodeList.item(i));
            }
            ++i;
        }
        List temp = new ArrayList();
        boolean haveChild = true;
        while (haveChild) {
            temp = this.getAllChild(current);
            haveChild = temp.size() != 0;
            result.addAll(current);
            current.clear();
            current.addAll(temp);
            temp.clear();
        }
        return result;
    }

    private void ecrireDocument() {
        DOMSource source = new DOMSource(this.doc);
        StreamResult resultat = new StreamResult(new File(String.valueOf(this.file.getAbsolutePath()) + "test"));
        Transformer transfo = null;
        try {
            transfo = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
        }
        if (transfo != null) {
            transfo.setOutputProperty("method", "xml");
            transfo.setOutputProperty("omit-xml-declaration", "no");
            transfo.setOutputProperty("encoding", "utf-8");
            transfo.setOutputProperty("indent", "yes");
            try {
                transfo.transform(source, resultat);
            }
            catch (TransformerException e) {
                LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
            }
        }
    }

    private List<Element> getAllChild(List<Element> old) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element current : old) {
            NodeList currentChild = current.getChildNodes();
            int nbChild = currentChild.getLength();
            int i = 0;
            while (i < nbChild) {
                if (currentChild.item(i) instanceof Element) {
                    result.add((Element)currentChild.item(i));
                }
                ++i;
            }
        }
        return result;
    }
}

