/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.util;

import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.extension.IProject;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IMetaclassReference;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INoteType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IProfile;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagType;
import com.modeliosoft.modelio.api.model.uml.statik.IClass;
import com.modeliosoft.modelio.api.model.uml.statik.IComponent;
import com.modeliosoft.modelio.api.model.uml.statik.IGeneralization;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.model.uml.statik.IPackage;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.api.utils.StereotypeNotFoundException;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.xmi.generation.TotalExportMap;
import com.modeliosoft.modelio.xmi.model.objing.profile.PExportProfile;
import com.modeliosoft.modelio.xmi.plugin.XMI;
import com.modeliosoft.modelio.xmi.reverse.PartialImportMap;
import com.modeliosoft.modelio.xmi.reverse.TotalImportMap;
import com.modeliosoft.modelio.xmi.util.CompositionOwnerVisitor;
import com.modeliosoft.modelio.xmi.util.EcoreModelNavigation;
import com.modeliosoft.modelio.xmi.util.GenerationProperties;
import com.modeliosoft.modelio.xmi.util.ObjingEAnnotation;
import com.modeliosoft.modelio.xmi.util.PrimitiveTypeMapper;
import com.modeliosoft.modelio.xmi.util.ResourceLoader;
import com.modeliosoft.modelio.xmi.util.ReverseProperties;
import com.modeliosoft.modelio.xmi.util.ScopeChecker;
import com.modeliosoft.modelio.xmi.util.SysMLProfileUtils;
import com.modeliosoft.modelio.xmi.util.UMLMetamodel;
import com.modeliosoft.modelio.xmi.util.XMILogs;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.internal.impl.PrimitiveTypeImpl;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProfileUtils {
    private static String nameSpacingSeparator = "::";
    private static String stereotypeIdSeparator = ";";
    private static CompositionOwnerVisitor ownerVisitor = new CompositionOwnerVisitor();
    private static ScopeChecker scopeChecker = new ScopeChecker((IElement)GenerationProperties.getInstance().getSelectedPackage(), ownerVisitor);

    public static Image getContent(org.eclipse.uml2.uml.Image image) {
        if (image == null) {
            return null;
        }
        if (image.getContent() == null) {
            return null;
        }
        String rawData = image.getContent();
        StringTokenizer strToken = new StringTokenizer(rawData, " ");
        byte[] target = new byte[strToken.countTokens()];
        int j = 0;
        String tempString = null;
        while (strToken.hasMoreTokens()) {
            try {
                tempString = strToken.nextToken();
                Long.valueOf(tempString, 16);
                Byte tempByte = new Byte(Byte.parseByte(tempString, 16));
                target[j] = tempByte;
            }
            catch (NumberFormatException e) {
                int temp = -(Integer.valueOf("ff", 16) - Integer.valueOf(tempString, 16) + 1);
                Byte tempByte = new Byte(String.valueOf(temp));
                tempByte = Byte.decode(String.valueOf(temp));
                target[j] = tempByte;
            }
            ++j;
        }
        Image decodedImage = new Image(null, (InputStream)new ByteArrayInputStream(target));
        return decodedImage;
    }

    public static List<String> getObjingNameClass(String ecoreClassName) {
        List result = ReverseProperties.getInstance().getObjClassNames(ecoreClassName);
        if (result.size() == 0) {
            result.add("ModelElement");
        }
        return result;
    }

    private static List<String> getObjNameClass(java.lang.Class<?> classe, Method methodCreateElt) {
        List<String> result = new ArrayList<String>();
        try {
            Constructor<?> createClasse = null;
            Constructor<?>[] constructorArray = classe.getDeclaredConstructors();
            int n = constructorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor<?> current = constructorArray[n2];
                if (current.getParameterTypes().length == 0) {
                    createClasse = current;
                }
                ++n2;
            }
            methodCreateElt.invoke((Object)UMLFactory.eINSTANCE, null);
            Method methodIjingClass = classe.getMethod("getIjingClassName", new java.lang.Class[0]);
            if (createClasse != null) {
                Object classeInstance = createClasse.newInstance(new Object[0]);
                result = (List)methodIjingClass.invoke(classeInstance, new Object[0]);
            }
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            LOG.warning((String)"org.modelio.xmi.internal", (String)errorMsg);
        }
        if (result.size() == 0) {
            result.add("ModelElement");
        }
        return result;
    }

    public static List<String> getEcoreNameClass(String objClassName) {
        List result = GenerationProperties.getInstance().getEcoreClassNames(objClassName);
        if (result.size() == 0) {
            result.add("Element");
        }
        return result;
    }

    public static Stereotype createStereotype(IStereotype obStereotype) {
        String name;
        Profile profile = (Profile)GenerationProperties.getInstance().getMappedElement((IElement)obStereotype.getOwner());
        Stereotype stereotype = profile.getOwnedStereotype(name = ProfileUtils.getStereotypeName((IStereotype)obStereotype));
        if (stereotype == null) {
            stereotype = profile.createOwnedStereotype(name, false);
            ProfileUtils.setIconsProperties((Stereotype)stereotype, (IStereotype)obStereotype);
            TotalExportMap.getInstance().put(obStereotype.getIdentifier(), (Element)stereotype);
        }
        ObjingEAnnotation.setNamedWithConvention((Stereotype)stereotype, (boolean)ProfileUtils.isNamedWithConvention((IStereotype)obStereotype));
        ObjingEAnnotation.addObjingID((Element)stereotype, (String)obStereotype.getIdentifier());
        return stereotype;
    }

    public static org.eclipse.uml2.uml.Image setStereotypeImage(String iconPath, Stereotype stereotype) {
        try {
            org.eclipse.uml2.uml.Image icon = stereotype.createIcon(iconPath);
            File imageFile = new File(iconPath);
            ProfileUtils.setContent((org.eclipse.uml2.uml.Image)icon, (File)imageFile);
            icon.setFormat(iconPath.substring(iconPath.lastIndexOf(".") + 1, iconPath.length()));
            return icon;
        }
        catch (SWTException e) {
            return null;
        }
    }

    public static String getNameSpaceName(IClass obStereotype) {
        String name = "";
        IPackage owner = (IPackage)obStereotype.getOwner();
        while (!(owner.getOwner() instanceof IComponent)) {
            name = String.valueOf(owner.getName()) + nameSpacingSeparator + name;
            owner = (IPackage)owner.getOwner();
        }
        String temp = obStereotype.getName();
        if (temp.startsWith(name)) {
            return temp;
        }
        return String.valueOf(name) + temp;
    }

    public static String getLocalName(IClass obStereotype) {
        String path = "";
        IPackage owner = (IPackage)obStereotype.getOwner();
        while (!(owner.getOwner() instanceof IComponent)) {
            path = String.valueOf(owner.getName()) + nameSpacingSeparator + path;
            owner = (IPackage)owner.getOwner();
        }
        String name = obStereotype.getName();
        if (name.startsWith(path)) {
            return name.replaceFirst(path, "");
        }
        return name;
    }

    private static void setContent(org.eclipse.uml2.uml.Image image, File imageFile) {
        try {
            String rawImageData = "";
            if (imageFile != null) {
                byte[] byteFlow = ProfileUtils.getBytesFromFile((File)imageFile);
                rawImageData = "";
                int i = 0;
                while (i < byteFlow.length) {
                    rawImageData = String.valueOf(rawImageData) + Integer.toString(byteFlow[i], 16) + " ";
                    ++i;
                }
            } else {
                rawImageData = null;
            }
            image.setContent(rawImageData);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("Image too big to encode");
        }
        byte[] bytes = new byte[(int)length];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    public static List<String> getMetaclassHeritage(INameSpace metaclass) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<Object> parentList = new ArrayList<Object>();
        parentList.add((IClass)metaclass);
        result.add(metaclass.getName());
        while (parentList.size() != 0) {
            ArrayList<IClass> temp = new ArrayList<IClass>();
            for (IClass iClass : parentList) {
                for (IGeneralization generalization : iClass.getParent()) {
                    temp.add((IClass)generalization.getSuperType());
                }
            }
            parentList.clear();
            parentList.addAll(temp);
            for (IClass iClass : parentList) {
                result.add(iClass.getName());
            }
        }
        return result;
    }

    public static String getNameSpacingSeparator() {
        return nameSpacingSeparator;
    }

    private static IMetaclassReference createReference(Stereotype ecoreElt) {
        IMetaclassReference objReference = O.getDefault().getModelingSession().getModelFactory().createMetaclassReference();
        objReference.setReferencedClassName(ecoreElt.getName());
        Object owner = TotalImportMap.getInstance().get((Object)ecoreElt.getOwner());
        if (owner != null && owner instanceof IProfile) {
            ((IProfile)owner).addOwnedReference(objReference);
            objReference.setOwnerProfile((IProfile)owner);
        }
        TotalImportMap.getInstance().put((Object)ecoreElt, (Object)objReference);
        return objReference;
    }

    public static Object visitStereotype(Stereotype ecoreElement) {
        Object temp = TotalImportMap.getInstance().get((Object)ecoreElement);
        if (temp == null) {
            if (ObjingEAnnotation.isReference((Element)ecoreElement)) {
                return ProfileUtils.getReference((Stereotype)ecoreElement);
            }
            return ProfileUtils.createObjStereotype((Stereotype)ecoreElement);
        }
        return temp;
    }

    public static void visitProperty(Property ecoreElement) {
        Object result = TotalImportMap.getInstance().get((Object)ecoreElement);
        if (result == null) {
            Element ecoreOwner = ecoreElement.getOwner();
            Object owner = TotalImportMap.getInstance().get((Object)ecoreOwner);
            if (owner == null && ecoreOwner instanceof Stereotype) {
                ProfileUtils.visitStereotype((Stereotype)((Stereotype)ecoreOwner));
                owner = TotalImportMap.getInstance().get(owner);
            }
            if (owner != null) {
                if (owner instanceof ArrayList) {
                    ProfileUtils.visitStereotype((List)((ArrayList)owner), (Property)ecoreElement);
                } else {
                    ProfileUtils.visitReference((IMetaclassReference)((IMetaclassReference)owner), (Property)ecoreElement);
                }
            }
        }
    }

    private static void setProperties(ITagType tagType, Property ecoreProperty) {
        ProfileUtils.setLabel((ITagType)tagType, (Property)ecoreProperty);
        if (ReverseProperties.getInstance().isRoundtripEnabled()) {
            ProfileUtils.setHidden((ITagType)tagType, (Property)ecoreProperty);
            ProfileUtils.setPartSignature((ITagType)tagType, (Property)ecoreProperty);
        }
    }

    private static void setHidden(ITagType objElt, Property ecoreElement) {
        objElt.setHidden(ObjingEAnnotation.isHidden((Element)ecoreElement));
    }

    private static void setPartSignature(ITagType objElt, Property ecoreElement) {
        objElt.setBelongToPrototype(ObjingEAnnotation.isPartSignature((Element)ecoreElement));
    }

    private static void setLabel(ITagType objElt, Property ecoreElement) {
        String label;
        String name = objElt.getName();
        if (name != null) {
            objElt.setLabel(name);
        }
        if (ReverseProperties.getInstance().isRoundtripEnabled() && (label = ObjingEAnnotation.getLabel((Element)ecoreElement)) != null) {
            objElt.setLabel(label);
        }
    }

    private static boolean needCreation(IMetaclassReference ref) {
        IElementStatus status = ref.getElementStatus();
        return !status.isRamcObject() || status.isModifiable();
    }

    private static void visitReference(IMetaclassReference reference, Property ecoreElement) {
        block4: {
            block5: {
                if (!ProfileUtils.needCreation((IMetaclassReference)reference)) break block5;
                ProfileUtils.createUnderReference((IMetaclassReference)reference, (Property)ecoreElement);
                break block4;
            }
            List objingIds = ObjingEAnnotation.getObjingIDs((Element)ecoreElement);
            if (objingIds.size() <= 0) break block4;
            String objingId = (String)objingIds.get(0);
            if (ObjingEAnnotation.isNoteType((Element)ecoreElement)) {
                for (INoteType tagtype : reference.getDefinedNoteType()) {
                    if (!tagtype.getIdentifier().equals(objingId)) continue;
                    PartialImportMap.getInstance().remove((Object)ecoreElement);
                    TotalImportMap.getInstance().put((Object)ecoreElement, (Object)tagtype);
                    break;
                }
            } else {
                for (ITagType tagtype : reference.getDefinedTagType()) {
                    if (!tagtype.getIdentifier().equals(objingId)) continue;
                    PartialImportMap.getInstance().remove((Object)ecoreElement);
                    TotalImportMap.getInstance().put((Object)ecoreElement, (Object)tagtype);
                    break;
                }
            }
        }
    }

    public static void addExtension(IModelElement objModelElement, Stereotype stereotype) {
        if (!ObjingEAnnotation.isReference((Element)stereotype)) {
            Object imported = ProfileUtils.visitStereotype((Stereotype)stereotype);
            List importedStereotypes = new ArrayList<IStereotype>();
            if (imported instanceof IStereotype) {
                importedStereotypes.add((IStereotype)imported);
            } else if (imported instanceof List) {
                importedStereotypes = (List)imported;
            }
            ObList existingStereotypes = Modelio.getInstance().getModelingSession().getMetamodelExtensions().getStereotypes(objModelElement.getClass());
            boolean notApply = true;
            for (IStereotype existingStereotype : existingStereotypes) {
                if (!importedStereotypes.contains(existingStereotype)) continue;
                objModelElement.addExtension(existingStereotype);
                notApply = false;
                break;
            }
            if (notApply && !ObjingEAnnotation.isReference((Element)stereotype)) {
                String name = stereotype.getName();
                try {
                    IStereotype objStereotype = Modelio.getInstance().getModelingSession().getMetamodelExtensions().getStereotype(objModelElement.getClass(), name);
                    if (!objModelElement.isStereotyped(name)) {
                        objModelElement.addExtension(objStereotype);
                    }
                }
                catch (StereotypeNotFoundException e) {
                    String errorMsg = e.getMessage();
                    LOG.warning((String)"org.modelio.xmi.internal", (String)errorMsg);
                }
            }
        }
    }

    private static void createUnderReference(IMetaclassReference reference, Property ecoreElement) {
        if (reference != null && !reference.getElementStatus().isRamcObject() && !ProfileUtils.exist((IMetaclassReference)reference, (Property)ecoreElement)) {
            if (ObjingEAnnotation.isNoteType((Element)ecoreElement)) {
                ProfileUtils.createNoteType((IMetaclassReference)reference, (Property)ecoreElement);
            } else {
                ProfileUtils.createTagType((IMetaclassReference)reference, (Property)ecoreElement);
            }
        }
    }

    public static IProfile createObjProfile(Profile ecoreElement) {
        IProfile objProfile = (IProfile)TotalImportMap.getInstance().get((Object)ecoreElement);
        if (objProfile == null) {
            if (ecoreElement.getName() != null && ecoreElement.getName().equals("LocalProfile")) {
                block0: for (IModule module : O.getDefault().getModelingSession().getModel().getProject().getInstalled()) {
                    if (!module.getName().equals("LocalModule")) continue;
                    for (IProfile profile : module.getOwnedProfile()) {
                        if (!profile.getName().equals("LocalProfile")) continue;
                        objProfile = profile;
                        continue block0;
                    }
                }
            } else {
                String moduleId = ObjingEAnnotation.getModule((Element)ecoreElement);
                List ids = ObjingEAnnotation.getObjingIDs((Element)ecoreElement);
                if (ids.size() > 0 && (objProfile = (IProfile)Modelio.getInstance().getModelingSession().findElementById("Profile", (String)ids.get(0))) == null) {
                    for (IModule module : O.getDefault().getModelingSession().getModel().getProject().getInstalled()) {
                        if (!module.getIdentifier().equals(moduleId)) continue;
                        for (IProfile ownedProfile : module.getOwnedProfile()) {
                            if (!ownedProfile.getIdentifier().equals(ids.get(0))) continue;
                            objProfile = ownedProfile;
                        }
                    }
                }
                if (objProfile == null) {
                    objProfile = O.getDefault().getModelingSession().getModelFactory().createProfile();
                    ProfileUtils.attach((IProfile)objProfile, (Profile)ecoreElement);
                    ProfileUtils.setProperties((IProfile)objProfile, (Profile)ecoreElement);
                }
            }
            PartialImportMap.getInstance().remove((Object)ecoreElement);
            TotalImportMap.getInstance().put((Object)ecoreElement, (Object)objProfile);
        }
        return objProfile;
    }

    private static void setProperties(IProfile objProfile, Profile ecoreElement) {
        String name = ecoreElement.getName();
        Element owner = ecoreElement.getOwner();
        while (owner instanceof Package) {
            Package ownerPck = (Package)owner;
            name = String.valueOf(ownerPck.getName()) + nameSpacingSeparator + name;
            owner = ownerPck.getOwner();
        }
        if (name != null) {
            objProfile.setName(name);
        }
    }

    private static Object createObjStereotype(Stereotype ecoreElement) {
        IStereotype result;
        List<String> baseClasses = new ArrayList();
        ArrayList<IStereotype> results = new ArrayList<IStereotype>();
        ArrayList parents = new ArrayList();
        List ids = ObjingEAnnotation.getObjingIDs((Element)ecoreElement);
        for (String id : ids) {
            result = (IStereotype)Modelio.getInstance().getModelingSession().findElementById("Stereotype", id);
            if (result == null) continue;
            results.add(result);
        }
        if (results.size() == 0) {
            baseClasses = ObjingEAnnotation.getBaseClass((Element)ecoreElement);
            if (baseClasses.size() == 0) {
                for (Element ownedElt : ecoreElement.getOwnedElements()) {
                    Property ecoreProperty;
                    if (!(ownedElt instanceof Property) || !((ecoreProperty = (Property)ownedElt).getAssociation() instanceof Extension) || !(ecoreProperty.getType() instanceof Class)) continue;
                    String typeName = ecoreProperty.getType().getName();
                    if (typeName == null) {
                        typeName = ((InternalEObject)ecoreProperty.getType()).eProxyURI().fragment();
                    }
                    baseClasses.addAll(ProfileUtils.getObjingNameClass((String)typeName));
                }
            }
            if (baseClasses.size() == 0) {
                baseClasses.add("ModelElement");
            }
            for (String baseClass : baseClasses) {
                result = O.getDefault().getModelingSession().getModelFactory().createStereotype();
                result.setBaseClassName(baseClass);
                for (IStereotype parent : parents) {
                    if (!parent.getBaseClassName().equals(baseClass)) continue;
                    result.setParent(parent);
                    break;
                }
                if (result.getParent() == null && parents.size() != 0) {
                    result.setParent((IStereotype)parents.get(0));
                }
                if (result.getElementStatus().isModifiable()) {
                    ProfileUtils.attach((IStereotype)result, (Stereotype)ecoreElement);
                    ProfileUtils.setProperties((IStereotype)result, (Stereotype)ecoreElement);
                }
                results.add(result);
            }
            ProfileUtils.setName(results, (Stereotype)ecoreElement);
        }
        PartialImportMap.getInstance().remove((Object)ecoreElement);
        TotalImportMap.getInstance().put((Object)ecoreElement, results);
        return results;
    }

    private static void attach(IStereotype objingSterotype, Stereotype ecoreSterotype) {
        Object owner = TotalImportMap.getInstance().get((Object)ecoreSterotype.getOwner());
        if (owner != null && owner instanceof IProfile) {
            ((IProfile)owner).addDefinedStereotype(objingSterotype);
        } else {
            for (IModule module : O.getDefault().getModelingSession().getModel().getProject().getInstalled()) {
                if (!module.getName().equals("LocalModule")) continue;
                for (IProfile profile : module.getOwnedProfile()) {
                    if (!profile.getName().equals("LocalProfile")) continue;
                    profile.addDefinedStereotype(objingSterotype);
                }
            }
        }
    }

    private static void attach(IProfile objProfile, Profile ecoreElement) {
        boolean attach = false;
        IProject projet = O.getDefault().getModelingSession().getModel().getProject();
        String moduleId = ObjingEAnnotation.getModule((Element)ecoreElement);
        if (moduleId != null) {
            for (IModule module : projet.getInstalled()) {
                String profileId;
                List ids;
                if (!module.getIdentifier().equals(moduleId) || (ids = ObjingEAnnotation.getObjingIDs((Element)ecoreElement)).size() <= 0 || (profileId = (String)ids.get(0)) == null) continue;
                for (IProfile profile : module.getOwnedProfile()) {
                    if (!profile.getIdentifier().equals(profileId)) continue;
                    attach = true;
                }
            }
        }
        if (!attach) {
            ReverseProperties.getInstance().getProfileRoot().addOwnedProfile(objProfile);
        }
    }

    private static void setProperties(IStereotype objingElt, Stereotype ecoreElement) {
        ProfileUtils.setInheritance((IStereotype)objingElt, (Stereotype)ecoreElement);
        ProfileUtils.setIcons((IStereotype)objingElt, (Stereotype)ecoreElement);
        ProfileUtils.setLabel((IStereotype)objingElt, (Stereotype)ecoreElement);
        if (ReverseProperties.getInstance().isRoundtripEnabled()) {
            ProfileUtils.setHidden((IStereotype)objingElt, (Stereotype)ecoreElement);
        }
    }

    private static void setName(List<IStereotype> objElts, Stereotype stereotype) {
        String sterName = stereotype.getName();
        if (sterName != null) {
            if (objElts.size() > 1) {
                for (IStereotype objElt : objElts) {
                    objElt.setName(String.valueOf(sterName) + "_" + objElt.getBaseClassName());
                    objElt.setLabel(sterName);
                }
            } else {
                objElts.get(0).setName(sterName);
                objElts.get(0).setLabel(sterName);
            }
        }
    }

    private static void setHidden(IStereotype objElt, Stereotype ecoreElement) {
        if (ReverseProperties.getInstance().isRoundtripEnabled()) {
            objElt.setHidden(ObjingEAnnotation.isHidden((Element)ecoreElement));
        }
    }

    private static void setLabel(IStereotype objElt, Stereotype ecoreElement) {
        String label;
        if (ReverseProperties.getInstance().isRoundtripEnabled() && (label = ObjingEAnnotation.getLabel((Element)ecoreElement)) != null && label.equals("")) {
            objElt.setLabel(label);
        }
    }

    private static void setIcons(IStereotype objElt, Stereotype ecoreElement) {
        EList icons = ecoreElement.getIcons();
        if (icons.size() > 0) {
            if (ReverseProperties.getInstance().isRoundtripEnabled()) {
                for (Object temp : icons) {
                    org.eclipse.uml2.uml.Image icon = (org.eclipse.uml2.uml.Image)temp;
                    String iconType = ObjingEAnnotation.getIconType((Element)icon);
                    if (iconType == null) continue;
                    ProfileUtils.setIcon((IStereotype)objElt, (org.eclipse.uml2.uml.Image)icon, (String)iconType);
                }
            } else {
                ProfileUtils.setIcon((IStereotype)objElt, (org.eclipse.uml2.uml.Image)((org.eclipse.uml2.uml.Image)icons.get(0)), (String)"icon");
                ProfileUtils.setIcon((IStereotype)objElt, (org.eclipse.uml2.uml.Image)((org.eclipse.uml2.uml.Image)icons.get(0)), (String)"explorerIcon");
                ProfileUtils.setIcon((IStereotype)objElt, (org.eclipse.uml2.uml.Image)((org.eclipse.uml2.uml.Image)icons.get(0)), (String)"smallIcon");
            }
        }
    }

    public static void write(Image img, String fileName, String format) throws IOException {
        BufferedImage buffi = ProfileUtils.convertToAWT((ImageData)img.getImageData());
        File outputFile = new File(fileName);
        try {
            outputFile.createNewFile();
            ImageIO.write((RenderedImage)buffi, format, outputFile);
        }
        catch (IOException e) {
            LOG.warning((String)"org.modelio.xmi.internal", (String)"File not Found");
        }
    }

    static BufferedImage convertToAWT(ImageData data) {
        ColorModel colorModel = null;
        PaletteData palette = data.palette;
        if (palette.isDirect) {
            if (data.alphaData == null) {
                colorModel = new DirectColorModel(24, palette.redMask, palette.greenMask, palette.blueMask);
                BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
                WritableRaster raster = bufferedImage.getRaster();
                int[] pixelArray = new int[3];
                int y = 0;
                while (y < data.height) {
                    int x = 0;
                    while (x < data.width) {
                        int pixel = data.getPixel(x, y);
                        RGB rgb = palette.getRGB(pixel);
                        pixelArray[0] = rgb.red;
                        pixelArray[1] = rgb.green;
                        pixelArray[2] = rgb.blue;
                        raster.setPixels(x, y, 1, 1, pixelArray);
                        ++x;
                    }
                    ++y;
                }
                return bufferedImage;
            }
            colorModel = new DirectColorModel(32, palette.redMask, palette.greenMask, palette.blueMask, -16777216);
            BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[4];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int pixel = data.getPixel(x, y);
                    RGB rgb = palette.getRGB(pixel);
                    pixelArray[0] = rgb.red;
                    pixelArray[1] = rgb.green;
                    pixelArray[2] = rgb.blue;
                    pixelArray[3] = data.getAlpha(x, y);
                    raster.setPixels(x, y, 1, 1, pixelArray);
                    ++x;
                }
                ++y;
            }
            return bufferedImage;
        }
        RGB[] rgbs = palette.getRGBs();
        byte[] red = new byte[rgbs.length];
        byte[] green = new byte[rgbs.length];
        byte[] blue = new byte[rgbs.length];
        int i = 0;
        while (i < rgbs.length) {
            RGB rgb = rgbs[i];
            red[i] = (byte)rgb.red;
            green[i] = (byte)rgb.green;
            blue[i] = (byte)rgb.blue;
            ++i;
        }
        colorModel = data.transparentPixel != -1 ? new IndexColorModel(data.depth, rgbs.length, red, green, blue, data.transparentPixel) : new IndexColorModel(data.depth, rgbs.length, red, green, blue);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
        WritableRaster raster = bufferedImage.getRaster();
        int[] pixelArray = new int[1];
        int y = 0;
        while (y < data.height) {
            int x = 0;
            while (x < data.width) {
                int pixel;
                pixelArray[0] = pixel = data.getPixel(x, y);
                raster.setPixel(x, y, pixelArray);
                ++x;
            }
            ++y;
        }
        return bufferedImage;
    }

    private static void setInheritance(IStereotype objElt, Stereotype ecoreElement) {
        for (Stereotype ecoreParent : ProfileUtils.getParent((Stereotype)ecoreElement)) {
            Object parents = ProfileUtils.visitStereotype((Stereotype)ecoreParent);
            objElt.setParent((IStereotype)((ArrayList)parents).get(0));
        }
    }

    private static List<Stereotype> getParent(Stereotype stereotype) {
        ArrayList<Stereotype> result = new ArrayList<Stereotype>();
        for (Object obj : stereotype.getGeneralizations()) {
            Classifier sterParent;
            if (!(obj instanceof Generalization) || !((sterParent = ((Generalization)obj).getGeneral()) instanceof Stereotype)) continue;
            result.add((Stereotype)sterParent);
        }
        return result;
    }

    private static void setIconsProperties(Stereotype stereotype, IStereotype obStereotype) {
        org.eclipse.uml2.uml.Image icon;
        ResourceLoader.getInstance();
        String iconPath = obStereotype.getIcon();
        if (iconPath != null && !iconPath.equals("")) {
            icon = ProfileUtils.setStereotypeImage((String)iconPath, (Stereotype)stereotype);
            ObjingEAnnotation.setIconType((Element)icon, (String)"icon");
        }
        if ((iconPath = obStereotype.getIconBrowser()) != null && !iconPath.equals("")) {
            icon = ProfileUtils.setStereotypeImage((String)iconPath, (Stereotype)stereotype);
            ObjingEAnnotation.setIconType((Element)icon, (String)"explorerIcon");
        }
    }

    private static void setProperties(INoteType attri, Property ecoreElement) {
        ProfileUtils.setLabel((INoteType)attri, (Property)ecoreElement);
        if (ReverseProperties.getInstance().isRoundtripEnabled()) {
            ProfileUtils.setHidden((INoteType)attri, (Property)ecoreElement);
        }
    }

    private static void setHidden(INoteType objElt, Property ecoreElement) {
        objElt.setHidden(ObjingEAnnotation.isHidden((Element)ecoreElement));
    }

    private static void setLabel(INoteType objElt, Property ecoreElement) {
        String label;
        String name = objElt.getName();
        if (name != null) {
            objElt.setLabel(name);
        }
        if (ReverseProperties.getInstance().isRoundtripEnabled() && (label = ObjingEAnnotation.getLabel((Element)ecoreElement)) != null) {
            objElt.setLabel(label);
        }
    }

    private static INoteType createNoteType(IStereotype stereotype, Property ecoreElement) {
        INoteType noteType = O.getDefault().getModelingSession().getModelFactory().createNoteType();
        stereotype.addDefinedNoteType(noteType);
        noteType.setName(ecoreElement.getName());
        ProfileUtils.setProperties((INoteType)noteType, (Property)ecoreElement);
        return noteType;
    }

    private static ITagType createTagType(IStereotype stereotype, Property ecoreElement) {
        String name = ecoreElement.getName();
        Type type = ecoreElement.getType();
        ITagType attr = O.getDefault().getModelingSession().getModelFactory().createTagType();
        stereotype.addDefinedTagType(attr);
        attr.setName(name);
        String max = EcoreModelNavigation.getMultiplicityMax((MultiplicityElement)ecoreElement);
        if (PrimitiveTypeMapper.isBoolean((Type)type) && max.equals("1")) {
            attr.setParamNumber("0");
        } else {
            attr.setParamNumber(max);
        }
        ProfileUtils.setProperties((ITagType)attr, (Property)ecoreElement);
        return attr;
    }

    private static void createNoteType(IMetaclassReference reference, Property ecoreElement) {
        List ids = ObjingEAnnotation.getObjingIDs((Element)ecoreElement);
        INoteType noteType = null;
        if (ids.size() > 0) {
            String id = (String)ids.get(0);
            noteType = (INoteType)Modelio.getInstance().getModelingSession().findElementById("NoteType", id);
        }
        if (noteType == null) {
            noteType = O.getDefault().getModelingSession().getModelFactory().createNoteType();
            reference.addDefinedNoteType(noteType);
            noteType.setName(ecoreElement.getName());
            ecoreElement.getType();
            ProfileUtils.setProperties((INoteType)noteType, (Property)ecoreElement);
        }
    }

    private static ITagType createTagType(IMetaclassReference reference, Property ecoreElement) {
        List ids = ObjingEAnnotation.getObjingIDs((Element)ecoreElement);
        ITagType tagType = null;
        if (ids.size() > 0) {
            tagType = (ITagType)Modelio.getInstance().getModelingSession().findElementById("TagType", (String)ObjingEAnnotation.getObjingIDs((Element)ecoreElement).get(0));
            Type type = ecoreElement.getType();
            String name = ecoreElement.getName();
            if (name != null && !name.equals("") && !name.startsWith("base_") && type != null && tagType == null) {
                String max;
                tagType = O.getDefault().getModelingSession().getModelFactory().createTagType();
                reference.addDefinedTagType(tagType);
                tagType.setName(name);
                if (type.getName() != null && type.getName().equals("Boolean") || type instanceof PrimitiveTypeImpl && ((PrimitiveTypeImpl)type).eProxyURI() != null && ((PrimitiveTypeImpl)type).eProxyURI().fragment().equals("Boolean")) {
                    tagType.setParamNumber("0");
                }
                if ((max = String.valueOf(ecoreElement.getUpper())) != null) {
                    if ("*".equals(max) || max.equals("-1")) {
                        tagType.setParamNumber("*");
                    } else {
                        String min = String.valueOf(ecoreElement.getLower());
                        tagType.setParamNumber(String.valueOf(Integer.valueOf(max) - Integer.valueOf(min)));
                    }
                }
                ProfileUtils.setProperties((ITagType)tagType, (Property)ecoreElement);
            }
        }
        return tagType;
    }

    private static boolean exist(IStereotype stereotype, Property ecoreElement) {
        block4: {
            String name = ecoreElement.getName();
            if (name == null) break block4;
            if (ObjingEAnnotation.isNoteType((Element)ecoreElement)) {
                for (INoteType noteType : stereotype.getDefinedNoteType()) {
                    if (!noteType.getName().equals(name)) continue;
                    return true;
                }
            } else {
                for (ITagType tagtype : stereotype.getDefinedTagType()) {
                    if (!tagtype.getName().equals(name)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean exist(IMetaclassReference reference, Property ecoreElement) {
        block4: {
            String name = ecoreElement.getName();
            if (name == null) break block4;
            if (ObjingEAnnotation.isNoteType((Element)ecoreElement)) {
                for (INoteType noteType : reference.getDefinedNoteType()) {
                    if (!noteType.getName().equals(name)) continue;
                    return true;
                }
            } else {
                for (ITagType tagtype : reference.getDefinedTagType()) {
                    if (!tagtype.getName().equals(name)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean needCreation(List<IStereotype> stereotypes) {
        for (IStereotype ster : stereotypes) {
            IElementStatus status = ster.getElementStatus();
            if (status.isRamcObject() && !status.isModifiable()) continue;
            return true;
        }
        return false;
    }

    private static void visitStereotype(List<IStereotype> stereotypes, Property ecoreElement) {
        if (ProfileUtils.needCreation(stereotypes)) {
            ProfileUtils.createUnderStereotypes(stereotypes, (Property)ecoreElement);
        } else {
            List objingIds = ObjingEAnnotation.getObjingIDs((Element)ecoreElement);
            if (objingIds.size() > 0) {
                String objingId = (String)objingIds.get(0);
                block0: for (IStereotype ster : stereotypes) {
                    if (ObjingEAnnotation.isNoteType((Element)ecoreElement)) {
                        for (INoteType tagtype : ster.getDefinedNoteType()) {
                            if (!tagtype.getIdentifier().equals(objingId)) continue;
                            PartialImportMap.getInstance().remove((Object)ecoreElement);
                            TotalImportMap.getInstance().put((Object)ecoreElement, (Object)tagtype);
                            continue block0;
                        }
                        continue;
                    }
                    for (INoteType tagtype : ster.getDefinedTagType()) {
                        if (!tagtype.getIdentifier().equals(objingId)) continue;
                        PartialImportMap.getInstance().remove((Object)ecoreElement);
                        TotalImportMap.getInstance().put((Object)ecoreElement, (Object)tagtype);
                        continue block0;
                    }
                }
            }
        }
    }

    private static void createUnderStereotypes(List<IStereotype> stereotypes, Property ecoreElement) {
        if (stereotypes != null) {
            ArrayList<Object> results = new ArrayList<Object>();
            for (IStereotype stereotype : stereotypes) {
                if (stereotype.getElementStatus().isRamcObject() || ProfileUtils.exist((IStereotype)stereotype, (Property)ecoreElement)) continue;
                String name = ecoreElement.getName();
                if (ObjingEAnnotation.isNoteType((Element)ecoreElement)) {
                    results.add(ProfileUtils.createNoteType((IStereotype)stereotype, (Property)ecoreElement));
                    continue;
                }
                if (name == null || name.equals("") || name.startsWith("base_") || ecoreElement.getType() == null) continue;
                results.add(ProfileUtils.createTagType((IStereotype)stereotype, (Property)ecoreElement));
            }
            PartialImportMap.getInstance().remove((Object)ecoreElement);
            TotalImportMap.getInstance().put((Object)ecoreElement, results);
        }
    }

    private static void setIcon(IStereotype objElt, org.eclipse.uml2.uml.Image icon, String tag) {
        String format = icon.getFormat();
        String location = icon.getLocation();
        if (format != null && !format.equals("") && location != null && !location.equals("")) {
            File file = new File(location);
            if (!file.exists()) {
                file.mkdirs();
                try {
                    Image image = ProfileUtils.getContent((org.eclipse.uml2.uml.Image)icon);
                    if (image != null) {
                        ProfileUtils.write((Image)image, (String)location, (String)format);
                    }
                }
                catch (SWTException e) {
                    if (e.getMessage().equals("Unsupported or unrecognized format")) {
                        XMILogs xmilogs = XMILogs.getInstance();
                        xmilogs.writelnInLog(XMI.I18N.getMessage("logFile.warning.import.unsupportedFormat", new String[]{location, format}));
                    } else {
                        String errorMsg = e.getMessage();
                        LOG.warning((String)"org.modelio.xmi.internal", (String)errorMsg);
                    }
                }
                catch (IOException e) {
                    String errorMsg = e.getMessage();
                    LOG.warning((String)"org.modelio.xmi.internal", (String)errorMsg);
                }
            }
            if (tag.equals("icon")) {
                objElt.setIcon(location);
            } else if (tag.equals("explorerIcon")) {
                objElt.setIconBrowser(location);
            }
        }
    }

    public static boolean isNamedWithConvention(IStereotype stereotype) {
        if (stereotype.getLabel() != null && stereotype.getBaseClassName() != null) {
            return stereotype.getName().equals(String.valueOf(stereotype.getLabel()) + "_" + stereotype.getBaseClassName());
        }
        return false;
    }

    public static String getStereotypeName(IStereotype stereotype) {
        if (ProfileUtils.isNamedWithConvention((IStereotype)stereotype)) {
            return stereotype.getLabel();
        }
        return stereotype.getName();
    }

    public static String getStereotypeIdSeparator() {
        return stereotypeIdSeparator;
    }

    public static boolean isNamedWithConvention(ITagType tagtype) {
        if (tagtype.getLabel() != null && tagtype.getOwnerStereotype() != null && tagtype.getOwnerStereotype().getBaseClassName() != null) {
            return tagtype.getName().equals(String.valueOf(tagtype.getOwnerStereotype().getLabel()) + "_" + tagtype.getOwnerStereotype().getBaseClassName() + "_" + tagtype.getLabel());
        }
        return false;
    }

    public static String getTagTypeName(ITagType tagtype) {
        if (ProfileUtils.isNamedWithConvention((ITagType)tagtype)) {
            return tagtype.getLabel();
        }
        return tagtype.getName();
    }

    public static void addReference(Stereotype stereotype, String metaclassName) {
        Class metaclassClass = (Class)UMLMetamodel.getInstance().getUMLMetamodel().getOwnedType(metaclassName);
        Profile profile = stereotype.getProfile();
        if (metaclassClass != null) {
            boolean found = false;
            Class reference = metaclassClass;
            for (Object metaclass : profile.getMetaclassReferences()) {
                Class importedClas = (Class)((ElementImport)metaclass).getImportedElement();
                if (importedClas == null) continue;
                String clasname = importedClas.getName();
                String metaClassName = metaclassClass.getName();
                if (metaClassName == null || !clasname.equals(metaClassName)) continue;
                reference = (Class)((ElementImport)metaclass).getImportedElement();
                found = true;
            }
            if (!found) {
                profile.createMetaclassReference((PackageableElement)reference);
                stereotype.createExtension(reference, false);
            } else {
                boolean typed = false;
                for (Object extension : reference.getExtensions()) {
                    for (Object extensionEnd : ((Extension)extension).getOwnedEnds()) {
                        if (!((Property)extensionEnd).getType().equals(stereotype)) continue;
                        typed = true;
                    }
                }
                if (!typed) {
                    stereotype.createExtension(reference, false);
                }
            }
        } else {
            String errorMsg = "Not found correspondance for : " + metaclassName;
            LOG.warning((String)"org.modelio.xmi.internal", (String)errorMsg);
        }
    }

    public static Stereotype createStereotype(IMetaclassReference reference, Profile profile) {
        Stereotype result = profile.createOwnedStereotype(reference.getReferencedClassName(), false);
        ObjingEAnnotation.addObjingID((Element)result, (String)reference.getIdentifier());
        return result;
    }

    public static boolean isInScope(IStereotype stereotype) {
        return scopeChecker.contains((IElement)stereotype);
    }

    public static String getName(IProfile profile) {
        String name = profile.getName();
        if (name.contains(nameSpacingSeparator)) {
            String[] names = name.split(nameSpacingSeparator);
            return names[names.length - 1];
        }
        return name;
    }

    public static IProfile getProfileOwner(IProfile profile) {
        String name = profile.getName();
        IProfile owner = null;
        if (name.contains(nameSpacingSeparator)) {
            String[] names = name.split(nameSpacingSeparator);
            String ownerName = names[0];
            int size = names.length;
            int i = 1;
            while (i < size - 1) {
                ownerName = String.valueOf(ownerName) + nameSpacingSeparator + names[i];
                ++i;
            }
            for (IProfile otherProfile : profile.getOwnerModule().getOwnedProfile()) {
                if (!otherProfile.getName().equals(ownerName)) continue;
                return otherProfile;
            }
        }
        return owner;
    }

    public static List<PExportProfile> getSubProfiles(PExportProfile profile) {
        ArrayList<PExportProfile> result = new ArrayList<PExportProfile>();
        IProfile objProfil = profile.getObjElt();
        for (IProfile subprofile : objProfil.getOwnerModule().getOwnedProfile()) {
            String profileName = objProfil.getName();
            String subProfileName = subprofile.getName();
            if (!subProfileName.contains(profileName) || !subProfileName.replaceAll(profileName, "").contains(nameSpacingSeparator)) continue;
            result.add(new PExportProfile(subprofile));
        }
        return result;
    }

    public static IProfile getProfileRoot(IProfile profile) {
        String name = profile.getName();
        IProfile owner = profile;
        if (name.contains(nameSpacingSeparator)) {
            String[] names = name.split(nameSpacingSeparator);
            String ownerName = names[0];
            for (IProfile otherProfile : profile.getOwnerModule().getOwnedProfile()) {
                if (!otherProfile.getName().equals(ownerName)) continue;
                return otherProfile;
            }
        }
        return owner;
    }

    private static IMetaclassReference getReference(Stereotype ecoreElt) {
        List ids = ObjingEAnnotation.getObjingIDs((Element)ecoreElt);
        if (ids.size() > 0) {
            String id = (String)ids.get(0);
            Object profile = ReverseProperties.getInstance().getMappedElement((Element)ecoreElt.getProfile());
            if (profile != null && profile instanceof IProfile) {
                for (IMetaclassReference reference : ((IProfile)profile).getOwnedReference()) {
                    if (!reference.getIdentifier().equals(id)) continue;
                    return reference;
                }
            }
        }
        return ProfileUtils.createReference((Stereotype)ecoreElt);
    }

    public static Profile createEcoreProfile(IProfile objingElt) {
        Profile ecoreProfile = UMLFactory.eINSTANCE.createProfile();
        ObjingEAnnotation.setModule((Profile)ecoreProfile, (String)objingElt.getOwnerModule().getIdentifier());
        ObjingEAnnotation.addObjingID((Element)ecoreProfile, (String)objingElt.getIdentifier());
        ecoreProfile.setName(ProfileUtils.getName((IProfile)objingElt));
        if (SysMLProfileUtils.isSysML((IElement)objingElt)) {
            GenerationProperties.getInstance().setSysMLApplied();
            ecoreProfile.setName("SysML");
            SysMLProfileUtils.completeSysMLprofile((Profile)ecoreProfile);
            TotalExportMap.getInstance().put(objingElt.getIdentifier(), (Element)ecoreProfile);
        } else {
            GenerationProperties.getInstance().addExportedProfile(ecoreProfile);
        }
        return ecoreProfile;
    }

    public static boolean isAnalystDeployed() {
        for (IModule module : Modelio.getInstance().getModelingSession().getModel().getUmlProject().getInstalled()) {
            if (!module.getIdentifier().equals("87d35db0-2fb3-11e0-b88e-002564c97630")) continue;
            return true;
        }
        return false;
    }
}

