/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.util;

import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.core.log.LOG;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class ResourceLoader {
    private String iconCommonPath = "res" + File.separator + "bmp" + File.separator;
    private static ResourceLoader INSTANCE = null;
    private final String umlResourcesJarName = "org.eclipse.uml2.uml.resources_3.1.1.v201008191505.jar";

    private ResourceLoader() {
    }

    public static ResourceLoader getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ResourceLoader();
        }
        return INSTANCE;
    }

    public Image getImage(String resourceName) {
        Bundle bundle = Platform.getBundle((String)"org.modelio.xmi.internal");
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(String.valueOf(this.iconCommonPath) + resourceName), null);
        File file = null;
        try {
            file = new File(FileLocator.toFileURL((URL)url).getPath());
        }
        catch (IOException e) {
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
        }
        return new Image((Device)Display.getDefault(), file.getAbsolutePath());
    }

    public File getResource(String resourceName) {
        Bundle bundle = Platform.getBundle((String)"org.modelio.xmi.internal");
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("res" + File.separator + resourceName), null);
        File file = null;
        try {
            file = new File(FileLocator.toFileURL((URL)url).getPath());
        }
        catch (IOException e) {
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
        }
        return file;
    }

    public String getUMLRessource() {
        return "jar:file:" + this.getLibraryResource() + "!/";
    }

    public String getProjectRoot() {
        return Modelio.getInstance().getContext().getProjectSpacePath().getAbsolutePath();
    }

    private String getLibraryResource() {
        Bundle bundle = Platform.getBundle((String)"org.modelio.xmi.internal");
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("lib" + File.separator + "org.eclipse.uml2.uml.resources_3.1.1.v201008191505.jar"), null);
        try {
            return FileLocator.toFileURL((URL)url).getPath();
        }
        catch (IOException e) {
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
            return "";
        }
    }

    public File getXMITempFolder() {
        return new File(String.valueOf(this.getProjectRoot()) + File.separator + "mda" + File.separator + "XMI" + File.separator + "temp");
    }
}

