/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.util;

import com.modeliosoft.modelio.api.model.analyst.IRequirement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IDependency;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.utils.StereotypeNotFoundException;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.xmi.generation.TotalExportMap;
import com.modeliosoft.modelio.xmi.util.PrimitiveTypeMapper;
import com.modeliosoft.modelio.xmi.util.ProfileUtils;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

/*
 * Exception performing whole class analysis ignored.
 */
public class SysMLProfileUtils {
    private static String sysmlId = "00bc42a4-0000-1968-0000-000000000000";

    public static boolean isSysML(IElement profile) {
        return profile.getIdentifier().equals(sysmlId);
    }

    public static void completeSysMLprofile(Profile sysMLProfile) {
        SysMLProfileUtils.addRequirementStereotype((Profile)sysMLProfile);
        SysMLProfileUtils.addDeriveStereotype((Profile)sysMLProfile);
        SysMLProfileUtils.addSatisfyStereotype((Profile)sysMLProfile);
        SysMLProfileUtils.addVerifyStereotype((Profile)sysMLProfile);
        SysMLProfileUtils.addSysMLNoteStereotypes((Profile)sysMLProfile);
    }

    private static void addVerifyStereotype(Profile sysMLProfile) {
        Stereotype stereotype = sysMLProfile.createOwnedStereotype("Verify", false);
        ProfileUtils.addReference((Stereotype)stereotype, (String)"Abstraction");
        try {
            IStereotype obStereotype = Modelio.getInstance().getModelingSession().getMetamodelExtensions().getStereotype(IDependency.class, "verify");
            TotalExportMap.getInstance().put(obStereotype.getIdentifier(), (Element)stereotype);
        }
        catch (StereotypeNotFoundException e) {
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
        }
    }

    private static void addSatisfyStereotype(Profile sysMLProfile) {
        Stereotype stereotype = sysMLProfile.createOwnedStereotype("Satisfy", false);
        ProfileUtils.addReference((Stereotype)stereotype, (String)"Abstraction");
        try {
            IStereotype obStereotype = Modelio.getInstance().getModelingSession().getMetamodelExtensions().getStereotype(IDependency.class, "satisfy");
            TotalExportMap.getInstance().put(obStereotype.getIdentifier(), (Element)stereotype);
        }
        catch (StereotypeNotFoundException e) {
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
        }
    }

    private static void addDeriveStereotype(Profile sysMLProfile) {
        Stereotype stereotype = sysMLProfile.createOwnedStereotype("DeriveReqt", false);
        ProfileUtils.addReference((Stereotype)stereotype, (String)"Abstraction");
        try {
            IStereotype obStereotype = Modelio.getInstance().getModelingSession().getMetamodelExtensions().getStereotype(IDependency.class, "derive");
            TotalExportMap.getInstance().put(obStereotype.getIdentifier(), (Element)stereotype);
        }
        catch (StereotypeNotFoundException e) {
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
        }
    }

    private static void addRequirementStereotype(Profile sysMLProfile) {
        Stereotype stereotype = sysMLProfile.createOwnedStereotype("Requirement", false);
        ProfileUtils.addReference((Stereotype)stereotype, (String)"Class");
        try {
            IStereotype obStereotype = Modelio.getInstance().getModelingSession().getMetamodelExtensions().getStereotype(IRequirement.class, "requirement");
            TotalExportMap.getInstance().put(obStereotype.getIdentifier(), (Element)stereotype);
        }
        catch (StereotypeNotFoundException e) {
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
        }
        Property text = stereotype.createOwnedAttribute("Text", (Type)PrimitiveTypeMapper.getString());
        text.setLower(1);
        text.setUpper(1);
        Property id = stereotype.createOwnedAttribute("Id", (Type)PrimitiveTypeMapper.getString());
        id.setLower(1);
        id.setUpper(1);
    }

    private static void addSysMLNoteStereotypes(Profile sysMLProfile) {
        Stereotype rationaleStereotype = sysMLProfile.createOwnedStereotype("Rationale", false);
        ProfileUtils.addReference((Stereotype)rationaleStereotype, (String)"Comment");
        Stereotype problemStereotype = sysMLProfile.createOwnedStereotype("Problem", false);
        ProfileUtils.addReference((Stereotype)problemStereotype, (String)"Comment");
        Stereotype relatedStereotype = sysMLProfile.createOwnedStereotype("RequirementRelated", false);
        ProfileUtils.addReference((Stereotype)relatedStereotype, (String)"NamedElement");
    }
}

