/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.util;

import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.xmi.plugin.XMI;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimeDisplayer {
    private String defaultFormat = XMI.I18N.getString("mdacProperties.timeDisplayer.defaultFormat");
    private static TimeDisplayer INSTANCE;
    private SimpleDateFormat dateFormat;
    private Date beginning = null;

    private TimeDisplayer() {
        boolean error = false;
        try {
            this.dateFormat = new SimpleDateFormat(this.defaultFormat);
        }
        catch (NullPointerException nullE) {
            error = true;
            LOG.error((String)"org.modelio.xmi.internal", (String)XMI.I18N.getString("warning.exception.timeDisplayer.NullPointerException"));
        }
        catch (IllegalArgumentException illegalE) {
            error = true;
            LOG.error((String)"org.modelio.xmi.internal", (String)XMI.I18N.getMessage("warning.exception.timeDisplayer.IllegalArgumentException", new String[]{this.defaultFormat}));
        }
        if (error) {
            this.dateFormat.applyPattern("HH:mm:ss");
        }
    }

    public static TimeDisplayer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TimeDisplayer();
        }
        return INSTANCE;
    }

    public void initialize() {
        this.beginning = null;
    }

    public String getCurrentTime() {
        Date currentDate = new Date();
        if (this.beginning == null) {
            this.beginning = currentDate;
        }
        return this.dateFormat.format(currentDate);
    }
}

