/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.util;

import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.xmi.util.ResourceLoader;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.resource.UMLResource;
import sun.org.mozilla.javascript.internal.WrappedException;

public class UMLMetamodel {
    private static UMLMetamodel INSTANCE = null;
    private static Model umlMetamodel = null;
    private static Model umlLibrary = null;
    private static Model ecoreLibrary = null;

    public Model getUMLMetamodel() {
        if (umlMetamodel == null) {
            umlMetamodel = this.load(URI.createURI((String)"pathmap://UML_METAMODELS/UML.metamodel.uml"));
        }
        return umlMetamodel;
    }

    public Model getUMLLibrary() {
        if (umlLibrary == null) {
            umlLibrary = this.load(URI.createURI((String)"pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml"));
        }
        return umlLibrary;
    }

    public Model getEcoreLibrary() {
        if (ecoreLibrary == null) {
            ecoreLibrary = this.load(URI.createURI((String)"pathmap://UML_LIBRARIES/EcorePrimitiveTypes.library.uml"));
        }
        return ecoreLibrary;
    }

    private Model load(URI uriModel) {
        Model result = null;
        try {
            URI uri = URI.createURI((String)ResourceLoader.getInstance().getUMLRessource());
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("uml", UMLResource.Factory.INSTANCE);
            URIConverter.URI_MAP.put(URI.createURI((String)"pathmap://UML_LIBRARIES/"), uri.appendSegment("libraries").appendSegment(""));
            URIConverter.URI_MAP.put(URI.createURI((String)"pathmap://UML_METAMODELS/"), uri.appendSegment("metamodels").appendSegment(""));
            URIConverter.URI_MAP.put(URI.createURI((String)"pathmap://UML_PROFILES/"), uri.appendSegment("profiles").appendSegment(""));
            ResourceSetImpl resoureSet = new ResourceSetImpl();
            Resource resource = resoureSet.getResource(uriModel, true);
            result = (Model)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
        }
        catch (WrappedException we) {
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)we);
        }
        return result;
    }

    private UMLMetamodel() {
    }

    public static UMLMetamodel getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new UMLMetamodel();
        }
        return INSTANCE;
    }
}

