/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.util;

import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.xmi.api.VersionExport;
import com.modeliosoft.modelio.xmi.plugin.XMI;
import com.modeliosoft.modelio.xmi.util.GenerationProperties;
import com.modeliosoft.modelio.xmi.util.ResourceLoader;
import com.modeliosoft.modelio.xmi.util.XMILogs;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.UnresolvedReferenceException;

/*
 * Exception performing whole class analysis ignored.
 */
public class XMIFileUtils {
    public static void copyFile(File source, File target) {
        block21: {
            FileChannel in = null;
            AbstractInterruptibleChannel out = null;
            if (!source.getAbsolutePath().contentEquals(target.getAbsolutePath())) {
                try {
                    try {
                        in = new FileInputStream(source).getChannel();
                        out = new FileOutputStream(target).getChannel();
                        in.transferTo(0L, in.size(), (WritableByteChannel)((Object)out));
                    }
                    catch (Exception e) {
                        LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e2) {
                                LOG.error((String)"org.modelio.xmi.internal", (Throwable)e2);
                            }
                        }
                        if (out == null) break block21;
                        try {
                            out.close();
                        }
                        catch (IOException e3) {
                            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e3);
                        }
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
                        }
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    public static void changeToUML(String filePath) {
        String tempPath;
        File tempFile;
        File file = new File(filePath);
        LinkedList<String> oldPatterns = new LinkedList<String>();
        LinkedList<String> newPatterns = new LinkedList<String>();
        File xslExportFile = null;
        VersionExport versionExport = GenerationProperties.getInstance().getExportVersion();
        if (versionExport.equals((Object)VersionExport.UML211)) {
            oldPatterns.add("href[\\s]?=[\\s]?\"pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml");
            oldPatterns.add("xmlns:uml[\\s]?=[\\s]?\"http://www.eclipse.org/uml2/3.0.0/UML");
            oldPatterns.add("xsi:schemaLocation[\\s]?=[\\s]?\"");
            newPatterns.add("href=\"http://schema.omg.org/spec/UML/2.1.1/uml.xml");
            newPatterns.add("xmlns:uml=\"http://schema.omg.org/spec/UML/2.1.1");
            newPatterns.add("xsi:schemaLocation=\"http://www.eclipse.org/uml2/3.0.0/UML http://schema.omg.org/spec/UML/2.1.1 ");
            xslExportFile = ResourceLoader.getInstance().getResource("xslt" + File.separator + "export211.xsl");
        } else if (versionExport.equals((Object)VersionExport.UML22)) {
            oldPatterns.add("href[\\s]?=[\\s]?\"pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml");
            oldPatterns.add("xmlns:uml[\\s]?=[\\s]?\"http://www.eclipse.org/uml2/3.0.0/UML");
            oldPatterns.add("xsi:schemaLocation[\\s]?=[\\s]?\"");
            newPatterns.add("href=\"http://schema.omg.org/spec/UML/2.2/uml.xml");
            newPatterns.add("xmlns:uml=\"http://schema.omg.org/spec/UML/2.2");
            newPatterns.add("xsi:schemaLocation=\"http://www.eclipse.org/uml2/3.0.0/UML http://schema.omg.org/spec/UML/2.2 ");
            xslExportFile = ResourceLoader.getInstance().getResource("xslt" + File.separator + "export22.xsl");
        } else if (versionExport.equals((Object)VersionExport.UML23)) {
            oldPatterns.add("href[\\s]?=[\\s]?\"pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml");
            oldPatterns.add("xmlns:uml[\\s]?=[\\s]?\"http://www.eclipse.org/uml2/3.0.0/UML");
            oldPatterns.add("xsi:schemaLocation[\\s]?=[\\s]?\"");
            newPatterns.add("href=\"http://schema.omg.org/spec/20090901/UML.xmi");
            newPatterns.add("xmlns:uml=\"http://www.omg.org/spec/UML/20090901");
            newPatterns.add("xsi:schemaLocation=\"http://www.eclipse.org/uml2/3.0.0/UML http://schema.omg.org/spec/UML/20090901 ");
            xslExportFile = ResourceLoader.getInstance().getResource("xslt" + File.separator + "export23.xsl");
        } else if (versionExport.equals((Object)VersionExport.UML241)) {
            oldPatterns.add("href[\\s]?=[\\s]?\"pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml");
            oldPatterns.add("xmlns:uml[\\s]?=[\\s]?\"http://www.eclipse.org/uml2/3.0.0/UML");
            oldPatterns.add("xsi:schemaLocation[\\s]?=[\\s]?\"");
            newPatterns.add("href=\"http://www.omg.org/spec/UML/20100901/PrimitiveTypes.xmi#");
            newPatterns.add("xmlns:uml=\"http://www.omg.org/spec/UML/20100901");
            newPatterns.add("xsi:schemaLocation=\"http://www.eclipse.org/uml2/3.0.0/UML http://schema.omg.org/spec/UML/20100901 ");
            xslExportFile = ResourceLoader.getInstance().getResource("xslt" + File.separator + "export241.xsl");
        }
        File tempFolder = ResourceLoader.getInstance().getXMITempFolder();
        if (!tempFolder.exists()) {
            tempFolder.mkdirs();
            tempFolder.mkdir();
        }
        if ((tempFile = new File(tempPath = String.valueOf(tempFolder.getAbsolutePath()) + File.separator + file.getName() + ".temp")).exists()) {
            tempFile.delete();
        }
        XMIFileUtils.applyXSLT((String)file.getAbsolutePath(), (String)tempPath, (File)xslExportFile);
        if (file.exists()) {
            file.delete();
        }
        XMIFileUtils.replace((String)tempPath, (String)file.getAbsolutePath(), oldPatterns, newPatterns);
        if (tempFile.exists()) {
            tempFile.delete();
        }
        System.gc();
    }

    public static void removeReferences(String filePath, EList<Resource.Diagnostic> listErrors) {
        String line = "";
        int errorsSize = listErrors.size();
        int currentError = 0;
        Resource.Diagnostic current = (Resource.Diagnostic)listErrors.get(currentError);
        while (!(current instanceof UnresolvedReferenceException) && currentError < errorsSize - 1) {
            current = (Resource.Diagnostic)listErrors.get(++currentError);
        }
        if (currentError < errorsSize && current instanceof UnresolvedReferenceException) {
            String unresolvedRef = ((UnresolvedReferenceException)current).getReference();
            int errorPos = ((UnresolvedReferenceException)current).getLine();
            File file = new File(filePath);
            try {
                File tempFile = new File(String.valueOf(filePath) + ".temp");
                tempFile.createNewFile();
                XMIFileUtils.copyFile((File)file, (File)tempFile);
                file.createNewFile();
                FileWriter output = new FileWriter(filePath);
                FileInputStream fis = new FileInputStream(tempFile);
                BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
                int currentLine = 0;
                while ((line = reader.readLine()) != null) {
                    ++currentLine;
                    while (currentLine == errorPos) {
                        line = line.replaceAll(unresolvedRef, "");
                        if (currentError < errorsSize - 1) {
                            current = (Resource.Diagnostic)listErrors.get(++currentError);
                            while (!(current instanceof UnresolvedReferenceException) && currentError < errorsSize - 1) {
                                current = (Resource.Diagnostic)listErrors.get(++currentError);
                            }
                            if (currentError < errorsSize && current instanceof UnresolvedReferenceException) {
                                unresolvedRef = ((UnresolvedReferenceException)current).getReference();
                                errorPos = ((UnresolvedReferenceException)current).getLine();
                                continue;
                            }
                            errorPos = 0;
                            continue;
                        }
                        errorPos = 0;
                    }
                    output.write(String.valueOf(line) + "\n");
                }
                reader.close();
                output.flush();
                output.close();
                tempFile.delete();
            }
            catch (IOException e) {
                LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
            }
        }
    }

    public static boolean applyXSLT(String oldFilePath, String newFilePath, File XSLTFile) {
        File oldFile = new File(oldFilePath);
        if (oldFile.exists() && oldFile.canRead()) {
            try {
                TransformerFactory tFactory = TransformerFactory.newInstance();
                Transformer transformer = tFactory.newTransformer(new StreamSource(XSLTFile));
                transformer.transform(new StreamSource(oldFilePath), new StreamResult(new FileOutputStream(newFilePath)));
                transformer = null;
                return true;
            }
            catch (TransformerException e) {
                XMILogs.getInstance().writelnInLog(XMI.I18N.getString("fileChooser.dialog.wrongEcoreFormat.description"));
                return false;
            }
            catch (Exception e) {
                LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public static boolean replace(String filePath, List<String> oldPatterns, List<String> newPatterns) {
        File file = new File(filePath);
        if (file.exists() && oldPatterns.size() == newPatterns.size()) {
            int i = 0;
            String filePathTemp = String.valueOf(filePath) + "_" + String.valueOf(i);
            while (new File(filePathTemp).exists()) {
                filePathTemp = String.valueOf(filePath) + "_" + String.valueOf(++i);
            }
            XMIFileUtils.replace((String)filePath, (String)filePathTemp, oldPatterns, newPatterns);
            File fileTemp = new File(filePathTemp);
            file.delete();
            fileTemp.renameTo(file);
            return true;
        }
        return false;
    }

    private static List<String> getAppliedProfiles(String filePath) {
        ArrayList<String> result = new ArrayList<String>();
        String line = "";
        try {
            FileInputStream fis = new FileInputStream(filePath);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
            while ((line = reader.readLine()) != null) {
                if (!line.contains("appliedProfile") || !line.contains(" href=\"") || !line.contains("#") || line.contains("pathmap:")) continue;
                result.add(line.split(" href=\"")[1].split("#")[0]);
            }
            reader.close();
        }
        catch (IOException e) {
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean containsPatterns(File file, List<String> patterns) {
        String line = "";
        int cmpt = 0;
        try {
            FileInputStream fis = new FileInputStream(file.getAbsolutePath());
            BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
            ArrayList<Pattern> listPatterns = new ArrayList<Pattern>();
            for (String oldPattern : patterns) {
                listPatterns.add(Pattern.compile(oldPattern));
            }
            while ((line = reader.readLine()) != null && cmpt < 30) {
                for (Pattern pattern : listPatterns) {
                    if (!pattern.matcher(line).find()) continue;
                    return true;
                }
                ++cmpt;
            }
            reader.close();
            return false;
        }
        catch (IOException e) {
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
        }
        return false;
    }

    public static void replace(String oldFilePath, String newFilePath, List<String> oldPatterns, List<String> newPatterns) {
        String line = "";
        try {
            FileWriter output = new FileWriter(newFilePath);
            FileInputStream fis = new FileInputStream(oldFilePath);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
            ArrayList<Pattern> listPatterns = new ArrayList<Pattern>();
            for (String oldPattern : oldPatterns) {
                listPatterns.add(Pattern.compile(oldPattern));
            }
            while ((line = reader.readLine()) != null) {
                for (Pattern pattern : listPatterns) {
                    line = pattern.matcher(line).replaceAll(newPatterns.get(listPatterns.indexOf(pattern)));
                }
                output.write(String.valueOf(line) + "\n");
            }
            reader.close();
            output.flush();
            output.close();
        }
        catch (FileNotFoundException e) {
            XMILogs.getInstance().writelnInLog(e.getLocalizedMessage());
        }
        catch (IOException e) {
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
        }
    }

    public static List<String> getAllAppliedProfiles(String filePath) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList temp = new ArrayList();
        String directory = new File(filePath).getParent();
        ArrayList appliedProfilescurrent = XMIFileUtils.getAppliedProfiles((String)filePath);
        while (result.size() != appliedProfilescurrent.size()) {
            result.clear();
            temp.clear();
            result.addAll(appliedProfilescurrent);
            temp.addAll(appliedProfilescurrent);
            for (String appliedProfile : result) {
                temp.addAll(XMIFileUtils.getAppliedProfiles((String)(String.valueOf(directory) + File.separator + appliedProfile)));
                appliedProfilescurrent = new ArrayList(new HashSet(temp));
            }
        }
        return result;
    }
}

