/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.util;

import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.xmi.plugin.XMI;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;

public class XMILogs {
    private final String LINE_SEPARATOR = System.getProperty("line.separator");
    private File fileToSave = null;
    private DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2, Locale.getDefault());
    private StringBuffer log = null;
    private static XMILogs INSTANCE = null;
    private boolean empty = true;
    private String logFile = "";
    private List<String> elements = new ArrayList();

    private XMILogs() {
    }

    public static XMILogs getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new XMILogs();
        }
        return INSTANCE;
    }

    public void saveLog() {
        if (this.log != null) {
            this.empty = false;
            String logFilepath = this.fileToSave.getAbsolutePath();
            LOG.error((String)"org.modelio.xmi.internal", (String)XMI.I18N.getMessage("warning.log.check", new String[]{logFilepath}));
            this.log = null;
        }
    }

    public void writelnInLog(String inputMsg) {
        if (inputMsg != null) {
            this.empty = false;
            if (this.log == null) {
                this.log = new StringBuffer();
            }
            if (!this.elements.contains(inputMsg)) {
                this.elements.add(inputMsg);
                this.log.append(inputMsg).append(this.LINE_SEPARATOR);
                try {
                    if (!this.fileToSave.exists()) {
                        if (this.fileToSave.getParentFile() == null || !this.fileToSave.getParentFile().exists()) {
                            this.fileToSave.mkdirs();
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        this.fileToSave.createNewFile();
                    }
                    FileWriter f = new FileWriter(this.fileToSave, true);
                    BufferedWriter bf = new BufferedWriter(f);
                    bf.write("[" + this.dateFormat.format(Calendar.getInstance().getTime()) + "]: " + inputMsg);
                    bf.newLine();
                    bf.close();
                }
                catch (IOException e) {
                    LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
                }
            }
        }
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.elements = new ArrayList();
        this.logFile = logFile.substring(0, logFile.length() - 4);
        this.fileToSave = new File(String.valueOf(this.logFile) + ".log");
    }

    public List<String> elements() {
        return this.elements;
    }

    public boolean haveLog() {
        return this.log != null;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }
}

