/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.util.generators;

import com.modeliosoft.modelio.core.log.LOG;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class AttachInputPinToOwnerVisitorGen {
    private File file = null;
    private BufferedWriter buffer = null;
    private PrintWriter printer = null;
    private List<String> inputPinOwnerList = new ArrayList();

    public AttachInputPinToOwnerVisitorGen(String path) {
        this.file = this.createFile(path);
        this.buffer = this.createBuffer(this.file);
        this.printer = this.createPrinter(this.buffer);
        this.inputPinOwnerList.add("Action");
        this.inputPinOwnerList.add("AddStructuralFeatureValueAction");
        this.inputPinOwnerList.add("AddVariableValueAction");
        this.inputPinOwnerList.add("CallOperationAction");
        this.inputPinOwnerList.add("ClearAssociationAction");
        this.inputPinOwnerList.add("DestroyObjectAction");
        this.inputPinOwnerList.add("InvocationAction");
        this.inputPinOwnerList.add("LinkAction");
        this.inputPinOwnerList.add("LoopNode");
        this.inputPinOwnerList.add("OpaqueAction");
        this.inputPinOwnerList.add("RaiseExceptionAction");
        this.inputPinOwnerList.add("ReadIsClassifiedObjectAction");
        this.inputPinOwnerList.add("ReadLinkObjectEndAction");
        this.inputPinOwnerList.add("ReadLinkObjectEndQualifierAction");
        this.inputPinOwnerList.add("ReclassifyObjectAction");
        this.inputPinOwnerList.add("ReduceAction");
        this.inputPinOwnerList.add("RemoveStructuralFeatureValueAction");
        this.inputPinOwnerList.add("RemoveVariableValueAction");
        this.inputPinOwnerList.add("ReplyAction");
        this.inputPinOwnerList.add("SendObjectAction");
        this.inputPinOwnerList.add("SendSignalAction");
        this.inputPinOwnerList.add("StartClassifierBehaviorAction");
        this.inputPinOwnerList.add("StructuralFeatureAction");
        this.inputPinOwnerList.add("StructuredActivityNode");
        this.inputPinOwnerList.add("TestIdentityAction");
        this.inputPinOwnerList.add("UnmarshallAction");
        this.inputPinOwnerList.add("WriteStructuralFeatureAction");
        this.inputPinOwnerList.add("WriteVariableAction");
    }

    public void generate() {
        this.generateImports();
        this.generateClassCode();
        this.closeFile();
    }

    private File createFile(String path) {
        return new File(path);
    }

    private BufferedWriter createBuffer(File theFile) {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(theFile));
        }
        catch (IOException e) {
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
        }
        return bw;
    }

    private PrintWriter createPrinter(BufferedWriter theBuffer) {
        PrintWriter print = null;
        if (theBuffer != null) {
            print = new PrintWriter(theBuffer);
        }
        return print;
    }

    private void generateJavadoc(String docText) {
        this.printer.println(docText);
    }

    private void generateImports() {
        this.printer.println("package com.modeliosoft.modelio.xmi.util;\r\n");
        this.printer.println("import org.eclipse.uml2.uml.*;");
        this.printer.println("import org.eclipse.uml2.uml.util.UMLSwitch;");
        this.printer.println();
    }

    private void generateClassCode() {
        String docText = "/**\r\n* This class is used to attach an InputPin to its Owner. Call the \"attachInputPin()\" method to attach the InputPin to its owner.\r\n*/";
        this.generateJavadoc(docText);
        this.generateClassHeader();
        this.generateMemberAttributes();
        this.generateConstructor();
        this.generatePublicMethods();
        this.generateInnerClassCode();
        this.generateClassFooter();
    }

    private void generateClassHeader() {
        this.printer.println("public class AttachInputPinToOwnerVisitorGenerated");
        this.printer.println("{");
    }

    private void generateClassFooter() {
        this.printer.println("}");
    }

    private void generateMemberAttributes() {
        String docText = "/**\r\n* Visitor that will realize a switch on the owner of the InputPin to attach them.\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("private InputPinLinker linker;\r\n");
        docText = "/**\r\n* Stores the InputPin to attach to its parent.\r\n*/";
        this.printer.println("private InputPin inputPin;\r\n");
    }

    private void generateConstructor() {
        this.printer.println("public AttachInputPinToOwnerVisitorGenerated()");
        this.printer.println("{");
        this.printer.println("linker = new InputPinLinker();");
        this.printer.println("}");
        this.printer.println();
    }

    private void closeFile() {
        this.printer.flush();
        this.printer.close();
    }

    private void generatePublicMethods() {
        String docText = "/**\r\n* Attaches the given InputPin to its owner.\r\n@param inputPin The InputPin to attach.\r\n@param owner The owner of the InputPin to attach.\r\n\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("public void attachInputPin(");
        this.printer.println("InputPin inputPin, Element owner)");
        this.printer.println("{");
        this.printer.println("this.inputPin = inputPin;");
        this.printer.println("linker.accept(owner);");
        this.printer.println("}");
        this.printer.println();
    }

    private void generateInnerClassCode() {
        String docText = "/**\r\n* This class extends UMLSwitch and realizes a switch.\r\nThe class is inner and private, encapsulated to mask the \"visit\" methods to the user of the AttachInputPinToOwnerVisitor class.\r\nThe user will not see this class.\r\nSome visit methods return 42 to avoid calling the super (if return null => super).\r\n*/";
        this.generateJavadoc(docText);
        this.generateInnerClassHeader();
        this.generateInnerMemberAttributes();
        this.generateInnerConstructor();
        docText = "/**\r\n* Launches the switch.\r\n*/";
        this.generateJavadoc(docText);
        this.generateInnerPublicMethods();
        this.generateInnerRedefinedMethods();
        this.generateInnerClassFooter();
    }

    private void generateInnerClassHeader() {
        this.printer.println("private class InputPinLinker");
        this.printer.println("extends UMLSwitch");
        this.printer.println("{");
    }

    private void generateInnerClassFooter() {
        this.printer.println("}");
    }

    private void generateInnerMemberAttributes() {
    }

    private void generateInnerConstructor() {
    }

    private void generateInnerPublicMethods() {
        this.printer.println("public void accept(");
        this.printer.println("Element ecoreElt)");
        this.printer.println("{");
        this.printer.println("doSwitch(ecoreElt);");
        this.printer.println("}");
    }

    private void generateInnerRedefinedMethods() {
        int i = 0;
        for (String metaclassName : this.inputPinOwnerList) {
            LOG.info((String)"org.modelio.xmi.internal", (String)metaclassName);
            ++i;
            this.visitMetaclass(metaclassName);
        }
        LOG.info((String)"org.modelio.xmi.internal", (String)("" + i));
    }

    private void visitMetaclass(String metaclassName) {
        this.generateMethodHeader(metaclassName);
        this.generateMethodReturnValue();
        this.generateMethodFooter();
    }

    private void generateMethodHeader(String metaclassName) {
        String docText = "/**\r\n* Attach the InputPin to its owner \"" + metaclassName + "\" element." + "\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("@Override");
        this.printer.print("public Object case");
        this.printer.print(metaclassName);
        this.printer.println("(");
        this.printer.print(metaclassName);
        this.printer.println(" owner)");
        this.printer.println("{");
    }

    private void generateMethodFooter() {
        this.printer.println("}");
        this.printer.println();
    }

    private void generateMethodReturnValue() {
        this.printer.println("return 42;");
    }

    public static void main(String[] args) {
        LOG.info((String)"org.modelio.xmi.internal", (String)"BEGIN");
        AttachInputPinToOwnerVisitorGen generator = new AttachInputPinToOwnerVisitorGen("C:/eclipse new/workspace/XMI_prototype/src/com/softeam/Modelio/xmi/util/AttachInputPinToOwnerVisitorGenerated.java");
        generator.generate();
        LOG.info((String)"org.modelio.xmi.internal", (String)"END");
    }
}

