/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.util.generators;

import com.modeliosoft.modelio.core.log.LOG;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class AttachOutputPinToOwnerVisitorGen {
    private File file = null;
    private BufferedWriter buffer = null;
    private PrintWriter printer = null;
    private List<String> outputPinOwnerList = new ArrayList();

    public AttachOutputPinToOwnerVisitorGen(String path) {
        this.file = this.createFile(path);
        this.buffer = this.createBuffer(this.file);
        this.printer = this.createPrinter(this.buffer);
        this.outputPinOwnerList.add("AcceptCallAction");
        this.outputPinOwnerList.add("AcceptEventAction");
        this.outputPinOwnerList.add("Action");
        this.outputPinOwnerList.add("CallAction");
        this.outputPinOwnerList.add("ConditionalNode");
        this.outputPinOwnerList.add("CreateLinkObjectAction");
        this.outputPinOwnerList.add("CreateObjectAction");
        this.outputPinOwnerList.add("LoopNode");
        this.outputPinOwnerList.add("OpaqueAction");
        this.outputPinOwnerList.add("ReadExtentAction");
        this.outputPinOwnerList.add("ReadIsClassifiedObjectAction");
        this.outputPinOwnerList.add("ReadLinkAction");
        this.outputPinOwnerList.add("ReadLinkObjectEndAction");
        this.outputPinOwnerList.add("ReadLinkObjectEndQualifierAction");
        this.outputPinOwnerList.add("ReadSelfAction");
        this.outputPinOwnerList.add("ReadStructuralFeatureAction");
        this.outputPinOwnerList.add("ReadVariableAction");
        this.outputPinOwnerList.add("ReduceAction");
        this.outputPinOwnerList.add("StructuredActivityNode");
        this.outputPinOwnerList.add("TestIdentityAction");
        this.outputPinOwnerList.add("UnmarshallAction");
        this.outputPinOwnerList.add("ValueSpecificationAction");
    }

    public void generate() {
        this.generateImports();
        this.generateClassCode();
        this.closeFile();
    }

    private File createFile(String path) {
        return new File(path);
    }

    private BufferedWriter createBuffer(File theFile) {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(theFile));
        }
        catch (IOException e) {
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
        }
        return bw;
    }

    private PrintWriter createPrinter(BufferedWriter theBuffer) {
        PrintWriter print = null;
        if (theBuffer != null) {
            print = new PrintWriter(theBuffer);
        }
        return print;
    }

    private void generateJavadoc(String docText) {
        this.printer.println(docText);
    }

    private void generateImports() {
        this.printer.println("package com.modeliosoft.modelio.xmi.util;\r\n");
        this.printer.println("import org.eclipse.uml2.uml.*;");
        this.printer.println("import org.eclipse.uml2.uml.util.UMLSwitch;");
        this.printer.println();
    }

    private void generateClassCode() {
        String docText = "/**\r\n* This class is used to attach an OutputPin to its Owner. Call the \"attachOutputPin()\" method to attach the OutputPin to its owner.\r\n*/";
        this.generateJavadoc(docText);
        this.generateClassHeader();
        this.generateMemberAttributes();
        this.generateConstructor();
        this.generatePublicMethods();
        this.generateInnerClassCode();
        this.generateClassFooter();
    }

    private void generateClassHeader() {
        this.printer.println("public class AttachOutputPinToOwnerVisitorGenerated");
        this.printer.println("{");
    }

    private void generateClassFooter() {
        this.printer.println("}");
    }

    private void generateMemberAttributes() {
        String docText = "/**\r\n* Visitor that will realize a switch on the owner of the OutputPin to attach them.\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("private OutputPinLinker linker;\r\n");
        docText = "/**\r\n* Stores the OutputPin to attach to its parent.\r\n*/";
        this.printer.println("private OutputPin outputPin;\r\n");
    }

    private void generateConstructor() {
        this.printer.println("public AttachOutputPinToOwnerVisitorGenerated()");
        this.printer.println("{");
        this.printer.println("linker = new OutputPinLinker();");
        this.printer.println("}");
        this.printer.println();
    }

    private void closeFile() {
        this.printer.flush();
        this.printer.close();
    }

    private void generatePublicMethods() {
        String docText = "/**\r\n* Attaches the given OutputPin to its owner.\r\n@param outputPin The OutputPin to attach.\r\n@param owner The owner of the OutputPin to attach.\r\n\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("public void attachOutputPin(");
        this.printer.println("OutputPin outputPin, Element owner)");
        this.printer.println("{");
        this.printer.println("this.outputPin = outputPin;");
        this.printer.println("linker.accept(owner);");
        this.printer.println("}");
        this.printer.println();
    }

    private void generateInnerClassCode() {
        String docText = "/**\r\n* This class extends UMLSwitch and realizes a switch.\r\nThe class is inner and private, encapsulated to mask the \"visit\" methods to the user of the AttachOutputPinToOwnerVisitor class.\r\nThe user will not see this class.\r\nSome visit methods return 42 to avoid calling the super (if return null => super).\r\n*/";
        this.generateJavadoc(docText);
        this.generateInnerClassHeader();
        this.generateInnerMemberAttributes();
        this.generateInnerConstructor();
        docText = "/**\r\n* Launches the switch.\r\n*/";
        this.generateJavadoc(docText);
        this.generateInnerPublicMethods();
        this.generateInnerRedefinedMethods();
        this.generateInnerClassFooter();
    }

    private void generateInnerClassHeader() {
        this.printer.println("private class OutputPinLinker");
        this.printer.println("extends UMLSwitch");
        this.printer.println("{");
    }

    private void generateInnerClassFooter() {
        this.printer.println("}");
    }

    private void generateInnerMemberAttributes() {
    }

    private void generateInnerConstructor() {
    }

    private void generateInnerPublicMethods() {
        this.printer.println("public void accept(");
        this.printer.println("Element ecoreElt)");
        this.printer.println("{");
        this.printer.println("doSwitch(ecoreElt);");
        this.printer.println("}");
    }

    private void generateInnerRedefinedMethods() {
        int i = 0;
        for (String metaclassName : this.outputPinOwnerList) {
            LOG.info((String)"org.modelio.xmi.internal", (String)metaclassName);
            ++i;
            this.visitMetaclass(metaclassName);
        }
        LOG.info((String)"org.modelio.xmi.internal", (String)("" + i));
    }

    private void visitMetaclass(String metaclassName) {
        this.generateMethodHeader(metaclassName);
        this.generateMethodReturnValue();
        this.generateMethodFooter();
    }

    private void generateMethodHeader(String metaclassName) {
        String docText = "/**\r\n* Attach the OutputPin to its owner \"" + metaclassName + "\" element." + "\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("@Override");
        this.printer.print("public Object case");
        this.printer.print(metaclassName);
        this.printer.println("(");
        this.printer.print(metaclassName);
        this.printer.println(" owner)");
        this.printer.println("{");
    }

    private void generateMethodFooter() {
        this.printer.println("}");
        this.printer.println();
    }

    private void generateMethodReturnValue() {
        this.printer.println("return 42;");
    }

    public static void main(String[] args) {
        LOG.info((String)"org.modelio.xmi.internal", (String)"BEGIN");
        AttachOutputPinToOwnerVisitorGen generator = new AttachOutputPinToOwnerVisitorGen("C:/eclipse new/workspace/XMI_prototype/src/com/softeam/Modelio/xmi/util/AttachOutputPinToOwnerVisitorGenerated.java");
        generator.generate();
        LOG.info((String)"org.modelio.xmi.internal", (String)"END");
    }
}

