/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.util.generators;

import com.modeliosoft.modelio.api.model.uml.statik.IAssociationEnd;
import com.modeliosoft.modelio.api.model.uml.statik.IClass;
import com.modeliosoft.modelio.api.model.uml.statik.IComponent;
import com.modeliosoft.modelio.api.model.uml.statik.IModelTree;
import com.modeliosoft.modelio.api.model.uml.statik.IPackage;
import com.modeliosoft.modelio.api.model.uml.statik.ObAggregationKindEnum;
import com.modeliosoft.modelio.api.utils.IObListFilter;
import com.modeliosoft.modelio.api.utils.NameFilter;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.xmi.plugin.XMI;
import com.modeliosoft.modelio.xmi.util.ObjingModelNavigation;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

public class CompositionOwnerObjingVisitorGen {
    private File file = null;
    private BufferedWriter buffer = null;
    private PrintWriter printer = null;

    public CompositionOwnerObjingVisitorGen(String path) {
        this.file = this.createFile(path);
        this.buffer = this.createBuffer(this.file);
        this.printer = this.createPrinter(this.buffer);
    }

    public void generate() {
        this.generateImports();
        this.generateClassCode();
        this.closeFile();
    }

    private File createFile(String path) {
        return new File(path);
    }

    private BufferedWriter createBuffer(File theFile) {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(theFile));
        }
        catch (IOException e) {
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
        }
        return bw;
    }

    private PrintWriter createPrinter(BufferedWriter theBuffer) {
        PrintWriter print = null;
        if (theBuffer != null) {
            print = new PrintWriter(theBuffer);
        }
        return print;
    }

    private void generateJavadoc(String docText) {
        this.printer.println(docText);
    }

    private void generateImports() {
        this.printer.println("package com.modeliosoft.modelio.xmi.util;\r\n");
        this.printer.println("import java.util.HashMap;");
        this.printer.println("import com.softeam.modelio.joni.model.utils.DefaultMetamodelVisitor;");
        this.printer.println("import com.softeam.modelio.joni.model.*;");
    }

    private void generateClassCode() {
        String docText = "/**\r\n* This class is used to get the composition owner of a given model element.\r\nCall the \"getCompositionOwner()\" method to retrieve the Parent.\r\nAn element may have several different types of owners, defined by composition links at meta-level. These relations are exclusive: only one of them returns the owner element.\r\n*/";
        this.generateJavadoc(docText);
        this.generateClassHeader();
        this.generateMemberAttributes();
        this.generateConstructor();
        this.generatePublicMethods();
        this.generateInnerClassCode();
        this.generateClassClosure();
    }

    private void generateClassHeader() {
        this.printer.println("public class CompositionOwnerVisitorGenerated");
        this.printer.println("{");
    }

    private void generateClassClosure() {
        this.printer.println("}");
    }

    private void generateMemberAttributes() {
        String docText = "/**\r\n* Represents the composition owner that will be returned.\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("private IElement theParent;\r\n");
        docText = "/**\r\n* HashMap that relates an element (key) and its composition owner (value).\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("private HashMap<IElement, IElement> ownershipMap;\r\n");
        docText = "/**\r\n* Visitor that will navigate relations of composition to retrive the owner.\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("private CompositionOwnerSelector selector;\r\n");
        this.printer.println();
    }

    private void generateConstructor() {
        this.printer.println("public CompositionOwnerVisitorGenerated()");
        this.printer.println("{");
        this.printer.println("ownershipMap = new HashMap<IElement, IElement>();");
        this.printer.println("selector = new CompositionOwnerSelector();");
        this.printer.println("}");
        this.printer.println();
    }

    private void closeFile() {
        this.printer.flush();
        this.printer.close();
    }

    private void generatePublicMethods() {
        String docText = "/**\r\n* Returns the composition owner of the given element.\r\n@param theChild The element from which we will get the owner.\r\n@return the composition owner of the element given as parameter.\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("public IElement getCompositionOwner(");
        this.printer.println("IElement theChild)");
        this.printer.println("{");
        this.printer.println("theParent = ownershipMap.get(theChild);");
        this.printer.println("if (theParent == null) {");
        this.printer.println("selector.launchVisit(theChild);");
        this.printer.println("ownershipMap.put(theChild, theParent);");
        this.printer.println("}");
        this.printer.println("return theParent;");
        this.printer.println("}");
        this.printer.println();
    }

    private void generateInnerClassCode() {
        String docText = "/**\r\n* This class extends DefaultMetamodelVisitor and visits the composition links defined at meta-level.\r\nThe class is inner and private, encapsulated to mask the \"visit\" methods to the user of the CompositionOwnerVisitor class.\r\nThe user will not see this class.\r\n*/";
        this.generateJavadoc(docText);
        this.generateInnerClassHeader();
        this.generateInnerMemberAttributes();
        this.generateInnerConstructor();
        docText = "/**\r\n* Launches the visit of the composition relations.\r\n*/";
        this.generateJavadoc(docText);
        this.generateInnerPublicMethods();
        this.generateInnerRedefinedMethods();
        this.generateInnerClassClosure();
    }

    private void generateInnerClassHeader() {
        this.printer.println("private class CompositionOwnerSelector");
        this.printer.println("extends DefaultMetamodelVisitor");
        this.printer.println("{");
    }

    private void generateInnerClassClosure() {
        this.printer.println("}");
    }

    private void generateInnerMemberAttributes() {
    }

    private void generateInnerConstructor() {
    }

    private void generateInnerPublicMethods() {
        this.printer.println("public void launchVisit(");
        this.printer.println("IElement theChild)");
        this.printer.println("{");
        this.printer.println("theChild.accept(this);");
        this.printer.println("}");
    }

    private void generateInnerRedefinedMethods() {
        IPackage metamodelPkg = this.selectVisitEntryPoint();
        if (metamodelPkg != null) {
            for (IClass metaclass : metamodelPkg.getOwnedElement(IClass.class).select((IObListFilter)new /* Unavailable Anonymous Inner Class!! */)) {
                this.visitMetaclass(metaclass);
            }
        } else {
            LOG.info((String)"org.modelio.xmi.internal", (String)"Metamodel RAMC not found.");
        }
    }

    private IPackage selectVisitEntryPoint() {
        IPackage root = XMI.getInstance().getModelingSession().getModel().getProject().getModel();
        IPackage metamodelPackage = null;
        for (IModelTree ramc : root.getOwnedElement(IComponent.class).select((IObListFilter)new NameFilter("metamodel"))) {
            for (IModelTree refMdl : ramc.getOwnedElement(IPackage.class).select((IObListFilter)new NameFilter("Reference Metamodels"))) {
                for (IModelTree objingUML : refMdl.getOwnedElement(IPackage.class).select((IObListFilter)new NameFilter("Modelio UML"))) {
                    for (IModelTree metamodelPkg : objingUML.getOwnedElement(IPackage.class).select((IObListFilter)new NameFilter("Metamodel"))) {
                        metamodelPackage = (IPackage)metamodelPkg;
                    }
                }
            }
        }
        return metamodelPackage;
    }

    private void generateMethodHeader(String metaclassName) {
        String docText = "/**\r\n* Visits composition relations for \"" + metaclassName + "\" elements and its super classes." + "\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("@Override");
        this.printer.print("public Object visit");
        this.printer.print(metaclassName);
        this.printer.println("(");
        this.printer.print("I");
        this.printer.print(metaclassName);
        this.printer.println(" child)");
        this.printer.println("{");
    }

    private void generateMethodClosure() {
        this.printer.println("}");
        this.printer.println();
    }

    private void generateMethodTestResultIsNull() {
        this.printer.println("if (theParent == null)");
    }

    private void generateMethodSuperCall(String metaclassName) {
        this.generateMethodTestResultIsNull();
        this.printer.print("super.visit");
        this.printer.print(metaclassName);
        this.printer.println("(child);");
        this.printer.println();
    }

    private void generateMethodReturnValue() {
        this.printer.println("return null;");
    }

    public static void main(String[] args) {
        LOG.info((String)"org.modelio.xmi.internal", (String)"BEGIN");
        CompositionOwnerObjingVisitorGen generator = new CompositionOwnerObjingVisitorGen("C:/eclipse new/workspace/XMI_prototype/src/com/softeam/Modelio/xmi/util/CompositionOwnerVisitorGenerated.java");
        generator.generate();
        LOG.info((String)"org.modelio.xmi.internal", (String)"END");
    }

    private void visitMetaclass(IClass metaclass) {
        String metaclassName = this.getMetaclassName(metaclass);
        this.generateMethodHeader(metaclassName);
        this.generateMethodComposition(metaclass);
        this.generateMethodSuperCall(metaclassName);
        this.generateMethodReturnValue();
        this.generateMethodClosure();
    }

    private String getMetaclassName(IClass metaclass) {
        return metaclass.getName();
    }

    private void generateMethodComposition(IClass metaclass) {
        for (IAssociationEnd assocEnd : metaclass.getPart(IAssociationEnd.class)) {
            IAssociationEnd oppositeEnd;
            List oppositeEnds = ObjingModelNavigation.getOppositeAssociationEnds((IAssociationEnd)assocEnd);
            if (oppositeEnds.size() != 1 || (oppositeEnd = (IAssociationEnd)oppositeEnds.get(0)).getAggregation() != ObAggregationKindEnum.KIND_IS_COMPOSITION || "Project".equals(oppositeEnd.getOwner().getName())) continue;
            this.generateMethodTestResultIsNull();
            this.printer.print("theParent = child.get");
            this.printer.print(assocEnd.getName());
            this.printer.println("();");
            this.printer.println();
        }
    }
}

