/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.util.generators;

import com.modeliosoft.modelio.core.log.LOG;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralNull;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.internal.impl.ClassImpl;
import org.eclipse.uml2.uml.internal.impl.ModelImpl;
import org.eclipse.uml2.uml.internal.resource.UMLResourceFactoryImpl;
import org.eclipse.uml2.uml.resource.UMLResource;

public class OwnedAssociationUml2VisitorGen {
    private File visitorFile = null;
    private BufferedWriter visitorBuffer = null;
    private PrintWriter visitorPrinter = null;
    private File behaviorFile = null;
    private BufferedWriter behaviorBuffer = null;
    private PrintWriter behaviorPrinter = null;

    private void generateUml2Visitor() {
        Resource res = this.loadEcoreModel();
        if (res != null) {
            this.parseUml2Metamodel(res);
        }
    }

    private void compareTypes(String className, String resultVar, String tab) {
        this.visitorPrinter.println(String.valueOf(tab) + "// In particular case of this concrete element is inherited by another concrete element, it ");
        this.visitorPrinter.println(String.valueOf(tab) + "// shall be in the visitorMap. Also do call the treatment defined at the current super level:");
        this.visitorPrinter.println(String.valueOf(tab) + "if (" + resultVar + " == null || !(\"" + className + "Impl\".equals(" + resultVar + ".getClass().getSimpleName()))) {");
    }

    private void generateVisitorDefaultSwitch() {
        this.visitorPrinter.println("\t/**");
        this.visitorPrinter.println("\t * Calls caseXXX for each class of the model until one returns a non null result; it yields that result.");
        this.visitorPrinter.println("\t * ");
        this.visitorPrinter.println("\t * @param inputElement the target of the switch.");
        this.visitorPrinter.println("\t * @return the first non-null result returned by a caseXXX call.");
        this.visitorPrinter.println("\t */");
        this.visitorPrinter.println("\t@Override");
        this.visitorPrinter.println("\tpublic Object doSwitch(");
        this.visitorPrinter.println("\t\tEObject inputElement)");
        this.visitorPrinter.println("\t{");
        this.visitorPrinter.println("\t\tif (inputElement != null)");
        this.visitorPrinter.println("\t\t\treturn super.doSwitch(inputElement);");
        this.visitorPrinter.println("\t\telse");
        this.visitorPrinter.println("\t\t\treturn null;");
        this.visitorPrinter.println("\t}\r\n");
    }

    private void generateBehaviorDefaultSwitch() {
        this.behaviorPrinter.println("\tpublic void doSwitch(");
        this.behaviorPrinter.println("\t\tEObject inputElement)");
        this.behaviorPrinter.println("\t{");
        this.behaviorPrinter.println("\t}\r\n");
    }

    private Resource loadEcoreModel() {
        ResourceSetImpl resourceSet2 = new ResourceSetImpl();
        resourceSet2.getPackageRegistry().put((Object)"http://www.eclipse.org/uml2/3.0.0/UML", (Object)UMLPackage.eINSTANCE);
        resourceSet2.getResourceFactoryRegistry().getExtensionToFactoryMap().put("uml", UMLResource.Factory.INSTANCE);
        Map uriMap = resourceSet2.getURIConverter().getURIMap();
        String path = "C:/eclipse new/workspace/XMI_prototype/lib/org.eclipse.uml2.uml.resources_2.0.0.v200606221411.jar!/";
        URI uri = URI.createURI((String)("jar:file:/" + path));
        uriMap.put(URI.createURI((String)"pathmap://UML_LIBRARIES/"), uri.appendSegment("libraries").appendSegment(""));
        uriMap.put(URI.createURI((String)"pathmap://UML_METAMODELS/"), uri.appendSegment("metamodels").appendSegment(""));
        uriMap.put(URI.createURI((String)"pathmap://UML_PROFILES/"), uri.appendSegment("profiles").appendSegment(""));
        resourceSet2.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new UMLResourceFactoryImpl());
        File modelFile = new File("C:/eclipse new/workspace2/aaa/lib/uml2metamodel/metamodels/UML.metamodel.uml");
        URI fileURI2 = URI.createFileURI((String)modelFile.getAbsolutePath());
        try {
            return resourceSet2.getResource(fileURI2, true);
        }
        catch (Exception e) {
            LOG.error((String)"org.modelio.xmi.internal", (String)"invalidModel");
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
            return null;
        }
    }

    private void initVisitorFile() {
        this.visitorPrinter.println("public class Uml2MetamodelVisitor");
        this.visitorPrinter.println("\textends UMLSwitch");
        this.visitorPrinter.println("{");
        this.visitorPrinter.println("\tprivate XMIImportBehavior behavior;\r\n");
        this.visitorPrinter.println("\tprivate Map<Object, Object> visitorMap;\r\n");
    }

    private void initBehaviorFile() {
        this.behaviorPrinter.println("public class XMIImportBehavior");
        this.behaviorPrinter.println("{");
        this.behaviorPrinter.println("\tprivate ImportModel importModel;\r\n");
    }

    private void generateVisitorConstructor() {
        this.visitorPrinter.println("\tpublic Uml2MetamodelVisitor(");
        this.visitorPrinter.println("\t\tXMIImportBehavior behavior)");
        this.visitorPrinter.println("\t{");
        this.visitorPrinter.println("\t\tthis.behavior = behavior;");
        this.visitorPrinter.println("\t\tthis.visitorMap = new HashMap();\r\n");
        this.visitorPrinter.println("\t\tReverseProperties revProp = ReverseProperties.getInstance();");
        this.visitorPrinter.println("\t\tModelImpl ecoreRootModel = revProp.getEcoreModel();");
        this.visitorPrinter.println("\t\tthis.visitorMap.put(ecoreRootModel, ecoreRootModel);");
        this.visitorPrinter.println("\t}\r\n");
    }

    private void generateBehaviorConstructor() {
        this.behaviorPrinter.println("\tpublic XMIImportBehavior()");
        this.behaviorPrinter.println("\t{");
        this.behaviorPrinter.println("\t\timportModel = new ImportModel();");
        this.behaviorPrinter.println("\t}\r\n");
    }

    private void closeVisitorFile() {
        this.visitorPrinter.println("}");
        this.visitorPrinter.flush();
        this.visitorPrinter.close();
    }

    private void closeBehaviorFile() {
        this.behaviorPrinter.println("}");
        this.behaviorPrinter.flush();
        this.behaviorPrinter.close();
    }

    private BufferedWriter createBuffer(File file) {
        BufferedWriter buffer = null;
        try {
            buffer = new BufferedWriter(new FileWriter(file));
        }
        catch (IOException e) {
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
        }
        return buffer;
    }

    private PrintWriter createPrinter(BufferedWriter buffer) {
        PrintWriter print = null;
        if (buffer != null) {
            print = new PrintWriter(buffer);
        }
        return print;
    }

    private File createFile(String path) {
        return new File(path);
    }

    private void generateVisitorImports() {
        this.visitorPrinter.println("package com.modeliosoft.modelio.xmi.uml2visitorGen;\r\n");
        this.visitorPrinter.println("import java.util.HashMap;");
        this.visitorPrinter.println("import java.util.Map;\r\n");
        this.visitorPrinter.println("import org.eclipse.uml2.uml.util.UMLSwitch;");
        this.visitorPrinter.println("import java.lang.Object;");
        this.visitorPrinter.println("import org.eclipse.emf.ecore.EModelElement;");
        this.visitorPrinter.println("import org.eclipse.emf.ecore.EObject;");
        this.visitorPrinter.println("import org.eclipse.emf.ecore.EClass;");
        this.visitorPrinter.println("import org.eclipse.uml2.uml.Class;");
        this.visitorPrinter.println("import org.eclipse.uml2.uml.Package;");
        this.visitorPrinter.println("import org.eclipse.uml2.uml.*;\r\n");
    }

    private void generateBehaviorImports() {
        this.behaviorPrinter.println("package com.modeliosoft.modelio.xmi.uml2visitorGen;\r\n");
        this.visitorPrinter.println("import org.eclipse.uml2.uml.Class;");
        this.visitorPrinter.println("import org.eclipse.uml2.uml.Package;");
        this.behaviorPrinter.println("import org.eclipse.uml2.uml.*;\r\n");
    }

    public static void main(String[] args) {
        LOG.info((String)"org.modelio.xmi.internal", (String)"BEGIN");
        OwnedAssociationUml2VisitorGen gen = new OwnedAssociationUml2VisitorGen();
        gen.visitorFile = gen.createFile("C:/eclipse new/workspace2/Uml2MetamodelVisitor.java");
        gen.behaviorFile = gen.createFile("C:/eclipse new/workspace2/XMIImportBehavior.java");
        gen.visitorBuffer = gen.createBuffer(gen.visitorFile);
        gen.behaviorBuffer = gen.createBuffer(gen.behaviorFile);
        gen.visitorPrinter = gen.createPrinter(gen.visitorBuffer);
        gen.behaviorPrinter = gen.createPrinter(gen.behaviorBuffer);
        gen.generateVisitorImports();
        gen.generateBehaviorImports();
        gen.initVisitorFile();
        gen.initBehaviorFile();
        gen.generateVisitorConstructor();
        gen.generateBehaviorConstructor();
        gen.generateUml2Visitor();
        gen.generateVisitorDefaultSwitch();
        gen.generateBehaviorDefaultSwitch();
        gen.closeVisitorFile();
        gen.closeBehaviorFile();
        LOG.info((String)"org.modelio.xmi.internal", (String)"END");
    }

    private void parseUml2Metamodel(Resource res) {
        for (Object elem : res.getContents()) {
            if (!(elem instanceof ModelImpl)) continue;
            LOG.info((String)"org.modelio.xmi.internal", (String)elem.getClass().getSimpleName());
            ModelImpl mdl = (ModelImpl)elem;
            LOG.info((String)"org.modelio.xmi.internal", (String)mdl.getName());
            int i = 0;
            for (Object umlElt : mdl.getPackagedElements()) {
                String umlTypeName = umlElt.getClass().getSimpleName();
                if (!umlTypeName.equals("ClassImpl")) continue;
                this.computeElement((NamedElement)umlElt);
                ++i;
            }
            LOG.info((String)"org.modelio.xmi.internal", (String)("nb elts : " + i));
        }
    }

    private void computeElement(NamedElement umlElt) {
        if (umlElt instanceof ClassImpl) {
            this.visitorPrinter.flush();
            this.behaviorPrinter.flush();
            this.computeClass((ClassImpl)umlElt);
        }
    }

    private void computeClass(ClassImpl class_) {
        boolean isAbstract = class_.isAbstract();
        String className = class_.getName();
        if ("Class".equals(className)) {
            LOG.info((String)"org.modelio.xmi.internal", (String)"Class");
        }
        String inArgName = "input" + className;
        String tab = "\t";
        String abstractOrConcreteStr = isAbstract ? "abstract" : "concrete";
        this.visitorPrinter.println(String.valueOf(tab) + "/**");
        this.visitorPrinter.print(String.valueOf(tab) + " * Returns the result of interpreting the ");
        this.visitorPrinter.print(abstractOrConcreteStr);
        this.visitorPrinter.println(" object as an instance of '" + className + "'.<BR>");
        this.visitorPrinter.println(String.valueOf(tab) + " * This implementation returns null; returning a " + "non-null result will terminate the switch.");
        this.visitorPrinter.println(String.valueOf(tab) + " * ");
        this.visitorPrinter.println(String.valueOf(tab) + " * @param " + inArgName + " the " + className + " to visit");
        this.visitorPrinter.println(String.valueOf(tab) + " * @return the result of interpreting the object " + "as an instance of '" + className + "'.");
        this.visitorPrinter.println(String.valueOf(tab) + " */");
        this.visitorPrinter.println(String.valueOf(tab) + "@Override");
        this.visitorPrinter.println(String.valueOf(tab) + "public Object case" + className + "(");
        this.behaviorPrinter.println(String.valueOf(tab) + "public void visit" + className + "(");
        tab = "\t\t";
        this.visitorPrinter.println(String.valueOf(tab) + className + " " + inArgName + ")");
        this.behaviorPrinter.println(String.valueOf(tab) + className + " " + inArgName + ")");
        tab = "\t";
        this.visitorPrinter.println(String.valueOf(tab) + "{");
        this.behaviorPrinter.println(String.valueOf(tab) + "{");
        tab = "\t\t";
        if (!isAbstract) {
            this.visitorPrinter.println(String.valueOf(tab) + "Object theResult = visitorMap.get(" + inArgName + ");");
            this.behaviorPrinter.println(String.valueOf(tab) + "E" + className + " element = new E" + className + "(" + inArgName + ");");
            this.behaviorPrinter.println(String.valueOf(tab) + "importModel.importXMI(element);");
            this.visitorPrinter.println(String.valueOf(tab) + "if (theResult == null) {");
            tab = "\t\t\t";
            this.visitorPrinter.println(String.valueOf(tab) + "visitorMap.put(" + inArgName + ", " + inArgName + ");");
            tab = "\t\t";
            this.visitorPrinter.println(String.valueOf(tab) + "}\r\n");
            this.compareTypes(className, "theResult", tab);
            tab = "\t\t\t";
            this.visitorPrinter.println(String.valueOf(tab) + "behavior.visit" + className + "(" + inArgName + ");");
            this.visitorPrinter.println(String.valueOf(tab) + "theResult = super.case" + className + "(" + inArgName + ");");
            this.visitLinks(class_, inArgName, tab);
            tab = "\t\t";
            this.visitorPrinter.println(String.valueOf(tab) + "}");
        } else {
            this.visitorPrinter.println(String.valueOf(tab) + "Object theResult = super.case" + className + "(" + inArgName + ");");
            this.visitLinks(class_, inArgName, tab);
        }
        this.visitorPrinter.println("\t\treturn theResult;");
        this.visitorPrinter.println("\t}\r\n");
        this.behaviorPrinter.println("\t}\r\n");
    }

    private void visitLinks(ClassImpl class_, String inArgName, String tab) {
        for (Object feature : class_.getFeatures()) {
            String prefix;
            String methodName;
            String propName;
            Property prop;
            Association assoc;
            if (!(feature instanceof Property) || (assoc = (prop = (Property)feature).getAssociation()) == null) continue;
            if (!this.isUnlimitedMultiplicity(prop)) {
                propName = prop.getName();
                if ("".equals(propName)) {
                    LOG.warning((String)"org.modelio.xmi.internal", (String)"The name of the Association end is \"\".");
                    propName = "ownedElement";
                } else if ("class".equals(propName)) {
                    propName = "class_";
                }
                methodName = propName.substring(1);
                prefix = String.valueOf(propName.charAt(0)).toUpperCase();
                prefix = "get" + prefix;
                methodName = String.valueOf(prefix) + methodName;
                this.visitorPrinter.println(String.valueOf(tab) + "this.doSwitch((EObject)" + inArgName + "." + methodName + "());");
                continue;
            }
            propName = prop.getName();
            if ("".equals(propName)) {
                LOG.warning((String)"org.modelio.xmi.internal", (String)"The name of the Association end is \"\".");
                propName = "ownedElement";
            }
            methodName = propName.substring(1);
            prefix = String.valueOf(propName.charAt(0)).toUpperCase();
            prefix = "get" + prefix;
            methodName = String.valueOf(prefix) + methodName;
            String plural = "";
            if ("endData".equals(propName)) {
                plural = "";
            } else if (propName.charAt(propName.length() - 1) == 'y') {
                methodName = methodName.substring(0, methodName.length() - 1);
                plural = propName.contains("pendency") || propName.contains("try") || propName.contains("ody") || propName.contains("roperty") ? "ies" : (propName.contains("overedBy") ? "ys" : "y");
            } else if (propName.charAt(propName.length() - 1) == 'x' && propName.contains("subvertex")) {
                methodName = methodName.substring(0, methodName.length() - 2);
                plural = "ices";
            } else {
                plural = propName.charAt(propName.length() - 1) == 's' ? "es" : "s";
            }
            methodName = String.valueOf(methodName) + plural;
            this.visitorPrinter.println(String.valueOf(tab) + "for (Object " + propName + " : " + inArgName + "." + methodName + "()) {");
            this.visitorPrinter.println(String.valueOf(tab) + "\tthis.doSwitch((EObject)" + propName + ");");
            this.visitorPrinter.println(String.valueOf(tab) + "}");
        }
    }

    private boolean isUnlimitedMultiplicity(Property prop) {
        ValueSpecification upperValue = prop.getUpperValue();
        if (upperValue != null && upperValue.isComputable()) {
            if (upperValue instanceof LiteralUnlimitedNatural) {
                LiteralUnlimitedNatural naturalIntValue = (LiteralUnlimitedNatural)upperValue;
                return naturalIntValue.getValue() != 1;
            }
            if (upperValue instanceof LiteralInteger) {
                if (upperValue.integerValue() > 1) {
                    return true;
                }
            } else {
                if (upperValue instanceof LiteralBoolean) {
                    return false;
                }
                if (upperValue instanceof LiteralString) {
                    String upperValueStr = upperValue.stringValue();
                    if ("*".equals(upperValueStr)) {
                        return true;
                    }
                    return Integer.valueOf(upperValueStr) > 1;
                }
                if (upperValue instanceof LiteralNull) {
                    return false;
                }
            }
        }
        return false;
    }
}

