/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.util.generators;

import com.modeliosoft.modelio.core.log.LOG;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralNull;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.internal.impl.ModelImpl;
import org.eclipse.uml2.uml.internal.resource.UMLResourceFactoryImpl;
import org.eclipse.uml2.uml.resource.UMLResource;

public class OwnedCompositionUml2VisitorGen {
    private boolean isCurrentClassAbstract;
    private String metaclassName;
    private String inArgName;
    private File file = null;
    private BufferedWriter buffer = null;
    private PrintWriter printer = null;

    public OwnedCompositionUml2VisitorGen(String path) {
        this.file = this.createFile(path);
        this.buffer = this.createBuffer(this.file);
        this.printer = this.createPrinter(this.buffer);
        this.isCurrentClassAbstract = false;
    }

    public void generate() {
        this.generateImports();
        this.generateClassCode();
        this.closeFile();
    }

    private File createFile(String path) {
        return new File(path);
    }

    private BufferedWriter createBuffer(File theFile) {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(theFile));
        }
        catch (IOException e) {
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
        }
        return bw;
    }

    private PrintWriter createPrinter(BufferedWriter theBuffer) {
        PrintWriter print = null;
        if (theBuffer != null) {
            print = new PrintWriter(theBuffer);
        }
        return print;
    }

    private void generateJavadoc(String docText) {
        this.printer.println(docText);
    }

    private void generateImports() {
        this.printer.println("package com.modeliosoft.modelio.xmi.reverse;\r\n");
        this.printer.println("import java.util.HashMap;");
        this.printer.println("import java.util.Map;\r\n");
        this.printer.println("import org.eclipse.emf.ecore.EObject;");
        this.printer.println("import org.eclipse.uml2.uml.*;\r\n");
        this.printer.println("import org.eclipse.uml2.uml.Class;");
        this.printer.println("import org.eclipse.uml2.uml.Package;");
        this.printer.println("import org.eclipse.uml2.uml.internal.impl.ModelImpl;");
        this.printer.println("import org.eclipse.uml2.uml.util.UMLSwitch;");
        this.printer.println("import com.modeliosoft.modelio.xmi.util.ReverseProperties;\r\n");
    }

    private void generateClassCode() {
        String docText = "/**\r\n* This class is used to visit the EMF-UML2 metamodel along composition relations.\r\n*/";
        this.generateJavadoc(docText);
        this.generateClassHeader();
        this.generateMemberAttributes();
        this.generateConstructor();
        this.generateUml2VisitMethods();
        this.generateClassClosure();
    }

    private void generateClassHeader() {
        this.printer.println("public class OwnedCompositionUml2VisitorGenerated");
        this.printer.println("extends UMLSwitch");
        this.printer.println("{");
    }

    private void generateClassClosure() {
        this.printer.println("}");
    }

    private void generateMemberAttributes() {
        this.printer.println("private XMIImportBehavior behavior;\r\n");
        this.printer.println("private Map<Object, Object> visitorMap;\r\n");
    }

    private void generateConstructor() {
        this.printer.println("public OwnedCompositionUml2VisitorGenerated(");
        this.printer.println("XMIImportBehavior behavior)");
        this.printer.println("{");
        this.printer.println("this.behavior = behavior;");
        this.printer.println("this.visitorMap = new HashMap<Object, Object>();\r\n");
        this.printer.println("ReverseProperties revProp = ReverseProperties.getInstance();");
        this.printer.println("ModelImpl ecoreRootModel = revProp.getEcoreModel();");
        this.printer.println("this.visitorMap.put(ecoreRootModel, ecoreRootModel);");
        this.printer.println("}\r\n");
    }

    private void generateUml2VisitMethods() {
        this.generateDefaultSwitch();
        Resource res = this.loadEcoreModel();
        if (res != null) {
            for (Class uml2Class : this.getUml2Metaclasses(res)) {
                LOG.info((String)"org.modelio.xmi.internal", (String)("metaclass = " + uml2Class.getName()));
                this.visitMetaclass(uml2Class);
            }
        }
    }

    private void generateDefaultSwitch() {
        String docText = "/**\r\nCalls caseXXX for each class of the model until one returns a non null result; it yields that result.\r\n@param inputElement the target of the switch.\r\n@return the first non-null result returned by a caseXXX call.\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("@Override");
        this.printer.println("public Object doSwitch(");
        this.printer.println("EObject inputElement)");
        this.printer.println("{");
        this.printer.println("if (inputElement != null)");
        this.printer.println("return super.doSwitch(inputElement);");
        this.printer.println("else");
        this.printer.println("return null;");
        this.printer.println("}\r\n");
    }

    private Resource loadEcoreModel() {
        ResourceSetImpl resourceSet2 = new ResourceSetImpl();
        resourceSet2.getPackageRegistry().put((Object)"http://www.eclipse.org/uml2/3.0.0/UML", (Object)UMLPackage.eINSTANCE);
        resourceSet2.getResourceFactoryRegistry().getExtensionToFactoryMap().put("uml", UMLResource.Factory.INSTANCE);
        Map uriMap = resourceSet2.getURIConverter().getURIMap();
        String path = "C:/eclipse new/workspace/XMI_prototype/lib/org.eclipse.uml2.uml.resources_2.0.0.v200606221411.jar!/";
        URI uri = URI.createURI((String)("jar:file:/" + path));
        uriMap.put(URI.createURI((String)"pathmap://UML_LIBRARIES/"), uri.appendSegment("libraries").appendSegment(""));
        uriMap.put(URI.createURI((String)"pathmap://UML_METAMODELS/"), uri.appendSegment("metamodels").appendSegment(""));
        uriMap.put(URI.createURI((String)"pathmap://UML_PROFILES/"), uri.appendSegment("profiles").appendSegment(""));
        resourceSet2.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new UMLResourceFactoryImpl());
        File modelFile = new File("C:/UML.metamodel.uml");
        URI fileURI2 = URI.createFileURI((String)modelFile.getAbsolutePath());
        try {
            return resourceSet2.getResource(fileURI2, true);
        }
        catch (Exception e) {
            LOG.error((String)"org.modelio.xmi.internal", (String)"invalidModel");
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
            return null;
        }
    }

    private void generateMethodHeader() {
        String abstractOrConcreteStr = this.isCurrentClassAbstract ? "abstract" : "concrete";
        this.inArgName = "input" + this.metaclassName;
        String docText = "/**\r\n*  Returns the result of interpreting the " + abstractOrConcreteStr + " object as an instance of '" + this.metaclassName + "'.<BR>\r\n" + " * This implementation returns null; returning a " + "non-null result will terminate the switch.\r\n" + " *\r\n" + " * @param " + this.inArgName + " the " + this.metaclassName + " to visit\r\n" + " * @return the result of interpreting the object " + "as an instance of '" + this.metaclassName + "'." + "\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("@Override");
        this.printer.print("public Object case");
        this.printer.print(this.metaclassName);
        this.printer.println("(");
        this.printer.print(this.metaclassName);
        this.printer.println(" " + this.inArgName + ")");
        this.printer.println("{");
    }

    private void compareTypes(String className, String resultVar) {
        this.printer.print("// If this concrete element is inherited by another concrete element, it");
        this.printer.print(" shall be in the visitorMap. Also do call the treatment defined at the");
        this.printer.println(" current super level:");
        this.printer.println("if (" + resultVar + " == null || !(\"" + className + "Impl\".equals(" + resultVar + ".getClass().getSimpleName()))) {");
    }

    private void generateMethodReturnValue() {
        if ("PrimitiveType".equals(this.metaclassName)) {
            this.printer.println("// [CVI]: case of a primitive type: read only in Ijing => do not call super classes");
            this.printer.println("return 42;");
        } else {
            this.printer.println("return null;");
        }
    }

    private void generateMethodFooter() {
        this.printer.println("}");
        this.printer.println();
    }

    private void closeFile() {
        this.printer.flush();
        this.printer.close();
    }

    public static void main(String[] args) {
        LOG.info((String)"org.modelio.xmi.internal", (String)"BEGIN");
        OwnedCompositionUml2VisitorGen gen = new OwnedCompositionUml2VisitorGen("C:/eclipse new/workspace/XMI_prototype/src/com/softeam/Modelio/xmi/reverse/OwnedCompositionUml2VisitorGenerated.java");
        gen.generate();
        LOG.info((String)"org.modelio.xmi.internal", (String)"END");
    }

    private List<Class> getUml2Metaclasses(Resource res) {
        ArrayList<Class> uml2Classes = new ArrayList();
        for (Object elem : res.getContents()) {
            if (!(elem instanceof ModelImpl)) continue;
            ModelImpl mdl = (ModelImpl)elem;
            for (Object umlElt : mdl.getPackagedElements()) {
                if (!(umlElt instanceof Class)) continue;
                uml2Classes.add((Class)umlElt);
            }
        }
        uml2Classes = this.sortByName(uml2Classes);
        return uml2Classes;
    }

    private List<Class> sortByName(List<Class> uml2Classes) {
        int listSize = uml2Classes.size();
        boolean isDisordered = true;
        int i = 0;
        while (i < listSize && isDisordered) {
            isDisordered = false;
            int j = 1;
            while (j < listSize - i) {
                if (this.compareTo(uml2Classes.get(j), uml2Classes.get(j - 1)) < 0) {
                    Class tmpClass = uml2Classes.get(j - 1);
                    uml2Classes.set(j - 1, uml2Classes.get(j));
                    uml2Classes.set(j, tmpClass);
                    isDisordered = true;
                }
                ++j;
            }
            ++i;
        }
        return uml2Classes;
    }

    private int compareTo(Class class1, Class class2) {
        if (class1 != null && class2 != null) {
            return class1.getName().toUpperCase().compareTo(class2.getName().toUpperCase());
        }
        return -1;
    }

    private void visitMetaclass(Class metaclass) {
        this.metaclassName = metaclass.getName();
        this.isCurrentClassAbstract = metaclass.isAbstract();
        this.generateMethodHeader();
        this.generateMethodBody(metaclass);
        this.generateMethodReturnValue();
        this.generateMethodFooter();
    }

    private void generateMethodBody(Class metaclass) {
        if (this.isCurrentClassAbstract) {
            this.generateBodyForAbstractClass(metaclass);
        } else {
            this.generateBodyForConcreteClass(metaclass);
        }
    }

    private void generateBodyForAbstractClass(Class metaclass) {
        this.visitCompositionLinks(metaclass);
    }

    private void generateBodyForConcreteClass(Class metaclass) {
        this.printer.println("Object theResult = visitorMap.get(" + this.inArgName + ");");
        this.compareTypes(this.metaclassName, "theResult");
        this.printer.println("visitorMap.put(" + this.inArgName + ", " + this.inArgName + ");");
        this.ignoreModelVisit();
        this.printer.println("behavior.visit" + this.metaclassName + "(" + this.inArgName + ");");
        this.visitCompositionLinks(metaclass);
        this.printer.println("}");
    }

    private void ignoreModelVisit() {
        if ("Package".equals(this.metaclassName)) {
            this.printer.println("// [CVI]: ignore visit of relations defined at \"Package\" level for an element of type \"Model\"");
            this.printer.println("if (inputPackage instanceof Model)");
            this.printer.println("return null;\r\n");
        }
    }

    private void visitCompositionLinks(Class metaclass) {
        for (Object feature : metaclass.getFeatures()) {
            Property prop;
            if (!(feature instanceof Property) || (prop = (Property)feature).getAssociation() == null || prop.getAggregation() != AggregationKind.COMPOSITE_LITERAL) continue;
            this.visitCompositionLink(prop);
        }
    }

    private void visitCompositionLink(Property prop) {
        if (!this.isUnlimitedMultiplicity(prop) && !this.isUnlimitedFilter(prop)) {
            this.generateGetter(prop);
        } else {
            this.generateForEach(prop);
        }
    }

    private boolean isUnlimitedFilter(Property prop) {
        return "Extension".equals(this.metaclassName) && "ownedEnd".equals(prop.getName());
    }

    private void generateGetter(Property prop) {
        String propName = prop.getName();
        if ("".equals(propName)) {
            LOG.error((String)"org.modelio.xmi.internal", (String)"The name of the Association end is \"\".");
            propName = "ownedElement";
        } else if ("class".equals(propName)) {
            propName = "class_";
        }
        String methodName = propName.substring(1);
        String prefix = String.valueOf(propName.charAt(0)).toUpperCase();
        prefix = "get" + prefix;
        methodName = String.valueOf(prefix) + methodName;
        this.printer.println("this.doSwitch((EObject)" + this.inArgName + "." + methodName + "());");
    }

    private void generateForEach(Property prop) {
        String propName = prop.getName();
        if ("".equals(propName)) {
            LOG.error((String)"org.modelio.xmi.internal", (String)"The name of the Association end is \"\".");
            propName = "ownedElement";
        }
        String methodName = propName.substring(1);
        String prefix = String.valueOf(propName.charAt(0)).toUpperCase();
        prefix = "get" + prefix;
        methodName = String.valueOf(prefix) + methodName;
        String plural = "";
        if ("endData".equals(propName)) {
            plural = "";
        } else if (propName.charAt(propName.length() - 1) == 'y') {
            methodName = methodName.substring(0, methodName.length() - 1);
            plural = propName.contains("pendency") || propName.contains("try") || propName.contains("ody") || propName.contains("roperty") ? "ies" : (propName.contains("overedBy") ? "ys" : "y");
        } else if (propName.charAt(propName.length() - 1) == 'x' && propName.contains("subvertex")) {
            methodName = methodName.substring(0, methodName.length() - 2);
            plural = "ices";
        } else {
            plural = propName.charAt(propName.length() - 1) == 's' ? "es" : "s";
        }
        methodName = String.valueOf(methodName) + plural;
        this.printer.println("for (Object " + propName + " : " + this.inArgName + "." + methodName + "()) {");
        this.printer.println("this.doSwitch((EObject)" + propName + ");");
        this.printer.println("}");
    }

    private boolean isUnlimitedMultiplicity(Property prop) {
        ValueSpecification upperValue = prop.getUpperValue();
        if (upperValue != null && upperValue.isComputable()) {
            if (upperValue instanceof LiteralUnlimitedNatural) {
                LiteralUnlimitedNatural naturalIntValue = (LiteralUnlimitedNatural)upperValue;
                return naturalIntValue.getValue() != 1;
            }
            if (upperValue instanceof LiteralInteger) {
                if (upperValue.integerValue() > 1) {
                    return true;
                }
            } else {
                if (upperValue instanceof LiteralBoolean) {
                    return false;
                }
                if (upperValue instanceof LiteralString) {
                    String upperValueStr = upperValue.stringValue();
                    if ("*".equals(upperValueStr)) {
                        return true;
                    }
                    return Integer.valueOf(upperValueStr) > 1;
                }
                if (upperValue instanceof LiteralNull) {
                    return false;
                }
            }
        }
        return false;
    }
}

