/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.util.generators;

import com.modeliosoft.modelio.api.model.uml.statik.IClass;
import com.modeliosoft.modelio.api.model.uml.statik.IComponent;
import com.modeliosoft.modelio.api.model.uml.statik.IModelTree;
import com.modeliosoft.modelio.api.model.uml.statik.IPackage;
import com.modeliosoft.modelio.api.utils.IObListFilter;
import com.modeliosoft.modelio.api.utils.NameFilter;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.xmi.plugin.XMI;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;

public class PartialCreationExportVisitorGen {
    private File file = null;
    private BufferedWriter buffer = null;
    private PrintWriter printer = null;
    private Class<?> ecoreFactory = null;

    public PartialCreationExportVisitorGen(String path) {
        this.file = this.createFile(path);
        this.buffer = this.createBuffer(this.file);
        this.printer = this.createPrinter(this.buffer);
        try {
            this.ecoreFactory = Class.forName("org.eclipse.uml2.uml.UMLFactory");
        }
        catch (ClassNotFoundException e) {
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
        }
    }

    public void generate() {
        this.generateImports();
        this.generateClassCode();
        this.closeFile();
    }

    private File createFile(String path) {
        return new File(path);
    }

    private BufferedWriter createBuffer(File theFile) {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(theFile));
        }
        catch (IOException e) {
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
        }
        return bw;
    }

    private PrintWriter createPrinter(BufferedWriter theBuffer) {
        PrintWriter print = null;
        if (theBuffer != null) {
            print = new PrintWriter(theBuffer);
        }
        return print;
    }

    private void generateJavadoc(String docText) {
        this.printer.println(docText);
    }

    private void generateImports() {
        this.printer.println("package com.modeliosoft.modelio.xmi.generation;\r\n");
        this.printer.println("import org.eclipse.uml2.uml.Element;");
        this.printer.println("import org.eclipse.uml2.uml.UMLFactory;");
        this.printer.println("import com.softeam.modelio.joni.model.utils.DefaultMetamodelVisitor;");
        this.printer.println("import com.softeam.modelio.joni.model.*;");
        this.printer.println();
    }

    private void generateClassCode() {
        String docText = "/**\r\n* This class is used to get an Ecore element mapped from the given Modelio element.Call the \"createPartialEcoreElt()\" method to get the corresponding Ecore element.\r\n*/";
        this.generateJavadoc(docText);
        this.generateClassHeader();
        this.generateMemberAttributes();
        this.generateConstructor();
        this.generatePublicMethods();
        this.generateInnerClassCode();
        this.generateClassFooter();
    }

    private void generateClassHeader() {
        this.printer.println("public class PartialCreationExportVisitorGenerated");
        this.printer.println("{");
    }

    private void generateClassFooter() {
        this.printer.println("}");
    }

    private void generateMemberAttributes() {
        String docText = "/**\r\n* Represents the Ecore element that will be returned.\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("private Element ecoreElt;\r\n");
        docText = "/**\r\n* Visitor that will realize a switch to call the appropriate \"creation\" methods.\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("private CreationExportMapper mapper;\r\n");
        this.printer.println();
        docText = "/**\r\n* HashMap containing as key an Modelio element, and, as value, the corresponding Ecore element partially created.\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("private PartialExportMap partialMap;\r\n");
    }

    private void generateConstructor() {
        this.printer.println("public PartialCreationExportVisitorGenerated()");
        this.printer.println("{");
        this.printer.println("ecoreElt = null;");
        this.printer.println("mapper = new CreationExportMapper();");
        this.printer.println("partialMap = PartialExportMap.getInstance();");
        this.printer.println("}");
        this.printer.println();
    }

    private void closeFile() {
        this.printer.flush();
        this.printer.close();
    }

    private void generatePublicMethods() {
        String docText = "/**\r\n* Returns the Ecore element mapped from the given element.\r\n@param objingElt The element from which we will do the mapping.\r\n@return the Ecore element mapped from the element given as parameter.\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("public Element createPartialEcoreElt(");
        this.printer.println("IElement objingElt)");
        this.printer.println("{");
        this.printer.println("Element ecoreEltFromMap = partialMap.get(objingElt.getId());");
        this.printer.println("if (ecoreEltFromMap == null) {");
        this.printer.println("mapper.accept(objingElt);");
        this.printer.println("partialMap.put(objingElt.getId(), ecoreElt);");
        this.printer.println("}");
        this.printer.println("return ecoreElt;");
        this.printer.println("}");
        this.printer.println();
    }

    private void generateInnerClassCode() {
        String docText = "/**\r\n* This class extends DefaultMetamodelVisitor and realizes a switch.\r\nThe class is inner and private, encapsulated to mask the \"visit\" methods to the user of the PartialCreationExportVisitor class.\r\nThe user will not see this class.\r\n*/";
        this.generateJavadoc(docText);
        this.generateInnerClassHeader();
        this.generateInnerMemberAttributes();
        this.generateInnerConstructor();
        docText = "/**\r\n* Launches the switch.\r\n*/";
        this.generateJavadoc(docText);
        this.generateInnerPublicMethods();
        this.generateInnerRedefinedMethods();
        this.generateInnerClassFooter();
    }

    private void generateInnerClassHeader() {
        this.printer.println("private class CreationExportMapper");
        this.printer.println("extends DefaultMetamodelVisitor");
        this.printer.println("{");
    }

    private void generateInnerClassFooter() {
        this.printer.println("}");
    }

    private void generateInnerMemberAttributes() {
    }

    private void generateInnerConstructor() {
    }

    private void generateInnerPublicMethods() {
        this.printer.println("public void accept(");
        this.printer.println("IElement objingElt)");
        this.printer.println("{");
        this.printer.println("objingElt.accept(this);");
        this.printer.println("}");
    }

    private void generateInnerRedefinedMethods() {
        IPackage metamodelPkg = this.selectVisitEntryPoint();
        if (metamodelPkg != null) {
            for (IModelTree metaclass : metamodelPkg.getOwnedElement(IClass.class).select((IObListFilter)new /* Unavailable Anonymous Inner Class!! */)) {
                this.visitMetaclass((IClass)metaclass);
            }
        } else {
            LOG.info((String)"org.modelio.xmi.internal", (String)"Metamodel RAMC not found.");
        }
    }

    private IPackage selectVisitEntryPoint() {
        IPackage root = XMI.getInstance().getModelingSession().getModel().getProject().getModel();
        IPackage metamodelPackage = null;
        for (IModelTree ramc : root.getOwnedElement(IComponent.class).select((IObListFilter)new NameFilter("metamodel"))) {
            for (IModelTree refMdl : ramc.getOwnedElement(IPackage.class).select((IObListFilter)new NameFilter("Reference Metamodels"))) {
                for (IModelTree objingUML : refMdl.getOwnedElement(IPackage.class).select((IObListFilter)new NameFilter("Modelio UML"))) {
                    for (IModelTree metamodelPkg : objingUML.getOwnedElement(IPackage.class).select((IObListFilter)new NameFilter("Metamodel"))) {
                        metamodelPackage = (IPackage)metamodelPkg;
                    }
                }
            }
        }
        return metamodelPackage;
    }

    private void generateMethodHeader(String metaclassName) {
        String docText = "/**\r\n* Create the Ecore element from the given \"" + metaclassName + "\" Modelio element." + "\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("@Override");
        this.printer.print("public Object visit");
        this.printer.print(metaclassName);
        this.printer.println("(");
        this.printer.print("I");
        this.printer.print(metaclassName);
        this.printer.println(" objingElt)");
        this.printer.println("{");
    }

    private void generateMethodFooter() {
        this.printer.println("}");
        this.printer.println();
    }

    private void generateEcoreEltCreation(String metaclassName) {
        if (this.ecoreFactory != null) {
            try {
                Method method = this.ecoreFactory.getMethod("create" + metaclassName, null);
                if (method != null) {
                    this.printer.println("ecoreElt = UMLFactory.eINSTANCE.create" + metaclassName + "();");
                }
            }
            catch (SecurityException e) {
                LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                this.printer.println("// TODO map objing to ecore");
                LOG.error((String)"org.modelio.xmi.internal", (String)("? create" + metaclassName + "() doesn't exist."));
            }
        }
    }

    private void generateMethodReturnValue() {
        this.printer.println("return null;");
    }

    public static void main(String[] args) {
        LOG.info((String)"org.modelio.xmi.internal", (String)"BEGIN");
        PartialCreationExportVisitorGen generator = new PartialCreationExportVisitorGen("C:/eclipse new/workspace/XMI_prototype/src/com/softeam/Modelio/xmi/generation/PartialCreationExportVisitorGenerated.java");
        generator.generate();
        LOG.info((String)"org.modelio.xmi.internal", (String)"END");
    }

    private void visitMetaclass(IClass metaclass) {
        String metaclassName = this.getMetaclassName(metaclass);
        this.generateMethodHeader(metaclassName);
        this.generateEcoreEltCreation(metaclassName);
        this.generateMethodReturnValue();
        this.generateMethodFooter();
    }

    private String getMetaclassName(IClass metaclass) {
        return metaclass.getName();
    }
}

