/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.util.generators;

import com.modeliosoft.modelio.core.log.LOG;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.internal.impl.ModelImpl;
import org.eclipse.uml2.uml.internal.resource.UMLResourceFactoryImpl;
import org.eclipse.uml2.uml.resource.UMLResource;

public class PartialCreationImportVisitorGen {
    private File file = null;
    private BufferedWriter buffer = null;
    private PrintWriter printer = null;
    private java.lang.Class<?> objingFactory = null;

    public PartialCreationImportVisitorGen(String path) {
        this.file = this.createFile(path);
        this.buffer = this.createBuffer(this.file);
        this.printer = this.createPrinter(this.buffer);
        try {
            this.objingFactory = java.lang.Class.forName("com.softeam.modelio.mda.model.UMLModel");
        }
        catch (ClassNotFoundException e) {
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
        }
    }

    public void generate() {
        this.generateImports();
        this.generateClassCode();
        this.closeFile();
    }

    private File createFile(String path) {
        return new File(path);
    }

    private BufferedWriter createBuffer(File theFile) {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(theFile));
        }
        catch (IOException e) {
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
        }
        return bw;
    }

    private PrintWriter createPrinter(BufferedWriter theBuffer) {
        PrintWriter print = null;
        if (theBuffer != null) {
            print = new PrintWriter(theBuffer);
        }
        return print;
    }

    private void generateJavadoc(String docText) {
        this.printer.println(docText);
    }

    private void generateImports() {
        this.printer.println("package com.modeliosoft.modelio.xmi.reverse;\r\n");
        this.printer.println("import org.eclipse.uml2.uml.*;");
        this.printer.println("import org.eclipse.uml2.uml.Class;");
        this.printer.println("import org.eclipse.uml2.uml.Package;");
        this.printer.println("import org.eclipse.uml2.uml.util.UMLSwitch;");
        this.printer.println();
        this.printer.println("import com.softeam.modelio.mda.objing.Modelio;");
        this.printer.println();
    }

    private void generateClassCode() {
        String docText = "/**\r\n* This class is used to get an Ijing element mapped from the given Ecore element.Call the \"createPartialIjingElt()\" method to get the corresponding Ijing element.\r\n*/";
        this.generateJavadoc(docText);
        this.generateClassHeader();
        this.generateMemberAttributes();
        this.generateConstructor();
        this.generatePublicMethods();
        this.generateInnerClassCode();
        this.generateClassFooter();
    }

    private void generateClassHeader() {
        this.printer.println("public class PartialCreationImportVisitorGenerated");
        this.printer.println("{");
    }

    private void generateClassFooter() {
        this.printer.println("}");
    }

    private void generateMemberAttributes() {
        String docText = "/**\r\n* Represents the Ijing element that will be returned (may be a List).\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("private Object objingElt;\r\n");
        docText = "/**\r\n* Visitor that will realize a switch to call the appropriate \"creation\" methods.\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("private CreationImportMapper mapper;\r\n");
        this.printer.println();
        docText = "/**\r\n* HashMap containing as key an Ecore element, and, as value, the corresponding Modelio element partially created.\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("private PartialImportMap partialMap;\r\n");
    }

    private void generateConstructor() {
        this.printer.println("public PartialCreationImportVisitorGenerated()");
        this.printer.println("{");
        this.printer.println("objingElt = null;");
        this.printer.println("mapper = new CreationImportMapper();");
        this.printer.println("partialMap = PartialImportMap.getInstance();");
        this.printer.println("}");
        this.printer.println();
    }

    private void closeFile() {
        this.printer.flush();
        this.printer.close();
    }

    private void generatePublicMethods() {
        String docText = "/**\r\n* Returns the Ijing element mapped from the given element.\r\n@param ecoreElt The element from which we will do the mapping.\r\n@return the Ijing element mapped from the element given as parameter.\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("public Object createPartialIjingElt(");
        this.printer.println("Element ecoreElt)");
        this.printer.println("{");
        this.printer.println("Object objingEltFromMap = partialMap.get(ecoreElt);");
        this.printer.println("if (objingEltFromMap == null) {");
        this.printer.println("mapper.accept(ecoreElt);");
        this.printer.println("partialMap.put(ecoreElt, objingElt);");
        this.printer.println("}");
        this.printer.println("return objingElt;");
        this.printer.println("}");
        this.printer.println();
    }

    private void generateInnerClassCode() {
        String docText = "/**\r\n* This class extends UMLSwitch and realizes a switch.\r\nThe class is inner and private, encapsulated to mask the \"visit\" methods to the user of the PartialCreationImportVisitor class.\r\nThe user will not see this class.\r\n*/";
        this.generateJavadoc(docText);
        this.generateInnerClassHeader();
        this.generateInnerMemberAttributes();
        this.generateInnerConstructor();
        docText = "/**\r\n* Launches the switch.\r\n*/";
        this.generateJavadoc(docText);
        this.generateInnerPublicMethods();
        this.generateInnerRedefinedMethods();
        this.generateInnerClassFooter();
    }

    private void generateInnerClassHeader() {
        this.printer.println("private class CreationImportMapper");
        this.printer.println("extends UMLSwitch");
        this.printer.println("{");
    }

    private void generateInnerClassFooter() {
        this.printer.println("}");
    }

    private void generateInnerMemberAttributes() {
    }

    private void generateInnerConstructor() {
    }

    private void generateInnerPublicMethods() {
        this.printer.println("public void accept(");
        this.printer.println("Element ecoreElt)");
        this.printer.println("{");
        this.printer.println("doSwitch(ecoreElt);");
        this.printer.println("}");
    }

    private List<Class> getUML2Metaclasses() {
        Resource res = this.loadEcoreModel();
        if (res != null) {
            List classes = this.parseUml2Metamodel(res);
            return classes;
        }
        return null;
    }

    private Resource loadEcoreModel() {
        ResourceSetImpl resourceSet2 = new ResourceSetImpl();
        resourceSet2.getPackageRegistry().put((Object)"http://www.eclipse.org/uml2/3.0.0/UML", (Object)UMLPackage.eINSTANCE);
        resourceSet2.getResourceFactoryRegistry().getExtensionToFactoryMap().put("uml", UMLResource.Factory.INSTANCE);
        Map uriMap = resourceSet2.getURIConverter().getURIMap();
        String path = "C:/eclipse new/workspace/XMI_prototype/lib/org.eclipse.uml2.uml.resources_2.0.0.v200606221411.jar!/";
        URI uri = URI.createURI((String)("jar:file:/" + path));
        uriMap.put(URI.createURI((String)"pathmap://UML_LIBRARIES/"), uri.appendSegment("libraries").appendSegment(""));
        uriMap.put(URI.createURI((String)"pathmap://UML_METAMODELS/"), uri.appendSegment("metamodels").appendSegment(""));
        uriMap.put(URI.createURI((String)"pathmap://UML_PROFILES/"), uri.appendSegment("profiles").appendSegment(""));
        resourceSet2.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new UMLResourceFactoryImpl());
        File modelFile = new File("C:/UML.metamodel.uml");
        URI fileURI2 = URI.createFileURI((String)modelFile.getAbsolutePath());
        try {
            return resourceSet2.getResource(fileURI2, true);
        }
        catch (Exception e) {
            LOG.error((String)"org.modelio.xmi.internal", (String)"invalidModel");
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
            return null;
        }
    }

    private void generateInnerRedefinedMethods() {
        List uml2Classes = this.getUML2Metaclasses();
        for (Class uml2Class : uml2Classes) {
            LOG.info((String)"org.modelio.xmi.internal", (String)uml2Class.getName());
            this.visitMetaclass(uml2Class);
        }
    }

    private void generateMethodHeader(String metaclassName) {
        String docText = "/**\r\n* Create the Modelio element from the given \"" + metaclassName + "\" Ecore element." + "\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("@Override");
        this.printer.print("public Object case");
        this.printer.print(metaclassName);
        this.printer.println("(");
        this.printer.print(metaclassName);
        this.printer.println(" ecoreElt)");
        this.printer.println("{");
    }

    private void generateMethodFooter() {
        this.printer.println("}");
        this.printer.println();
    }

    private void generateEcoreEltCreation(String metaclassName) {
        if (this.objingFactory != null) {
            try {
                Method method = this.objingFactory.getMethod("create" + metaclassName, null);
                if (method != null) {
                    this.printer.println("// TODO assert mapping is correct");
                    this.printer.println("objingElt = Modelio.getInstance().getModelingSession().getModel().create" + metaclassName + "();");
                }
            }
            catch (SecurityException e) {
                LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                this.printer.println("// TODO map ecore to objing");
                LOG.error((String)"org.modelio.xmi.internal", (String)("? create" + metaclassName + "() doesn't exist."));
            }
        }
    }

    private void generateMethodReturnValue() {
        this.printer.println("return null;");
    }

    public static void main(String[] args) {
        LOG.info((String)"org.modelio.xmi.internal", (String)"BEGIN");
        PartialCreationImportVisitorGen generator = new PartialCreationImportVisitorGen("C:/eclipse new/workspace/XMI_prototype/src/com/softeam/Modelio/xmi/generation/PartialCreationImportVisitorGenerated.java");
        generator.generate();
        LOG.info((String)"org.modelio.xmi.internal", (String)"END");
    }

    private List<Class> parseUml2Metamodel(Resource res) {
        ArrayList<Class> uml2Classes = new ArrayList();
        for (Object elem : res.getContents()) {
            if (!(elem instanceof ModelImpl)) continue;
            ModelImpl mdl = (ModelImpl)elem;
            for (Object umlElt : mdl.getPackagedElements()) {
                if (!(umlElt instanceof Class) || ((Class)umlElt).isAbstract()) continue;
                uml2Classes.add((Class)umlElt);
            }
        }
        uml2Classes = this.sortByName(uml2Classes);
        return uml2Classes;
    }

    private List<Class> sortByName(List<Class> uml2Classes) {
        int listSize = uml2Classes.size();
        boolean isDisordered = true;
        int i = 0;
        while (i < listSize && isDisordered) {
            isDisordered = false;
            int j = 1;
            while (j < listSize - i) {
                if (this.compareTo(uml2Classes.get(j), uml2Classes.get(j - 1)) < 0) {
                    Class tmpClass = uml2Classes.get(j - 1);
                    uml2Classes.set(j - 1, uml2Classes.get(j));
                    uml2Classes.set(j, tmpClass);
                    isDisordered = true;
                }
                ++j;
            }
            ++i;
        }
        return uml2Classes;
    }

    private int compareTo(Class class1, Class class2) {
        if (class1 != null && class2 != null) {
            return class1.getName().compareTo(class2.getName());
        }
        return -1;
    }

    private void visitMetaclass(Class metaclass) {
        String metaclassName = metaclass.getName();
        this.generateMethodHeader(metaclassName);
        this.generateEcoreEltCreation(metaclassName);
        this.generateMethodReturnValue();
        this.generateMethodFooter();
    }
}

