/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.util.generators;

import com.modeliosoft.modelio.core.log.LOG;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.internal.impl.ModelImpl;
import org.eclipse.uml2.uml.internal.resource.UMLResourceFactoryImpl;
import org.eclipse.uml2.uml.resource.UMLResource;

public class SequenceElementVisitorGen {
    private String metaclassName;
    private File file = null;
    private BufferedWriter buffer = null;
    private PrintWriter printer = null;

    public SequenceElementVisitorGen(String path) {
        this.file = this.createFile(path);
        this.buffer = this.createBuffer(this.file);
        this.printer = this.createPrinter(this.buffer);
    }

    public void generate() {
        this.generateImports();
        this.generateClassCode();
        this.closeFile();
    }

    private File createFile(String path) {
        return new File(path);
    }

    private BufferedWriter createBuffer(File theFile) {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(theFile));
        }
        catch (IOException e) {
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
        }
        return bw;
    }

    private PrintWriter createPrinter(BufferedWriter theBuffer) {
        PrintWriter print = null;
        if (theBuffer != null) {
            print = new PrintWriter(theBuffer);
        }
        return print;
    }

    private void generateJavadoc(String docText) {
        this.printer.println(docText);
    }

    private void generateImports() {
        this.printer.println("package com.modeliosoft.modelio.xmi.reverse;\r\n");
        this.printer.println("import org.eclipse.emf.ecore.EObject;");
        this.printer.println("import org.eclipse.uml2.uml.ActionExecutionSpecification;");
        this.printer.println("import org.eclipse.uml2.uml.BehaviorExecutionSpecification;");
        this.printer.println("import org.eclipse.uml2.uml.CombinedFragment;");
        this.printer.println("import org.eclipse.uml2.uml.ConsiderIgnoreFragment;");
        this.printer.println("import org.eclipse.uml2.uml.Continuation;");
        this.printer.println("import org.eclipse.uml2.uml.Element;");
        this.printer.println("import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;");
        this.printer.println("import org.eclipse.uml2.uml.ExecutionSpecification;");
        this.printer.println("import org.eclipse.uml2.uml.Gate;");
        this.printer.println("import org.eclipse.uml2.uml.Interaction;");
        this.printer.println("import org.eclipse.uml2.uml.InteractionOperand;");
        this.printer.println("import org.eclipse.uml2.uml.InteractionUse;");
        this.printer.println("import org.eclipse.uml2.uml.Message;");
        this.printer.println("import org.eclipse.uml2.uml.MessageOccurrenceSpecification;");
        this.printer.println("import org.eclipse.uml2.uml.OccurrenceSpecification;");
        this.printer.println("import org.eclipse.uml2.uml.PartDecomposition;");
        this.printer.println("import org.eclipse.uml2.uml.StateInvariant;");
        this.printer.println("import org.eclipse.uml2.uml.util.UMLSwitch;\r\n");
        this.printer.println("import com.modeliosoft.modelio.xmi.model.ecore.sequence.ActionExecutionSpecificationImportMapper;");
        this.printer.println("import com.modeliosoft.modelio.xmi.model.ecore.sequence.BehaviorExecutionSpecificationImportMapper;");
        this.printer.println("import com.modeliosoft.modelio.xmi.model.ecore.sequence.CombinedFragmentImportMapper;");
        this.printer.println("import com.modeliosoft.modelio.xmi.model.ecore.sequence.ConsiderIgnoreFragmentImportMapper;");
        this.printer.println("import com.modeliosoft.modelio.xmi.model.ecore.sequence.ContinuationImportMapper;");
        this.printer.println("import com.modeliosoft.modelio.xmi.model.ecore.sequence.ExecutionOccurrenceSpecificationImportMapper;");
        this.printer.println("import com.modeliosoft.modelio.xmi.model.ecore.sequence.ExecutionSpecificationImportMapper;");
        this.printer.println("import com.modeliosoft.modelio.xmi.model.ecore.sequence.GateImportMapper;");
        this.printer.println("import com.modeliosoft.modelio.xmi.model.ecore.sequence.InteractionOperandImportMapper;");
        this.printer.println("import com.modeliosoft.modelio.xmi.model.ecore.sequence.InteractionUseImportMapper;");
        this.printer.println("import com.modeliosoft.modelio.xmi.model.ecore.sequence.MessageImportMapper;");
        this.printer.println("import com.modeliosoft.modelio.xmi.model.ecore.sequence.MessageOccurrenceSpecificationImportMapper;");
        this.printer.println("import com.modeliosoft.modelio.xmi.model.ecore.sequence.OccurrenceSpecificationImportMapper;");
        this.printer.println("import com.modeliosoft.modelio.xmi.model.ecore.sequence.PartDecompositionImportMapper;");
        this.printer.println("import com.modeliosoft.modelio.xmi.model.ecore.sequence.SequenceElementImportMapper;");
        this.printer.println("import com.modeliosoft.modelio.xmi.model.ecore.sequence.StateInvariantImportMapper;\r\n");
    }

    private void generateClassCode() {
        this.generateClassHeader();
        this.generateMemberAttributes();
        this.generateConstructor();
        this.generatePublicMethods();
        this.generateInnerClassHeader();
        this.generateInnerClassBody();
        this.generateInnerClassClosure();
        this.generateClassClosure();
    }

    private void generateClassHeader() {
        String docText = "/**\r\n* This class is used to instanciate a Class that will do the mapping of an Emf-Uml2 sequence element to Modelio.\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("public class SequenceElementVisitorGenerated");
        this.printer.println("{");
    }

    private void generateMemberAttributes() {
        String docText = "/**\r\n* Represents the mapping class that will be returned.\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("private SequenceElementImportMapper mapper;\r\n");
        docText = "/**\r\n* Visitor that will realize a switch on the given element.\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("private SequenceElementVisitorGenerated.SequenceElementMappingSelector selector;\r\n");
    }

    private void generateConstructor() {
        String docText = "/**\r\n* Constructor.\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("public SequenceElementVisitorGenerated() {");
        this.printer.println("selector = new SequenceElementMappingSelector();");
        this.printer.println("}\r\n");
    }

    private void generatePublicMethods() {
        this.generateGetSequenceElementImportMapperMethod();
    }

    private void generateGetSequenceElementImportMapperMethod() {
        String docText = "/**\r\n* Returns an instance that will realize the mapping of an InteractionFragment from Emf-Uml2 to Modelio.\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("public SequenceElementImportMapper getSequenceImportMapper(Element eltToMap) {");
        this.printer.println("mapper = null;");
        this.printer.println("selector.doSwitch(eltToMap);");
        this.printer.println("return mapper;");
        this.printer.println("}\r\n");
    }

    private void generateInnerClassHeader() {
        String docText = "/**\r\n* Visitor that will realize a switch on the given element.<BR>\r\nEach method \"caseX\" shall not return null, as it would call the \"super.caseX\" method. As a consequence, all methods return 42, as it is the Ultimate Answer to Life, the Universe, and Everything... (The Hitchhiker's Guide to the Galaxy, Douglas Adams)\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("private class SequenceElementMappingSelector");
        this.printer.println("extends UMLSwitch");
        this.printer.println("{");
    }

    private void generateInnerClassBody() {
        this.generateDoSwitchMethod();
        Resource res = this.loadEcoreModel();
        if (res != null) {
            for (Class uml2Class : this.getUml2SequenceElts(res)) {
                LOG.info((String)"org.modelio.xmi.internal", (String)("metaclass = " + uml2Class.getName()));
                this.visitMetaclass(uml2Class);
            }
        }
    }

    private void generateDoSwitchMethod() {
        String docText = "/**\r\nCalls caseXXX for each class of the model until one returns a non null result; it yields that result.\r\n@param inputElement the target of the switch.\r\n@return the first non-null result returned by a caseXXX call.\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("@Override");
        this.printer.println("public Object doSwitch(");
        this.printer.println("EObject inputElement)");
        this.printer.println("{");
        this.printer.println("if (inputElement != null)");
        this.printer.println("return super.doSwitch(inputElement);");
        this.printer.println("else");
        this.printer.println("return null;");
        this.printer.println("}\r\n");
    }

    private Resource loadEcoreModel() {
        ResourceSetImpl resourceSet2 = new ResourceSetImpl();
        resourceSet2.getPackageRegistry().put((Object)"http://www.eclipse.org/uml2/3.0.0/UML", (Object)UMLPackage.eINSTANCE);
        resourceSet2.getResourceFactoryRegistry().getExtensionToFactoryMap().put("uml", UMLResource.Factory.INSTANCE);
        Map uriMap = resourceSet2.getURIConverter().getURIMap();
        String path = "C:/eclipse new/workspace/XMI_prototype/lib/org.eclipse.uml2.uml.resources_2.0.0.v200606221411.jar!/";
        URI uri = URI.createURI((String)("jar:file:/" + path));
        uriMap.put(URI.createURI((String)"pathmap://UML_LIBRARIES/"), uri.appendSegment("libraries").appendSegment(""));
        uriMap.put(URI.createURI((String)"pathmap://UML_METAMODELS/"), uri.appendSegment("metamodels").appendSegment(""));
        uriMap.put(URI.createURI((String)"pathmap://UML_PROFILES/"), uri.appendSegment("profiles").appendSegment(""));
        resourceSet2.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new UMLResourceFactoryImpl());
        File modelFile = new File("C:/uml2 metamodel version XMI/UML.metamodel.uml");
        URI fileURI2 = URI.createFileURI((String)modelFile.getAbsolutePath());
        try {
            return resourceSet2.getResource(fileURI2, true);
        }
        catch (Exception e) {
            LOG.error((String)"org.modelio.xmi.internal", (String)"invalidModel");
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
            return null;
        }
    }

    private void generateMethodHeader() {
        String docText = "/**\r\n* Instanciates the class that will realize the mapping for the element: " + this.metaclassName + ".<BR>\r\n" + "@return a non null value in order not to call the super class (see class definition for explanation of the \"42\" value)." + "\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("@Override");
        this.printer.println("public Object case" + this.metaclassName + "(" + this.metaclassName + " element" + ") {");
    }

    private void generateMethodReturnValue() {
        this.printer.println("return 42;");
    }

    private void generateMethodFooter() {
        this.printer.println("}");
    }

    private void generateInnerClassClosure() {
        this.printer.println("}");
    }

    private void generateClassClosure() {
        this.printer.println("}");
    }

    private void closeFile() {
        this.printer.flush();
        this.printer.close();
    }

    public static void main(String[] args) {
        LOG.info((String)"org.modelio.xmi.internal", (String)"BEGIN");
        SequenceElementVisitorGen gen = new SequenceElementVisitorGen("C:/eclipse new/workspace/XMI_prototype/src/com/softeam/Modelio/xmi/reverse/SequenceElementVisitorGenerated.java");
        gen.generate();
        LOG.info((String)"org.modelio.xmi.internal", (String)"END");
    }

    private List<Class> getUml2SequenceElts(Resource res) {
        ArrayList<Class> uml2SequenceEltList = new ArrayList<Class>();
        List uml2Metaclasses = this.getUml2Metaclasses(res);
        for (Class uml2Class : uml2Metaclasses) {
            if (!this.isSequenceElement(uml2Class)) continue;
            uml2SequenceEltList.add(uml2Class);
        }
        return uml2SequenceEltList;
    }

    private boolean isSequenceElement(Class uml2Class) {
        return "ActionExecutionSpecification".equals(uml2Class.getName()) || "BehaviorExecutionSpecification".equals(uml2Class.getName()) || "CombinedFragment".equals(uml2Class.getName()) || "ConsiderIgnoreFragment".equals(uml2Class.getName()) || "Continuation".equals(uml2Class.getName()) || "ExecutionOccurrenceSpecification".equals(uml2Class.getName()) || "ExecutionSpecification".equals(uml2Class.getName()) || "Gate".equals(uml2Class.getName()) || "Interaction".equals(uml2Class.getName()) || "InteractionOperand".equals(uml2Class.getName()) || "InteractionUse".equals(uml2Class.getName()) || "Message".equals(uml2Class.getName()) || "MessageOccurrenceSpecification".equals(uml2Class.getName()) || "OccurrenceSpecification".equals(uml2Class.getName()) || "PartDecomposition".equals(uml2Class.getName()) || "StateInvariant".equals(uml2Class.getName());
    }

    private List<Class> getUml2Metaclasses(Resource res) {
        ArrayList<Class> uml2Classes = new ArrayList();
        for (Object elem : res.getContents()) {
            if (!(elem instanceof ModelImpl)) continue;
            ModelImpl mdl = (ModelImpl)elem;
            for (Object umlElt : mdl.getPackagedElements()) {
                if (!(umlElt instanceof Class)) continue;
                uml2Classes.add((Class)umlElt);
            }
        }
        uml2Classes = this.sortByName(uml2Classes);
        return uml2Classes;
    }

    private List<Class> sortByName(List<Class> uml2Classes) {
        int listSize = uml2Classes.size();
        boolean isDisordered = true;
        int i = 0;
        while (i < listSize && isDisordered) {
            isDisordered = false;
            int j = 1;
            while (j < listSize - i) {
                if (this.compareTo(uml2Classes.get(j), uml2Classes.get(j - 1)) < 0) {
                    Class tmpClass = uml2Classes.get(j - 1);
                    uml2Classes.set(j - 1, uml2Classes.get(j));
                    uml2Classes.set(j, tmpClass);
                    isDisordered = true;
                }
                ++j;
            }
            ++i;
        }
        return uml2Classes;
    }

    private int compareTo(Class class1, Class class2) {
        if (class1 != null && class2 != null) {
            return class1.getName().toUpperCase().compareTo(class2.getName().toUpperCase());
        }
        return -1;
    }

    private void visitMetaclass(Class metaclass) {
        this.metaclassName = metaclass.getName();
        this.generateMethodHeader();
        this.generateMethodBody();
        this.generateMethodReturnValue();
        this.generateMethodFooter();
    }

    private void generateMethodBody() {
        if ("Interaction".equals(this.metaclassName)) {
            this.printer.print("//");
        }
        this.printer.println("mapper = new " + this.metaclassName + "ImportMapper(element);");
    }
}

