/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.util.generators;

import com.modeliosoft.modelio.core.log.LOG;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.internal.impl.ModelImpl;
import org.eclipse.uml2.uml.internal.resource.UMLResourceFactoryImpl;
import org.eclipse.uml2.uml.resource.UMLResource;

public class Uml2InheritanceGen {
    private File file = null;
    private BufferedWriter buffer = null;
    private PrintWriter printer = null;

    public Uml2InheritanceGen(String path) {
        this.file = this.createFile(path);
        this.buffer = this.createBuffer(this.file);
        this.printer = this.createPrinter(this.buffer);
    }

    private File createFile(String path) {
        return new File(path);
    }

    private BufferedWriter createBuffer(File theFile) {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(theFile));
        }
        catch (IOException e) {
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
        }
        return bw;
    }

    private PrintWriter createPrinter(BufferedWriter theBuffer) {
        PrintWriter print = null;
        if (theBuffer != null) {
            print = new PrintWriter(theBuffer);
        }
        return print;
    }

    private void generateJavadoc(String docText) {
        this.printer.println(docText);
    }

    private void generate() {
        this.generateImports();
        this.generateClassCode();
        this.closeFile();
    }

    private void generateImports() {
        this.printer.println("package com.modeliosoft.modelio.xmi.util;\r\n");
        this.printer.println("import java.util.ArrayList;");
        this.printer.println("import java.util.List;\r\n");
        this.printer.println("import org.eclipse.uml2.uml.*;");
        this.printer.println("\r\n");
    }

    private void generateClassCode() {
        this.generateClassHeader();
        this.generateMemberAttributes();
        this.generateConstructor();
        this.generateMemberMethods();
        this.generateClassClosure();
    }

    private void generateClassHeader() {
        String docText = "/**\r\n* This class is used to parse EMF-UML2 metamodel along inheritance relations.\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("public class Uml2InheritanceGenerated");
        this.printer.println("{");
    }

    private void generateMemberAttributes() {
        String docText = "/**\r\n* List containing names of classes that have at least one concrete super class.\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("private List<String> concreteSuperClasses;");
        this.printer.println("\r\n");
    }

    private void generateConstructor() {
        this.printer.println("public Uml2InheritanceGenerated() {");
        this.printer.println("concreteSuperClasses = new ArrayList<String>();");
        this.printer.println("initList();");
        this.printer.println("}");
        this.printer.println();
    }

    private void generateMemberMethods() {
        this.generateHasConcreteSuperMethod();
        this.generateInitializeMethod();
    }

    private void generateHasConcreteSuperMethod() {
        String docText = "/**\r\n* Returns true if the given class has at least one concrete super class;<BR>\r\n* Returns false, else.\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("public boolean hasConcreteSuperClass(String metaclassName)");
        this.printer.println("{");
        this.printer.println("if (concreteSuperClasses.contains(metaclassName))");
        this.printer.println("return true;");
        this.printer.println("else");
        this.printer.println("return false;");
        this.printer.println("}");
        this.printer.println();
    }

    private void generateInitializeMethod() {
        String docText = "/**\r\n* Initializes the List of classes that have at least one concrete super class.\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("private void initList()");
        this.printer.println("{");
        this.generateInitializeMethodBody();
        this.printer.println("}");
    }

    private void generateInitializeMethodBody() {
        Resource res = this.loadEcoreModel();
        if (res != null) {
            for (Class uml2Class : this.getUml2Metaclasses(res)) {
                this.visitMetaclass(uml2Class);
            }
        }
    }

    private Resource loadEcoreModel() {
        ResourceSetImpl resourceSet2 = new ResourceSetImpl();
        resourceSet2.getPackageRegistry().put((Object)"http://www.eclipse.org/uml2/3.0.0/UML", (Object)UMLPackage.eINSTANCE);
        resourceSet2.getResourceFactoryRegistry().getExtensionToFactoryMap().put("uml", UMLResource.Factory.INSTANCE);
        Map uriMap = resourceSet2.getURIConverter().getURIMap();
        String path = "C:/eclipse new/workspace/XMI_prototype/lib/org.eclipse.uml2.uml.resources_2.0.0.v200606221411.jar!/";
        URI uri = URI.createURI((String)("jar:file:/" + path));
        uriMap.put(URI.createURI((String)"pathmap://UML_LIBRARIES/"), uri.appendSegment("libraries").appendSegment(""));
        uriMap.put(URI.createURI((String)"pathmap://UML_METAMODELS/"), uri.appendSegment("metamodels").appendSegment(""));
        uriMap.put(URI.createURI((String)"pathmap://UML_PROFILES/"), uri.appendSegment("profiles").appendSegment(""));
        resourceSet2.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new UMLResourceFactoryImpl());
        File modelFile = new File("C:/UML.metamodel.uml");
        URI fileURI2 = URI.createFileURI((String)modelFile.getAbsolutePath());
        try {
            return resourceSet2.getResource(fileURI2, true);
        }
        catch (Exception e) {
            LOG.error((String)"org.modelio.xmi.internal", (String)"invalidModel");
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
            return null;
        }
    }

    private void generateClassClosure() {
        this.printer.println("}");
    }

    private void closeFile() {
        this.printer.flush();
        this.printer.close();
    }

    public static void main(String[] args) {
        LOG.info((String)"org.modelio.xmi.internal", (String)"BEGIN");
        Uml2InheritanceGen gen = new Uml2InheritanceGen("C:/eclipse new/workspace/XMI_prototype/src/com/softeam/Modelio/xmi/util/Uml2InheritanceGenerated.java");
        gen.generate();
        LOG.info((String)"org.modelio.xmi.internal", (String)"END");
    }

    private List<Class> getUml2Metaclasses(Resource res) {
        ArrayList<Class> uml2Classes = new ArrayList();
        for (Object elem : res.getContents()) {
            if (!(elem instanceof ModelImpl)) continue;
            ModelImpl mdl = (ModelImpl)elem;
            for (Object umlElt : mdl.getPackagedElements()) {
                if (!(umlElt instanceof Class)) continue;
                uml2Classes.add((Class)umlElt);
            }
        }
        uml2Classes = this.sortByName(uml2Classes);
        return uml2Classes;
    }

    private List<Class> sortByName(List<Class> uml2Classes) {
        int listSize = uml2Classes.size();
        boolean isDisordered = true;
        int i = 0;
        while (i < listSize && isDisordered) {
            isDisordered = false;
            int j = 1;
            while (j < listSize - i) {
                if (this.compareTo(uml2Classes.get(j), uml2Classes.get(j - 1)) < 0) {
                    Class tmpClass = uml2Classes.get(j - 1);
                    uml2Classes.set(j - 1, uml2Classes.get(j));
                    uml2Classes.set(j, tmpClass);
                    isDisordered = true;
                }
                ++j;
            }
            ++i;
        }
        return uml2Classes;
    }

    private int compareTo(Class class1, Class class2) {
        if (class1 != null && class2 != null) {
            return class1.getName().toUpperCase().compareTo(class2.getName().toUpperCase());
        }
        return -1;
    }

    private void visitMetaclass(Class uml2Class) {
        if (this.hasConcreteSuperClass(uml2Class)) {
            this.printer.println("concreteSuperClasses.add(");
            this.printer.print(uml2Class.getName());
            this.printer.println(".class.getSimpleName());");
        }
    }

    private boolean hasConcreteSuperClass(Class uml2Class) {
        boolean hasConcreteSC = false;
        if (!"Element".equals(uml2Class.getName())) {
            for (Object superIj : uml2Class.getSuperClasses()) {
                Class superClass = (Class)superIj;
                if (!superClass.isAbstract()) {
                    hasConcreteSC = true;
                    break;
                }
                if (!this.hasConcreteSuperClass(superClass)) continue;
                hasConcreteSC = true;
                break;
            }
        }
        return hasConcreteSC;
    }
}

