/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.util.generators;

import com.modeliosoft.modelio.core.log.LOG;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.internal.impl.ModelImpl;
import org.eclipse.uml2.uml.internal.resource.UMLResourceFactoryImpl;
import org.eclipse.uml2.uml.resource.UMLResource;

public class Uml2InsertableIFVisitorGen {
    private String metaclassName;
    private File file = null;
    private BufferedWriter buffer = null;
    private PrintWriter printer = null;

    public Uml2InsertableIFVisitorGen(String path) {
        this.file = this.createFile(path);
        this.buffer = this.createBuffer(this.file);
        this.printer = this.createPrinter(this.buffer);
    }

    public void generate() {
        this.generateImports();
        this.generateClassCode();
        this.closeFile();
    }

    private File createFile(String path) {
        return new File(path);
    }

    private BufferedWriter createBuffer(File theFile) {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(theFile));
        }
        catch (IOException e) {
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
        }
        return bw;
    }

    private PrintWriter createPrinter(BufferedWriter theBuffer) {
        PrintWriter print = null;
        if (theBuffer != null) {
            print = new PrintWriter(theBuffer);
        }
        return print;
    }

    private void generateJavadoc(String docText) {
        this.printer.println(docText);
    }

    private void generateImports() {
        this.printer.println("package com.modeliosoft.modelio.xmi.reverse;\r\n");
        this.printer.println("import java.util.ArrayList;");
        this.printer.println("import java.util.List;\r\n");
        this.printer.println("import org.eclipse.emf.ecore.EObject;");
        this.printer.println("import org.eclipse.uml2.uml.ActionExecutionSpecification;");
        this.printer.println("import org.eclipse.uml2.uml.BehaviorExecutionSpecification;");
        this.printer.println("import org.eclipse.uml2.uml.CombinedFragment;");
        this.printer.println("import org.eclipse.uml2.uml.ConsiderIgnoreFragment;");
        this.printer.println("import org.eclipse.uml2.uml.Continuation;");
        this.printer.println("import org.eclipse.uml2.uml.Element;");
        this.printer.println("import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;");
        this.printer.println("import org.eclipse.uml2.uml.ExecutionSpecification;");
        this.printer.println("import org.eclipse.uml2.uml.Interaction;");
        this.printer.println("import org.eclipse.uml2.uml.InteractionFragment;");
        this.printer.println("import org.eclipse.uml2.uml.InteractionOperand;");
        this.printer.println("import org.eclipse.uml2.uml.InteractionUse;");
        this.printer.println("import org.eclipse.uml2.uml.MessageOccurrenceSpecification;");
        this.printer.println("import org.eclipse.uml2.uml.OccurrenceSpecification;");
        this.printer.println("import org.eclipse.uml2.uml.PartDecomposition;");
        this.printer.println("import org.eclipse.uml2.uml.StateInvariant;");
        this.printer.println("import org.eclipse.uml2.uml.util.UMLSwitch;\r\n");
    }

    private void generateClassCode() {
        String docText = "/**\r\n* This class is used to get the elements that can be inserted in a sequence diagram with the JONI API.\r\n*/";
        this.generateJavadoc(docText);
        this.generateClassHeader();
        this.generateMemberAttributes();
        this.generateConstructor();
        this.generatePublicMethods();
        this.generateInnerClassHeader();
        this.generateInnerClassBody();
        this.generateInnerClassClosure();
        this.generateClassClosure();
    }

    private void generateClassHeader() {
        this.printer.println("public class Uml2InsertableIFVisitorGenerated");
        this.printer.println("{");
    }

    private void generateMemberAttributes() {
        String docText = "/**\r\n* Represents the elements that can be inserted in a sequence diagram with the JONI API.\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("private List<Element> insertableElements = new ArrayList<Element>();\r\n");
        docText = "/**\r\n* Visitor that will realize a switch on InteractionFragments.\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("private Uml2InsertableIFVisitorGenerated.InsertableIFSelector selector;\r\n");
    }

    private void generateConstructor() {
        String docText = "/**\r\n* Constructor.\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("public Uml2InsertableIFVisitorGenerated() {");
        this.printer.println("selector = new InsertableIFSelector();");
        this.printer.println("}\r\n");
    }

    private void generatePublicMethods() {
        this.generateGetInsertableElementsMethod();
    }

    private void generateGetInsertableElementsMethod() {
        String docText = "/**\r\n* Returns the list of elements that can be inserted in a sequence diagram with the JONI API.\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("public List<Element> getInsertableElements(InteractionFragment theIF) {");
        this.printer.println("insertableElements.clear();");
        this.printer.println("selector.doSwitch(theIF);");
        this.printer.println("return insertableElements;");
        this.printer.println("}\r\n");
    }

    private void generateInnerClassHeader() {
        String docText = "/**\r\n* Visitor that will realize a switch on InteractionFragments.<BR>\r\nEach method \"caseX\" shall not return null, as it would call the \"super.caseX\" method. As a consequence, all methods return 42, as it is the Ultimate Answer to Life, the Universe, and Everything... (The Hitchhiker's Guide to the Galaxy, Douglas Adams)\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("private class InsertableIFSelector");
        this.printer.println("extends UMLSwitch");
        this.printer.println("{");
    }

    private void generateInnerClassBody() {
        this.generateDoSwitchMethod();
        Resource res = this.loadEcoreModel();
        if (res != null) {
            for (Class uml2Class : this.getUml2IF(res)) {
                LOG.info((String)"org.modelio.xmi.internal", (String)("metaclass = " + uml2Class.getName()));
                this.visitMetaclass(uml2Class);
            }
        }
    }

    private void generateDoSwitchMethod() {
        String docText = "/**\r\nCalls caseXXX for each class of the model until one returns a non null result; it yields that result.\r\n@param inputElement the target of the switch.\r\n@return the first non-null result returned by a caseXXX call.\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("@Override");
        this.printer.println("public Object doSwitch(");
        this.printer.println("EObject inputElement)");
        this.printer.println("{");
        this.printer.println("if (inputElement != null)");
        this.printer.println("return super.doSwitch(inputElement);");
        this.printer.println("else");
        this.printer.println("return null;");
        this.printer.println("}\r\n");
    }

    private Resource loadEcoreModel() {
        ResourceSetImpl resourceSet2 = new ResourceSetImpl();
        resourceSet2.getPackageRegistry().put((Object)"http://www.eclipse.org/uml2/3.0.0/UML", (Object)UMLPackage.eINSTANCE);
        resourceSet2.getResourceFactoryRegistry().getExtensionToFactoryMap().put("uml", UMLResource.Factory.INSTANCE);
        Map uriMap = resourceSet2.getURIConverter().getURIMap();
        String path = "C:/eclipse new/workspace/XMI_prototype/lib/org.eclipse.uml2.uml.resources_2.0.0.v200606221411.jar!/";
        URI uri = URI.createURI((String)("jar:file:/" + path));
        uriMap.put(URI.createURI((String)"pathmap://UML_LIBRARIES/"), uri.appendSegment("libraries").appendSegment(""));
        uriMap.put(URI.createURI((String)"pathmap://UML_METAMODELS/"), uri.appendSegment("metamodels").appendSegment(""));
        uriMap.put(URI.createURI((String)"pathmap://UML_PROFILES/"), uri.appendSegment("profiles").appendSegment(""));
        resourceSet2.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new UMLResourceFactoryImpl());
        File modelFile = new File("C:/uml2 metamodel version XMI/UML.metamodel.uml");
        URI fileURI2 = URI.createFileURI((String)modelFile.getAbsolutePath());
        try {
            return resourceSet2.getResource(fileURI2, true);
        }
        catch (Exception e) {
            LOG.error((String)"org.modelio.xmi.internal", (String)"invalidModel");
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
            return null;
        }
    }

    private void generateMethodHeader() {
        String docText = "/**\r\n* Visits the InteractionFragment \"" + this.metaclassName + "\" and its relations to other elements to store those that can be inserted in a sequence diagram with the JONI API." + ".<BR>\r\n" + "@return a non null value in order not to call the super class (see class definition for explanation of the \"42\" value)." + "\r\n*/";
        this.generateJavadoc(docText);
        this.printer.println("@Override");
        this.printer.println("public Object case" + this.metaclassName + "(" + this.metaclassName + " fragment" + ") {");
    }

    private void generateMethodReturnValue() {
        this.printer.println("return 42;");
    }

    private void generateMethodFooter() {
        this.printer.println("}");
    }

    private void generateInnerClassClosure() {
        this.printer.println("}");
    }

    private void generateClassClosure() {
        this.printer.println("}");
    }

    private void closeFile() {
        this.printer.flush();
        this.printer.close();
    }

    public static void main(String[] args) {
        LOG.info((String)"org.modelio.xmi.internal", (String)"BEGIN");
        Uml2InsertableIFVisitorGen gen = new Uml2InsertableIFVisitorGen("C:/eclipse new/workspace/XMI_prototype/src/com/softeam/Modelio/xmi/reverse/Uml2InsertableIFVisitorGenerated.java");
        gen.generate();
        LOG.info((String)"org.modelio.xmi.internal", (String)"END");
    }

    private List<Class> getUml2IF(Resource res) {
        ArrayList<Class> uml2IFList = new ArrayList<Class>();
        List uml2Metaclasses = this.getUml2Metaclasses(res);
        Class uml2IFMetaclass = null;
        for (Class uml2Class : uml2Metaclasses) {
            if (!"InteractionFragment".equals(uml2Class.getName())) continue;
            uml2IFMetaclass = uml2Class;
            break;
        }
        for (Class uml2Class : uml2Metaclasses) {
            List generals = this.getRecursiveGenerals((Classifier)uml2Class, new ArrayList());
            if (!generals.contains(uml2IFMetaclass)) continue;
            uml2IFList.add(uml2Class);
        }
        return uml2IFList;
    }

    private List<Classifier> getRecursiveGenerals(Classifier uml2Class, List<Classifier> superClasses) {
        EList generals = uml2Class.getGenerals();
        if (generals.size() > 0) {
            superClasses.addAll((Collection<Classifier>)generals);
            for (Classifier superClass : generals) {
                this.getRecursiveGenerals(superClass, superClasses);
            }
        }
        return superClasses;
    }

    private List<Class> getUml2Metaclasses(Resource res) {
        ArrayList<Class> uml2Classes = new ArrayList();
        for (Object elem : res.getContents()) {
            if (!(elem instanceof ModelImpl)) continue;
            ModelImpl mdl = (ModelImpl)elem;
            for (Object umlElt : mdl.getPackagedElements()) {
                if (!(umlElt instanceof Class)) continue;
                uml2Classes.add((Class)umlElt);
            }
        }
        uml2Classes = this.sortByName(uml2Classes);
        return uml2Classes;
    }

    private List<Class> sortByName(List<Class> uml2Classes) {
        int listSize = uml2Classes.size();
        boolean isDisordered = true;
        int i = 0;
        while (i < listSize && isDisordered) {
            isDisordered = false;
            int j = 1;
            while (j < listSize - i) {
                if (this.compareTo(uml2Classes.get(j), uml2Classes.get(j - 1)) < 0) {
                    Class tmpClass = uml2Classes.get(j - 1);
                    uml2Classes.set(j - 1, uml2Classes.get(j));
                    uml2Classes.set(j, tmpClass);
                    isDisordered = true;
                }
                ++j;
            }
            ++i;
        }
        return uml2Classes;
    }

    private int compareTo(Class class1, Class class2) {
        if (class1 != null && class2 != null) {
            return class1.getName().toUpperCase().compareTo(class2.getName().toUpperCase());
        }
        return -1;
    }

    private void visitMetaclass(Class metaclass) {
        this.metaclassName = metaclass.getName();
        this.generateMethodHeader();
        this.generateMethodBody();
        this.generateMethodReturnValue();
        this.generateMethodFooter();
    }

    private void generateMethodBody() {
    }
}

