/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.impexp.model;

import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.app.impexp.model.ImportHandler;
import com.modeliosoft.modelio.app.impexp.model.ImportModelDataModel;
import com.modeliosoft.modelio.app.impexp.model.ImportModelDialog;
import com.modeliosoft.modelio.app.impexp.model.ModelImporter;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.app.exml.ExmlImporter;
import com.modeliosoft.modelio.core.app.extFile.ExtFileImporter;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class ImportHandler
extends AbstractHandler {
    public void dispose() {
    }

    /*
     * Loose catch block
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        com.modeliosoft.modelio.core.IModelingSession destModelingSession = O.getDefault().getModelingSession();
        IModelingSession mdaSession = Modelio.getInstance().getModelingSession();
        ITransactionManager transactionManager = destModelingSession.getTransactionManager();
        ITransaction transaction = transactionManager.createTransaction("Import model");
        ImportModelDataModel dataModel = new ImportModelDataModel();
        try {
            try {
                if (this.promptUser(dataModel, mdaSession) && dataModel.getElementsToImport().size() > 0) {
                    this.importModel(destModelingSession, dataModel);
                    transactionManager.commit(transaction);
                    transaction = null;
                } else {
                    transactionManager.rollback(transaction);
                    transaction = null;
                }
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                dataModel.dispose();
                if (transaction != null) {
                    transactionManager.rollback(transaction);
                }
            }
            catch (InterruptedException e) {
                dataModel.dispose();
                if (transaction != null) {
                    transactionManager.rollback(transaction);
                }
            }
            catch (InvalidTransactionException e) {
                e.printStackTrace();
                transaction = null;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                dataModel.dispose();
                if (transaction != null) {
                    transactionManager.rollback(transaction);
                }
            }
        }
        finally {
            dataModel.dispose();
            if (transaction != null) {
                transactionManager.rollback(transaction);
            }
        }
        return null;
    }

    public boolean isEnabled() {
        return Modelio.getInstance().getModelingSession() != null;
    }

    public boolean isHandled() {
        return true;
    }

    private void importExtFile(String sfilePath) throws IOException {
        com.modeliosoft.modelio.core.IModelingSession destSession = O.getDefault().getModelingSession();
        ExtFileImporter importer = new ExtFileImporter(destSession.getNativeSession());
        ITransactionManager tm = destSession.getTransactionManager();
        ITransaction t = tm.createTransaction("Import " + sfilePath + " file.");
        try {
            try {
                importer.importFile(sfilePath, (IElement)destSession.getModel().getProject().getModel());
                tm.commit(t);
                t = null;
            }
            catch (InvalidTransactionException e) {
                t = null;
                throw e;
            }
        }
        finally {
            if (t != null) {
                tm.rollback(t);
            }
        }
    }

    private void importModel(com.modeliosoft.modelio.core.IModelingSession destModelingSession, ImportModelDataModel dataModel) throws InvocationTargetException, InterruptedException {
        ModelImporter modelImporter = new ModelImporter(destModelingSession, dataModel);
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        service.run(true, false, (IRunnableWithProgress)modelImporter);
    }

    private void importXmlMuFile(Shell parentShell, File filePath) throws IOException {
        com.modeliosoft.modelio.core.IModelingSession destSession = O.getDefault().getModelingSession();
        ExmlImporter importer = new ExmlImporter(destSession.getNativeSession());
        importer.addFile(filePath);
        ITransactionManager tm = destSession.getTransactionManager();
        ITransaction t = tm.createTransaction("Import " + filePath.getPath() + " file.");
        try {
            try {
                XmlMuProblemReporter pbReporter = new XmlMuProblemReporter(this, parentShell);
                importer.setProblemReporter((Object)pbReporter);
                importer.execute();
                tm.commit(t);
                t = null;
            }
            catch (InvalidTransactionException e) {
                t = null;
                throw e;
            }
        }
        finally {
            if (t != null) {
                tm.rollback(t);
            }
        }
    }

    private boolean promptUser(ImportModelDataModel dataModel, IModelingSession mdaSession) {
        Shell parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ImportModelDialog dialog = new ImportModelDialog(parentShell, mdaSession, dataModel);
        int code = dialog.open();
        return code == 0;
    }
}

