/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.impexp.model;

import com.modeliosoft.modelio.api.model.analyst.IAnalystProject;
import com.modeliosoft.modelio.api.model.extension.IProject;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.app.impexp.model.ImportModelCardVisitor;
import com.modeliosoft.modelio.app.impexp.model.ImportModelContentVisitor;
import com.modeliosoft.modelio.app.impexp.model.ImportModelElementAdapter;
import com.modeliosoft.modelio.app.impexp.model.ImportModelTreeInput;
import com.modeliosoft.modelio.app.impexp.model.ImportRootElementAdapter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

class ImportModelContentProvider
implements ITreeContentProvider {
    ImportModelContentProvider() {
    }

    public void dispose() {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ImportModelElementAdapter) {
            ImportModelElementAdapter adapter = (ImportModelElementAdapter)parentElement;
            return this.getChildren(adapter);
        }
        if (parentElement instanceof ImportRootElementAdapter) {
            ImportRootElementAdapter adapter = (ImportRootElementAdapter)parentElement;
            return this.getChildren(adapter);
        }
        return new Object[0];
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof ImportModelTreeInput) {
            return new Object[]{((ImportModelTreeInput)inputElement).getRoot()};
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object parentElement) {
        if (parentElement instanceof ImportRootElementAdapter) {
            ImportRootElementAdapter adapter = (ImportRootElementAdapter)parentElement;
            IProject project = adapter.getUmlProject();
            IAnalystProject requirementProject = adapter.getRequirementProject();
            int elementsNb = 0;
            if (project != null) {
                if (project.getDiagramRoot() != null) {
                    ++elementsNb;
                }
                if (project.getModel() != null) {
                    ++elementsNb;
                }
            }
            if (requirementProject != null) {
                if (requirementProject.getRequirementRoot() != null) {
                    ++elementsNb;
                }
                if (requirementProject.getGoalRoot() != null) {
                    ++elementsNb;
                }
                if (requirementProject.getBusinessRuleRoot() != null) {
                    ++elementsNb;
                }
                if (requirementProject.getDictionaryRoot() != null) {
                    ++elementsNb;
                }
            }
            return elementsNb > 0;
        }
        if (parentElement instanceof ImportModelElementAdapter) {
            ImportModelCardVisitor cardVisitor = new ImportModelCardVisitor();
            ImportModelElementAdapter adapter = (ImportModelElementAdapter)parentElement;
            IElement element = adapter.getElement();
            return cardVisitor.getCardChildren(element) > 0;
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private Object[] getChildren(ImportRootElementAdapter adapter) {
        IProject project = adapter.getUmlProject();
        IAnalystProject requirementProject = adapter.getRequirementProject();
        ArrayList elements = new ArrayList();
        if (project != null) {
            this.addAdapter(elements, (IElement)project.getModel());
            this.addAdapter(elements, (IElement)project.getDiagramRoot());
        }
        if (requirementProject != null) {
            this.addAdapter(elements, (IElement)requirementProject.getRequirementRoot());
            this.addAdapter(elements, (IElement)requirementProject.getGoalRoot());
            this.addAdapter(elements, (IElement)requirementProject.getBusinessRuleRoot());
            this.addAdapter(elements, (IElement)requirementProject.getDictionaryRoot());
        }
        return elements.toArray(new ImportModelElementAdapter[elements.size()]);
    }

    private Object[] getChildren(ImportModelElementAdapter adapter) {
        IElement element = adapter.getElement();
        ImportModelContentVisitor contentVisitor = new ImportModelContentVisitor();
        List childrenElements = contentVisitor.getChildren(element);
        ArrayList<IElement> displayedChildren = new ArrayList<IElement>();
        for (IElement child : childrenElements) {
            IElementStatus childStatus = child.getElementStatus();
            if (childStatus.isRamcObject()) continue;
            displayedChildren.add(child);
        }
        Object[] children = new Object[displayedChildren.size()];
        int cpt = 0;
        for (IElement child : displayedChildren) {
            children[cpt] = new ImportModelElementAdapter(child);
            ++cpt;
        }
        return children;
    }

    private void addAdapter(List<ImportModelElementAdapter> adapters, IElement el) {
        if (el != null) {
            adapters.add(new ImportModelElementAdapter(el, true));
        }
    }
}

