/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.impexp.model;

import com.modeliosoft.modelio.app.impexp.model.ImportModelDataModel;
import com.modeliosoft.modelio.app.impexp.model.ImportModelDialog;
import com.modeliosoft.modelio.app.impexp.ui.Messages;
import com.modeliosoft.modelio.core.OfpFile;
import com.modeliosoft.modelio.core.app.AppInfos;
import java.io.File;
import java.io.IOException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Shell;

class ImportModelController
implements ModifyListener,
SelectionListener {
    private ImportModelDataModel dataModel = null;
    private ImportModelDialog dialog = null;

    public ImportModelController(ImportModelDataModel dataModel, ImportModelDialog dialog) {
        this.dataModel = dataModel;
        this.dialog = dialog;
    }

    public void modifyText(ModifyEvent event) {
        String ofpxPath = this.dialog.getOfpxPath();
        boolean isValidOfpxPath = true;
        if (event.widget == this.dialog.ofpxPathText) {
            isValidOfpxPath = this.validateOfpxPath();
            if (isValidOfpxPath) {
                OfpFile ofp = new OfpFile(new File(ofpxPath));
                try {
                    String lockOwner = ofp.getLockOwner();
                    if (!lockOwner.isEmpty()) {
                        MessageDialog.openError((Shell)this.dialog.getShell(), (String)Messages.getString((String)"ImportModelDialog.LockedProjectErrorTitle"), (String)Messages.getMessage((String)"ImportModelDialog.LockedProjectErrorMessage", (String[])new String[]{ofpxPath, lockOwner}));
                        return;
                    }
                    int mmVersion = ofp.getMetamodelVersion();
                    if (mmVersion < AppInfos.getMetamodelVersion()) {
                        MessageDialog.openError((Shell)this.dialog.getShell(), (String)Messages.getString((String)"ImportModelDialog.ProjectTooOldErrorTitle"), (String)Messages.getMessage((String)"ImportModelDialog.ProjectTooOldErrorMessage", (String[])new String[]{ofpxPath, String.valueOf(mmVersion)}));
                        return;
                    }
                    if (mmVersion > AppInfos.getMetamodelVersion()) {
                        MessageDialog.openError((Shell)this.dialog.getShell(), (String)Messages.getString((String)"ImportModelDialog.ProjectTooNewErrorTitle"), (String)Messages.getMessage((String)"ImportModelDialog.ProjectTooNewErrorMessage", (String[])new String[]{ofpxPath, String.valueOf(mmVersion)}));
                        return;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    MessageDialog.openError((Shell)this.dialog.getShell(), (String)Messages.getString((String)"ImportModelDialog.LockedProjectErrorTitle"), (String)e.getLocalizedMessage());
                    return;
                }
                this.dataModel.updateImportModelData(new File(ofpxPath));
            }
            this.dialog.invalidateOfpxPath(!isValidOfpxPath);
        }
        this.dialog.refresh();
        this.dialog.updateButtons(isValidOfpxPath);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.radioSelected();
    }

    public void widgetSelected(SelectionEvent e) {
        this.radioSelected();
    }

    private void radioSelected() {
        if (this.dialog.reidentifyImportRadio.getSelection()) {
            this.dataModel.setReidentify(true);
            this.dataModel.setImportDescription(Messages.getString((String)"ImportModelDialog.ReidentifyImportDescription"));
        } else {
            this.dataModel.setReidentify(false);
            this.dataModel.setImportDescription(Messages.getString((String)"ImportModelDialog.ClassicImportDescription"));
        }
        this.dialog.refreshImportDescription();
    }

    private boolean validateOfpxPath() {
        String ofpxPath = this.dialog.getOfpxPath();
        File ofpxFile = new File(ofpxPath);
        if (ofpxPath == null || ofpxPath.equals("")) {
            return false;
        }
        if (!ofpxFile.isFile()) {
            return false;
        }
        return ofpxPath.endsWith(".ofpx");
    }
}

