/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.impexp.model;

import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.analyst.IPropertyValueSet;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITaggedValue;
import com.modeliosoft.modelio.api.ui.ModelioDialog;
import com.modeliosoft.modelio.api.ui.UIColor;
import com.modeliosoft.modelio.app.impexp.model.ImportModelContentProvider;
import com.modeliosoft.modelio.app.impexp.model.ImportModelController;
import com.modeliosoft.modelio.app.impexp.model.ImportModelDataModel;
import com.modeliosoft.modelio.app.impexp.model.ImportModelDialog;
import com.modeliosoft.modelio.app.impexp.model.ImportModelElementAdapter;
import com.modeliosoft.modelio.app.impexp.model.ImportModelLabelProvider;
import com.modeliosoft.modelio.app.impexp.model.ImportRootElementAdapter;
import com.modeliosoft.modelio.app.impexp.ui.Messages;
import com.modeliosoft.modelio.core.model.CompositionServices;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.Bundle;

public class ImportModelDialog
extends ModelioDialog {
    private ImportModelContentProvider contentProvider = null;
    private ImportModelController controller = null;
    private ImportModelDataModel dataModel = null;
    private final IModelingSession destMdaSession;
    protected Button cancelButton = null;
    protected Button classicImportRadio = null;
    protected Button createButton = null;
    protected Text ofpxPathText = null;
    protected Button reidentifyImportRadio = null;
    private Image fileChooserImage = null;
    private Text importDescriptionText = null;
    private Button ofpxPathButton = null;
    private FileDialog ofpxPathChooser = null;
    private Label ofpxPathLabel = null;
    private Label viewerLabel = null;
    private CheckboxTreeViewer viewer = null;

    public ImportModelDialog(Shell parentShell, IModelingSession destSession, ImportModelDataModel dataModel) {
        super(parentShell);
        this.dataModel = dataModel;
        this.destMdaSession = destSession;
    }

    public void addButtonsInButtonBar(Composite parent) {
        this.createButton = this.createButton(parent, 0, Messages.getString((String)"ImportModelDialog.Import"), false);
        this.cancelButton = this.createButton(parent, 1, Messages.getString((String)"ImportModelDialog.Cancel"), true);
    }

    public boolean close() {
        this.removeListener(this.controller);
        return super.close();
    }

    public Control createContentArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayoutData((Object)new GridData(1808));
        GridLayout areaLayout = new GridLayout(3, false);
        area.setLayout((Layout)areaLayout);
        this.createOfpxPathField(area);
        this.createTreeViewer(area);
        this.createReidentifyRadios(area);
        this.controller = new ImportModelController(this.dataModel, this);
        this.addListener(this.controller);
        return area;
    }

    public void init() {
        this.setLogoImage(null);
        this.getShell().setText(Messages.getString((String)"ImportModelDialog.DialogTitle"));
        this.setTitle(Messages.getString((String)"ImportModelDialog.MessageTitle"));
        this.setMessage(Messages.getString((String)"ImportModelDialog.DialogMessage"));
        this.getShell().setSize(450, 500);
        this.getShell().setMinimumSize(450, 450);
    }

    public void invalidateOfpxPath(boolean invalid) {
        if (invalid) {
            this.ofpxPathText.setForeground(this.ofpxPathText.getDisplay().getSystemColor(3));
        } else {
            this.ofpxPathText.setForeground(this.ofpxPathText.getDisplay().getSystemColor(6));
        }
    }

    public void refresh() {
        this.viewer.setInput((Object)this.dataModel.getTreeInput());
    }

    public void refreshImportDescription() {
        this.importDescriptionText.setText(this.dataModel.getImportDescription());
    }

    public void updateButtons(boolean canImport) {
        if (this.createButton != null) {
            this.createButton.setEnabled(canImport);
        }
    }

    String getOfpxPath() {
        return this.ofpxPathText.getText();
    }

    protected TreeItem[] getChildren(Widget o) {
        if (o instanceof TreeItem) {
            return ((TreeItem)o).getItems();
        }
        if (o instanceof Tree) {
            return ((Tree)o).getItems();
        }
        return null;
    }

    protected String getHelpId() {
        return "/com.modeliosoft.modelio.documentation.modeler/html/Modeler-_modeler_managing_projects_importing_elements.html";
    }

    protected void okPressed() {
        List elementsToImport = this.getElementsToImport();
        this.dataModel.setElementsToImport(elementsToImport);
        super.okPressed();
    }

    private void addListener(ImportModelController listener) {
        this.ofpxPathText.addModifyListener((ModifyListener)listener);
        this.classicImportRadio.addSelectionListener((SelectionListener)listener);
        this.reidentifyImportRadio.addSelectionListener((SelectionListener)listener);
    }

    private void collectElementsToImport(List<IElement> result, Widget widget) {
        TreeItem[] treeItemArray = this.getChildren(widget);
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            if (treeItem.getChecked()) {
                Object data = treeItem.getData();
                if (data instanceof ImportModelElementAdapter) {
                    ImportModelElementAdapter adapter = (ImportModelElementAdapter)data;
                    if (adapter.isRoot()) {
                        this.collectHiddenChildren(result, adapter.getElement());
                    } else {
                        result.add(adapter.getElement());
                    }
                } else if (data instanceof ImportRootElementAdapter) {
                    this.collectElementsToImport(result, (Widget)treeItem);
                }
            } else if (!treeItem.getChecked()) {
                this.collectElementsToImport(result, (Widget)treeItem);
            }
            ++n2;
        }
    }

    private void collectHiddenChildren(List<IElement> result, IElement element) {
        List children = CompositionServices.getCompositionChildren((IElement)element);
        for (IElement c : children) {
            if (c instanceof ITaggedValue || c instanceof IPropertyValueSet || c.getElementStatus().isRamcObject()) continue;
            result.add(c);
        }
    }

    private void createOfpxPathField(Composite area) {
        this.ofpxPathLabel = new Label(area, 0);
        this.ofpxPathLabel.setText(Messages.getString((String)"ImportModelDialog.SourceProjectPath"));
        this.ofpxPathText = new Text(area, 2048);
        this.ofpxPathButton = new Button(area, 0);
        this.ofpxPathButton.setImage(this.getFileChooserButtonImage());
        this.ofpxPathChooser = new FileDialog(this.getShell(), 4096);
        this.ofpxPathChooser.setFilterExtensions(new String[]{"*.ofpx"});
        this.ofpxPathChooser.setFilterNames(new String[]{Messages.getString((String)"ImportModelDialog.OfpxFiles")});
        this.ofpxPathButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        GridData gd_ramcPathLabel = new GridData(16384, 128, false, false, 1, 1);
        this.ofpxPathLabel.setLayoutData((Object)gd_ramcPathLabel);
        GridData gd_ramcPathText = new GridData(4, 128, true, false, 1, 1);
        this.ofpxPathText.setLayoutData((Object)gd_ramcPathText);
        GridData gd_ramcPathButton = new GridData(16384, 128, false, false, 1, 1);
        gd_ramcPathButton.heightHint = 21;
        gd_ramcPathButton.widthHint = 21;
        this.ofpxPathButton.setLayoutData((Object)gd_ramcPathButton);
    }

    private void createReidentifyRadios(Composite area) {
        this.classicImportRadio = new Button(area, 16);
        this.classicImportRadio.setText(Messages.getString((String)"ImportModelDialog.ClassicImportRadio"));
        this.reidentifyImportRadio = new Button(area, 16);
        this.reidentifyImportRadio.setText(Messages.getString((String)"ImportModelDialog.ReidentifyImportRadio"));
        this.importDescriptionText = new Text(area, 2112);
        this.importDescriptionText.setEditable(false);
        this.importDescriptionText.setForeground(UIColor.LABEL_TIP_FG);
        this.importDescriptionText.setBackground(UIColor.TEXT_READONLY_BG);
        GridData gd_reidentifyCheckbox = new GridData(16384, 128, true, false, 3, 1);
        this.classicImportRadio.setLayoutData((Object)gd_reidentifyCheckbox);
        GridData gd_reidentifyImportRadio = new GridData(16384, 128, true, false, 3, 1);
        this.reidentifyImportRadio.setLayoutData((Object)gd_reidentifyImportRadio);
        GridData gd_importDescriptionText = new GridData(4, 4, true, false, 3, 1);
        gd_importDescriptionText.heightHint = 30;
        this.importDescriptionText.setLayoutData((Object)gd_importDescriptionText);
    }

    private void createTreeViewer(Composite area) {
        this.viewerLabel = new Label(area, 0);
        this.viewerLabel.setText(Messages.getString((String)"ImportModelDialog.ViewerLabel"));
        this.viewer = new CheckboxTreeViewer(area, 2848);
        this.viewer.setAutoExpandLevel(2);
        this.contentProvider = new ImportModelContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ImportModelLabelProvider(this.destMdaSession));
        this.viewer.setUseHashlookup(true);
        TreeviewerListener hook = new TreeviewerListener(this.viewer);
        this.viewer.addTreeListener((ITreeViewerListener)hook);
        this.viewer.addCheckStateListener((ICheckStateListener)hook);
        GridData gd_viewerLabel = new GridData(16384, 128, true, false, 3, 1);
        this.viewerLabel.setLayoutData((Object)gd_viewerLabel);
        GridData gd_viewer = new GridData(4, 4, true, true, 3, 1);
        this.viewer.getTree().setLayoutData((Object)gd_viewer);
    }

    private List<IElement> getElementsToImport() {
        ArrayList<IElement> result = new ArrayList<IElement>();
        this.collectElementsToImport(result, (Widget)this.viewer.getControl());
        return result;
    }

    private Image getFileChooserButtonImage() {
        Bundle bundle = Platform.getBundle((String)"org.modelio.app.impexp");
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/fileChooser_16.png"), null);
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url);
        this.fileChooserImage = imageDescriptor.createImage();
        return this.fileChooserImage;
    }

    private void removeListener(ImportModelController listener) {
        this.ofpxPathText.addModifyListener((ModifyListener)listener);
        this.classicImportRadio.removeSelectionListener((SelectionListener)listener);
        this.reidentifyImportRadio.removeSelectionListener((SelectionListener)listener);
    }

    static /* synthetic */ FileDialog access$0(ImportModelDialog importModelDialog) {
        return importModelDialog.ofpxPathChooser;
    }
}

