/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.impexp.model;

import com.modeliosoft.modelio.api.model.IAnalystModel;
import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.analyst.IRequirementContainer;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.app.impexp.model.ImportModelElementAdapter;
import com.modeliosoft.modelio.app.impexp.model.ImportRootElementAdapter;
import com.modeliosoft.modelio.core.app.StandardImageService;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

class ImportModelLabelProvider
extends LabelProvider
implements IColorProvider {
    private Image goalImage = null;
    private Image projectImage = null;
    private Image reqImage = null;
    private Image ruleImage = null;

    public ImportModelLabelProvider(IModelingSession session) {
        IAnalystModel requirementModel = session.getRequirementModel();
        IRequirementContainer rootBusinessRuleContainer = requirementModel.getRootBusinessRuleContainer();
        if (rootBusinessRuleContainer != null) {
            this.ruleImage = StandardImageService.getStereotypedImage((IElement)rootBusinessRuleContainer, null);
            this.goalImage = StandardImageService.getStereotypedImage((IElement)requirementModel.getRootGoalContainer(), null);
            this.reqImage = StandardImageService.getStereotypedImage((IElement)requirementModel.getRootRequirementContainer(), null);
        }
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        ImportModelElementAdapter adapter;
        if (element instanceof ImportModelElementAdapter ? (adapter = (ImportModelElementAdapter)element).isRoot() : element instanceof ImportRootElementAdapter) {
            return Display.getDefault().getSystemColor(16);
        }
        return null;
    }

    public Image getImage(Object object) {
        if (object instanceof ImportModelElementAdapter) {
            ImportModelElementAdapter adapter = (ImportModelElementAdapter)object;
            IElement element = adapter.getElement();
            if (element instanceof IRequirementContainer) {
                return this.getAnalystImage((IRequirementContainer)element);
            }
            return StandardImageService.getStereotypedImage((IElement)element, null);
        }
        if (object instanceof ImportRootElementAdapter) {
            if (this.projectImage == null) {
                this.projectImage = StandardImageService.getStereotypedImage((IElement)((ImportRootElementAdapter)object).getUmlProject(), null);
            }
            return this.projectImage;
        }
        return super.getImage(object);
    }

    public String getText(Object object) {
        if (object instanceof ImportModelElementAdapter) {
            ImportModelElementAdapter adapter = (ImportModelElementAdapter)object;
            IElement element = adapter.getElement();
            if (element instanceof IModelElement) {
                IModelElement modelElement = (IModelElement)element;
                return modelElement.getName();
            }
        } else if (object instanceof ImportRootElementAdapter) {
            ImportRootElementAdapter adapter = (ImportRootElementAdapter)object;
            return adapter.getUmlProject().getName();
        }
        return super.getText(object);
    }

    private Image getAnalystImage(IRequirementContainer element) {
        if (this.reqImage == null) {
            return StandardImageService.getStereotypedImage((IElement)element, null);
        }
        if (element.isStereotyped("business_rule_container")) {
            return this.ruleImage;
        }
        if (element.isStereotyped("goal_container")) {
            return this.goalImage;
        }
        if (element.isStereotyped("requirement_container")) {
            return this.reqImage;
        }
        return StandardImageService.getStereotypedImage((IElement)element, null);
    }
}

