/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.impexp.model;

import com.modeliosoft.modelio.api.model.analyst.IDictionaryElement;
import com.modeliosoft.modelio.api.model.analyst.IRequirementContainer;
import com.modeliosoft.modelio.api.model.analyst.IRequirementElement;
import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.diagrams.IDiagramSet;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.app.impexp.model.ImportModelDataModel;
import com.modeliosoft.modelio.app.impexp.ui.Messages;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.BaseImporter;
import com.modeliosoft.modelio.core.model.ModelServices;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;

public class ModelImporter
implements IRunnableWithProgress {
    private ImportModelDataModel dataModel = null;
    private IModelingSession destModelingSession = null;

    public ModelImporter(IModelingSession destModelingSession, ImportModelDataModel dataModel) {
        this.dataModel = dataModel;
        this.destModelingSession = destModelingSession;
    }

    /*
     * Unable to fully structure code
     */
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        umlsToImport = new ArrayList<E>();
        dictionariesToImport = new ArrayList<E>();
        requirementsToImport = new ArrayList<E>();
        goalsToImport = new ArrayList<E>();
        rulesToImport = new ArrayList<E>();
        diagramsToImport = new ArrayList<E>();
        monitor.beginTask(Messages.getString((String)"ImportModelDialog.ImportProgressMessage"), -1);
        this.sortElementsToImport(this.dataModel.getElementsToImport(), umlsToImport, requirementsToImport, goalsToImport, rulesToImport, dictionariesToImport, diagramsToImport);
        project = this.destModelingSession.getModel().getProject();
        if (project == null) {
            return;
        }
        rootPackage = project.getModel();
        rootDiagram = project.getDiagramRoot();
        rootGoal = null;
        rootBusinessRule = null;
        rootRequirement = null;
        rootDictionary = null;
        requirementProject = project.getRootRequirement();
        if (requirementProject != null) {
            rootRequirement = requirementProject.getRequirementRoot();
            rootGoal = requirementProject.getGoalRoot();
            rootBusinessRule = requirementProject.getBusinessRuleRoot();
            rootDictionary = requirementProject.getDictionaryRoot();
        }
        if (this.dataModel.isReidentify()) {
            try {
                if (rootPackage != null && !umlsToImport.isEmpty()) {
                    ModelServices.copyTo(umlsToImport, (IElement)rootPackage);
                }
                if (rootRequirement != null && !requirementsToImport.isEmpty()) {
                    ModelServices.copyTo(requirementsToImport, (IElement)rootRequirement);
                }
                if (rootBusinessRule != null && !rulesToImport.isEmpty()) {
                    ModelServices.copyTo(rulesToImport, (IElement)rootBusinessRule);
                }
                if (rootGoal != null && !goalsToImport.isEmpty()) {
                    ModelServices.copyTo(goalsToImport, (IElement)rootGoal);
                }
                if (rootDictionary != null && !dictionariesToImport.isEmpty()) {
                    ModelServices.copyTo(dictionariesToImport, (IElement)rootDictionary);
                }
                if (rootDiagram == null || diagramsToImport.isEmpty()) ** GOTO lbl78
                ModelServices.copyTo(diagramsToImport, (IElement)rootDiagram);
            }
            catch (InvalidModelManipulationException e) {
                this.displayError((Exception)e);
                e2 = new InterruptedException();
                e2.initCause(e);
                throw e2;
            }
            catch (RuntimeException e) {
                this.displayError((Exception)e);
                throw new InvocationTargetException(e);
            }
        } else {
            try {
                importer = new BaseImporter();
                if (rootPackage != null && !umlsToImport.isEmpty()) {
                    importer.importElements(this.dataModel.getSrcSession().getNativeSession(), this.destModelingSession.getNativeSession(), umlsToImport, (IElement)rootPackage);
                }
                if (rootRequirement != null && !requirementsToImport.isEmpty()) {
                    importer.importElements(this.dataModel.getSrcSession().getNativeSession(), this.destModelingSession.getNativeSession(), requirementsToImport, (IElement)rootRequirement);
                }
                if (rootDictionary != null && !dictionariesToImport.isEmpty()) {
                    importer.importElements(this.dataModel.getSrcSession().getNativeSession(), this.destModelingSession.getNativeSession(), dictionariesToImport, (IElement)rootDictionary);
                }
                if (rootBusinessRule != null && !rulesToImport.isEmpty()) {
                    importer.importElements(this.dataModel.getSrcSession().getNativeSession(), this.destModelingSession.getNativeSession(), rulesToImport, (IElement)rootBusinessRule);
                }
                if (rootGoal != null && !goalsToImport.isEmpty()) {
                    importer.importElements(this.dataModel.getSrcSession().getNativeSession(), this.destModelingSession.getNativeSession(), goalsToImport, (IElement)rootGoal);
                }
                if (rootDiagram != null && !diagramsToImport.isEmpty()) {
                    importer.importElements(this.dataModel.getSrcSession().getNativeSession(), this.destModelingSession.getNativeSession(), diagramsToImport, (IElement)rootDiagram);
                }
            }
            catch (InvalidModelManipulationException e) {
                this.displayError((Exception)e);
                e2 = new InterruptedException();
                e2.initCause(e);
                throw e2;
            }
            catch (RuntimeException e) {
                this.displayError((Exception)e);
                throw new InvocationTargetException(e);
            }
        }
lbl78:
        // 3 sources

        monitor.done();
    }

    private void displayError(Exception e) {
        Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean isAnalystRoot(IRequirementElement c) {
        IRequirementContainer parent = c.getOwner();
        return parent == null;
    }

    private void sortElementToImport(IElement elementToImport, IElement sortKey, List<IElement> umlsToImport, List<IElement> requirementsToImport, List<IElement> goalsToImport, List<IElement> rulesToImport, List<IElement> dictionariesToImport, List<IElement> diagramsToImport) throws IllegalArgumentException {
        if (sortKey instanceof INameSpace) {
            umlsToImport.add(elementToImport);
        } else if (sortKey instanceof IRequirementElement) {
            IRequirementElement reqSortKey = (IRequirementElement)sortKey;
            if (!this.isAnalystRoot(reqSortKey) || reqSortKey != elementToImport) {
                if (reqSortKey.cardExtension() == 0) {
                    requirementsToImport.add(elementToImport);
                } else if (reqSortKey.isStereotyped("business_rule_container")) {
                    rulesToImport.add(elementToImport);
                } else if (reqSortKey.isStereotyped("business_rule")) {
                    rulesToImport.add(elementToImport);
                } else if (reqSortKey.isStereotyped("goal_container")) {
                    goalsToImport.add(elementToImport);
                } else if (reqSortKey.isStereotyped("goal")) {
                    goalsToImport.add(elementToImport);
                } else if (reqSortKey.isStereotyped("requirement_container")) {
                    requirementsToImport.add(elementToImport);
                } else if (reqSortKey.isStereotyped("requirement")) {
                    requirementsToImport.add(elementToImport);
                } else {
                    requirementsToImport.add(elementToImport);
                }
            }
        } else if (sortKey instanceof IDictionaryElement) {
            dictionariesToImport.add(elementToImport);
        } else if (sortKey instanceof IDiagramSet || sortKey instanceof IAbstractDiagram) {
            diagramsToImport.add(elementToImport);
        } else {
            IElement parent = sortKey.getCompositionOwner();
            if (parent == null) {
                throw new IllegalArgumentException(String.valueOf(sortKey.toString()) + " sort key is not handled.");
            }
            this.sortElementToImport(elementToImport, parent, umlsToImport, requirementsToImport, goalsToImport, rulesToImport, dictionariesToImport, diagramsToImport);
        }
    }

    private void sortElementsToImport(List<IElement> elementsToImport, List<IElement> umlsToImport, List<IElement> requirementsToImport, List<IElement> goalsToImport, List<IElement> rulesToImport, List<IElement> dictionariesToImport, List<IElement> diagramsToImport) throws IllegalArgumentException {
        for (IElement elementToImport : elementsToImport) {
            this.sortElementToImport(elementToImport, elementToImport, umlsToImport, requirementsToImport, goalsToImport, rulesToImport, dictionariesToImport, diagramsToImport);
        }
    }
}

