/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.impexp.project;

import com.modeliosoft.modelio.app.impexp.project.CompressWithProgress;
import com.modeliosoft.modelio.app.impexp.ui.Messages;
import com.modeliosoft.modelio.internal.app.IProjectSpace;
import com.modeliosoft.modelio.internal.app.IWorkspace;
import com.modeliosoft.modelio.internal.app.services.App;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class ExportProjectHandler
implements IHandler {
    public void addHandlerListener(IHandlerListener arg0) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IWorkspace workspace = App.getInstance().getWorkspace();
        IProjectSpace projectSpace = workspace.getSelectedProjectSpace();
        if (projectSpace == null) {
            return null;
        }
        if (projectSpace.isOpened()) {
            MessageDialog.openError((Shell)shell, (String)Messages.getMessage((String)"CannotExportOpenedProjectTitle", (String[])new String[]{projectSpace.getName()}), (String)Messages.getMessage((String)"CannotExportOpenedProjectMsg", (String[])new String[]{projectSpace.getName()}));
            return null;
        }
        File archiveFile = this.promptUserForFile(shell, workspace.getDirectory().getAbsolutePath(), projectSpace.getName());
        if (archiveFile != null) {
            IProgressService service = PlatformUI.getWorkbench().getProgressService();
            try {
                service.run(false, false, (IRunnableWithProgress)new CompressWithProgress(archiveFile.getAbsolutePath(), projectSpace.getDataDirectory().getAbsolutePath()));
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean isEnabled() {
        IWorkspace workspace = App.getInstance().getWorkspace();
        List projectSpaces = workspace.getSelectedProjectSpaces();
        int selectedNumber = projectSpaces.size();
        return selectedNumber == 1 && !((IProjectSpace)projectSpaces.get(0)).isOpened();
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener arg0) {
    }

    protected File promptUserForFile(Shell parentShell, String defaultDir, String defaultName) {
        FileDialog dialog = new FileDialog(parentShell, 8192);
        dialog.setFilterNames(new String[]{Messages.getString((String)"ProjectArchive")});
        dialog.setFilterExtensions(new String[]{"*.zip;"});
        dialog.setFileName(String.valueOf(defaultName) + ".zip");
        dialog.setFilterPath(defaultDir);
        String sfilePath = dialog.open();
        if (sfilePath != null) {
            try {
                File file = new File(sfilePath);
                return file.getName().endsWith(".zip") ? file : new File(String.valueOf(file.getAbsolutePath()) + ".zip");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

