/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.impexp.project;

import com.modeliosoft.modelio.app.impexp.project.UncompressWithProgress;
import com.modeliosoft.modelio.app.impexp.ui.Messages;
import com.modeliosoft.modelio.core.zip.Unzipper;
import com.modeliosoft.modelio.internal.app.IProject;
import com.modeliosoft.modelio.internal.app.IWorkspace;
import com.modeliosoft.modelio.internal.app.services.App;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.zip.ZipEntry;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class ImportProjectHandler
implements IHandler {
    public void addHandlerListener(IHandlerListener arg0) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IWorkspace workspace = App.getInstance().getWorkspace();
        File archiveFile = this.promptUserForFile(shell);
        if (archiveFile != null) {
            String archivedProjectName = this.getArchivedProjectName(archiveFile);
            if (archivedProjectName == null) {
                return this.execute(event);
            }
            IProject openedProject = App.getInstance().getOpenedProject();
            if (openedProject != null && archivedProjectName.equals(openedProject.getName())) {
                this.errorOpenedProject(archivedProjectName);
                return null;
            }
            if (workspace.getProjectSpace(archivedProjectName) != null && !this.queryOverwriteExistingProject(shell, archivedProjectName)) {
                return null;
            }
            IProgressService service = PlatformUI.getWorkbench().getProgressService();
            try {
                File folder = workspace.getDirectory();
                folder.mkdirs();
                service.run(false, false, (IRunnableWithProgress)new UncompressWithProgress(archiveFile, folder));
                workspace.refreshProjects();
                return null;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener arg0) {
    }

    protected File promptUserForFile(Shell parentShell) {
        FileDialog dialog = new FileDialog(parentShell, 4096);
        dialog.setFilterNames(new String[]{Messages.getString((String)"ProjectArchive")});
        dialog.setFilterExtensions(new String[]{"*.zip;"});
        String sfilePath = dialog.open();
        if (sfilePath != null) {
            try {
                File file = new File(sfilePath);
                if (file.getName().indexOf(".zip") != -1) {
                    return file;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected String getArchivedProjectName(File archive) {
        try {
            ZipEntry[] ofpx = new Unzipper().findEntry(archive, ".*\\.ofpx");
            if (ofpx.length == 1) {
                File f = new File(ofpx[0].getName());
                return f.getName().substring(0, f.getName().indexOf(46));
            }
            this.errorInvalidArchive(archive.getAbsolutePath());
            return null;
        }
        catch (IOException e1) {
            this.errorInvalidArchive(archive.getAbsolutePath());
            return null;
        }
    }

    protected void errorInvalidArchive(String name) {
        MessageDialog.openInformation(null, (String)Messages.getString((String)"InvalidProjectArchiveTitle"), (String)Messages.getMessage((String)"InvalidProjectArchiveMsg", (String[])new String[]{name}));
    }

    protected boolean queryOverwriteExistingProject(Shell shell, String name) {
        String[] tab = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
        MessageDialog dialog = new MessageDialog(shell, Messages.getString((String)"CannotImportExistingProjectTitle"), null, Messages.getMessage((String)"CannotImportExistingProjectMsg", (String[])new String[]{name}), 3, tab, 0);
        int choice = dialog.open();
        return tab[choice] == IDialogConstants.YES_LABEL;
    }

    protected void errorOpenedProject(String name) {
        MessageDialog.openInformation(null, (String)Messages.getString((String)"CannotImportOpenedProjectTitle"), (String)Messages.getMessage((String)"CannotImportOpenedProjectMsg", (String[])new String[]{name}));
    }
}

