/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.audit.dialog.auditEntry;

import com.modeliosoft.modelio.api.model.uml.behavior.activity.IAcceptCallEventAction;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IAcceptSignalAction;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IActivityEdge;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IActivityNode;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IActivityParameterNode;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IActivityPartition;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.ICallBehaviorAction;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.ICallOperationAction;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IClause;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IInstanceNode;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IObjectNode;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.ISendSignalAction;
import com.modeliosoft.modelio.api.model.uml.behavior.common.IBehavior;
import com.modeliosoft.modelio.api.model.uml.behavior.common.IBehaviorParameter;
import com.modeliosoft.modelio.api.model.uml.behavior.common.ISignal;
import com.modeliosoft.modelio.api.model.uml.behavior.communication.ICommunicationChannel;
import com.modeliosoft.modelio.api.model.uml.behavior.communication.ICommunicationMessage;
import com.modeliosoft.modelio.api.model.uml.behavior.communication.ICommunicationNode;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.ObMessageSortEnum;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IEvent;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IInternalTransition;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IStateVertex;
import com.modeliosoft.modelio.api.model.uml.behavior.state.ITransition;
import com.modeliosoft.modelio.api.model.uml.information.IInformationFlow;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IDependency;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IUsage;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociation;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociationEnd;
import com.modeliosoft.modelio.api.model.uml.statik.IAttribute;
import com.modeliosoft.modelio.api.model.uml.statik.IAttributeLink;
import com.modeliosoft.modelio.api.model.uml.statik.IBindableInstance;
import com.modeliosoft.modelio.api.model.uml.statik.IBinding;
import com.modeliosoft.modelio.api.model.uml.statik.IClass;
import com.modeliosoft.modelio.api.model.uml.statik.IClassAssociation;
import com.modeliosoft.modelio.api.model.uml.statik.IClassifier;
import com.modeliosoft.modelio.api.model.uml.statik.ICollaboration;
import com.modeliosoft.modelio.api.model.uml.statik.ICollaborationUse;
import com.modeliosoft.modelio.api.model.uml.statik.IDataFlow;
import com.modeliosoft.modelio.api.model.uml.statik.IElementImport;
import com.modeliosoft.modelio.api.model.uml.statik.IFeature;
import com.modeliosoft.modelio.api.model.uml.statik.IGeneralClass;
import com.modeliosoft.modelio.api.model.uml.statik.IGeneralization;
import com.modeliosoft.modelio.api.model.uml.statik.IInstance;
import com.modeliosoft.modelio.api.model.uml.statik.IInterface;
import com.modeliosoft.modelio.api.model.uml.statik.IInterfaceRealization;
import com.modeliosoft.modelio.api.model.uml.statik.ILink;
import com.modeliosoft.modelio.api.model.uml.statik.ILinkEnd;
import com.modeliosoft.modelio.api.model.uml.statik.IManifestation;
import com.modeliosoft.modelio.api.model.uml.statik.IModelTree;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.api.model.uml.statik.IPackage;
import com.modeliosoft.modelio.api.model.uml.statik.IPackageImport;
import com.modeliosoft.modelio.api.model.uml.statik.IPackageMerge;
import com.modeliosoft.modelio.api.model.uml.statik.IParameter;
import com.modeliosoft.modelio.api.model.uml.statik.IPort;
import com.modeliosoft.modelio.api.model.uml.statik.IProvidedInterface;
import com.modeliosoft.modelio.api.model.uml.statik.IRaisedException;
import com.modeliosoft.modelio.api.model.uml.statik.IRequiredInterface;
import com.modeliosoft.modelio.api.model.uml.statik.ITemplateBinding;
import com.modeliosoft.modelio.api.model.uml.statik.ITemplateParameter;
import com.modeliosoft.modelio.api.model.uml.statik.ITemplateParameterSubstitution;
import com.modeliosoft.modelio.api.model.uml.statik.ObPassingModeEnum;
import com.modeliosoft.modelio.api.model.uml.statik.ObVisibilityModeEnum;
import com.modeliosoft.modelio.api.model.uml.usecase.IExtensionPoint;
import com.modeliosoft.modelio.api.model.uml.usecase.IUseCase;
import com.modeliosoft.modelio.api.model.uml.usecase.IUseCaseDependency;
import com.modeliosoft.modelio.api.utils.DefaultMetamodelVisitor;
import com.modeliosoft.modelio.api.utils.IMetamodelVisitor;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.audit.plugin.Audit;
import java.util.ArrayList;
import java.util.List;

public class AuditElementLabelService
extends DefaultMetamodelVisitor {
    private String elementLabel = "";

    public String getLabel(IElement element) {
        if (element == null) {
            return "<null>";
        }
        this.elementLabel = "";
        element.accept((IMetamodelVisitor)this);
        return this.elementLabel;
    }

    public Object visitAcceptCallEventAction(IAcceptCallEventAction theAcceptCallEventAction) {
        StringBuffer symbol = new StringBuffer();
        String acceptCallEventActionName = theAcceptCallEventAction.getName();
        IOperation operation = theAcceptCallEventAction.getCalled();
        if (operation != null && (acceptCallEventActionName.equals("Unnamed") || acceptCallEventActionName.equals(""))) {
            symbol.append(operation.getName());
        } else {
            symbol.append(acceptCallEventActionName);
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitAcceptSignalAction(IAcceptSignalAction theAcceptSignalAction) {
        StringBuffer symbol = new StringBuffer();
        String acceptSignalActionName = theAcceptSignalAction.getName();
        ObList signals = theAcceptSignalAction.getAccepted();
        if (signals.size() > 0 && (acceptSignalActionName.equals("Unnamed") || acceptSignalActionName.equals(""))) {
            int i = 0;
            while (i < signals.size()) {
                if (i > 0) {
                    symbol.append(", ");
                }
                symbol.append(((ISignal)signals.get(i)).getName());
                ++i;
            }
        } else {
            symbol.append(acceptSignalActionName);
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitActivityEdge(IActivityEdge theActivityEdge) {
        StringBuffer symbol = new StringBuffer();
        IActivityNode target = theActivityEdge.getTarget();
        if (target != null) {
            AuditElementLabelService labelService = new AuditElementLabelService();
            symbol.append(labelService.getLabel((IElement)target));
        } else {
            String name = theActivityEdge.getName();
            symbol.append(name);
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitActivityParameterNode(IActivityParameterNode theActivityParameterNode) {
        StringBuffer symbol = new StringBuffer();
        IGeneralClass type = theActivityParameterNode.getType();
        IBehaviorParameter behaviorParameter = theActivityParameterNode.getRepresentedRealParameter();
        IParameter theParameter = null;
        if (behaviorParameter != null) {
            theParameter = behaviorParameter.getMapped();
        }
        if (theParameter != null && theParameter.getComposed() != null) {
            ObPassingModeEnum passingMode = theParameter.getParameterPassing();
            symbol.append(theActivityParameterNode.getName());
            symbol.append(" ");
            if (passingMode == ObPassingModeEnum.IN) {
                symbol.append("In");
            }
            if (passingMode == ObPassingModeEnum.OUT) {
                symbol.append("Out");
            }
            if (passingMode == ObPassingModeEnum.INOUT) {
                symbol.append("Inout");
            }
        } else if (theParameter != null && theParameter.getReturned() != null) {
            symbol.append("Out");
        }
        symbol.append(": ");
        if (type != null) {
            symbol.append(type.getName());
        } else {
            symbol.append(Audit.I18N.getString("AuditEntryDialog.NoType"));
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitActivityPartition(IActivityPartition theActivityPartition) {
        StringBuffer symbol = new StringBuffer();
        symbol.append(theActivityPartition.getName());
        IModelElement represented = theActivityPartition.getRepresented();
        if (represented != null) {
            symbol.append(":");
            if (represented instanceof IActivityPartition) {
                symbol.append(represented.getName());
            } else {
                AuditElementLabelService labelService = new AuditElementLabelService();
                symbol.append(labelService.getLabel((IElement)represented));
            }
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitAssociation(IAssociation theAssociation) {
        StringBuffer symbol = new StringBuffer();
        String associationName = theAssociation.getName();
        if (associationName.equals("")) {
            symbol.append(Audit.I18N.getString("AuditEntryDialog.NoName"));
        } else {
            symbol.append(associationName);
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitAssociationEnd(IAssociationEnd theAssociationEnd) {
        StringBuffer symbol = new StringBuffer();
        ObVisibilityModeEnum visibility = theAssociationEnd.getVisibility();
        if (visibility == ObVisibilityModeEnum.PUBLIC) {
            symbol.append("+");
        } else if (visibility == ObVisibilityModeEnum.PROTECTED) {
            symbol.append("#");
        } else if (visibility == ObVisibilityModeEnum.PRIVATE) {
            symbol.append("-");
        } else if (visibility == ObVisibilityModeEnum.PACKAGE_VISIBILITY) {
            symbol.append("~");
        }
        String associationEndName = theAssociationEnd.getName();
        if (associationEndName.equals("")) {
            symbol.append(Audit.I18N.getString("AuditEntryDialog.NoName"));
        } else {
            symbol.append(theAssociationEnd.getName());
        }
        symbol.append(": ");
        List relatedAssociationEnds = this.getRelatedAssociationEnds(theAssociationEnd);
        IAssociationEnd end = null;
        IClassifier ownerClassifier = null;
        int relatedClassesNumber = relatedAssociationEnds.size();
        boolean first = true;
        int i = 0;
        while (i < relatedClassesNumber) {
            end = (IAssociationEnd)relatedAssociationEnds.get(i);
            ownerClassifier = end.getOwner();
            if (ownerClassifier != null) {
                if (!first) {
                    symbol.append(", ");
                } else {
                    first = false;
                }
                symbol.append(ownerClassifier.getName());
            }
            ++i;
        }
        if (first) {
            symbol.append(Audit.I18N.getString("AuditEntryDialog.NoType"));
        }
        symbol.append(this.getAssociationEndMultiplicity(theAssociationEnd));
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitAttribute(IAttribute theAttribute) {
        StringBuffer symbol = new StringBuffer();
        ObVisibilityModeEnum visibility = theAttribute.getVisibility();
        if (visibility == ObVisibilityModeEnum.PUBLIC) {
            symbol.append("+");
        } else if (visibility == ObVisibilityModeEnum.PROTECTED) {
            symbol.append("#");
        } else if (visibility == ObVisibilityModeEnum.PRIVATE) {
            symbol.append("-");
        } else if (visibility == ObVisibilityModeEnum.PACKAGE_VISIBILITY) {
            symbol.append("~");
        }
        symbol.append(theAttribute.getName());
        IGeneralClass type = theAttribute.getType();
        symbol.append(" : ");
        if (type != null) {
            symbol.append(type.getName());
        } else {
            symbol.append(Audit.I18N.getString("AuditEntryDialog.NoType"));
        }
        symbol.append(this.getAttributeMultiplicity(theAttribute));
        String value = theAttribute.getValue();
        if (value != null && !value.equals("")) {
            symbol.append(" = ");
            symbol.append(value);
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitAttributeLink(IAttributeLink theAttributeLink) {
        StringBuffer symbol = new StringBuffer();
        IAttribute base = theAttributeLink.getBase();
        if (base != null) {
            symbol.append(base.getName());
        } else {
            symbol.append(theAttributeLink.getName());
        }
        String value = theAttributeLink.getValue();
        if (!value.equals("")) {
            symbol.append(" = ");
            symbol.append(value);
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitBehaviorParameter(IBehaviorParameter theBehaviorParameter) {
        IParameter theParameter = theBehaviorParameter.getMapped();
        StringBuffer symbol = new StringBuffer();
        ObPassingModeEnum passingMode = theBehaviorParameter.getParameterPassing();
        IGeneralClass type = theBehaviorParameter.getType();
        if (theParameter != null && theParameter.getComposed() != null) {
            symbol.append(theBehaviorParameter.getName());
            symbol.append(" ");
            if (passingMode == ObPassingModeEnum.IN) {
                symbol.append("In");
            }
            if (passingMode == ObPassingModeEnum.OUT) {
                symbol.append("Out");
            }
            if (passingMode == ObPassingModeEnum.INOUT) {
                symbol.append("Inout");
            }
        } else if (theParameter != null && theParameter.getReturned() != null) {
            symbol.append("Out");
        }
        symbol.append(": ");
        if (type != null) {
            symbol.append(type.getName());
        } else {
            symbol.append(Audit.I18N.getString("AuditEntryDialog.NoType"));
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitBinding(IBinding theBinding) {
        StringBuffer symbol = new StringBuffer();
        IBindableInstance role = theBinding.getRole();
        IModelElement feature = theBinding.getRepresentedFeature();
        AuditElementLabelService labelService = new AuditElementLabelService();
        if (role != null) {
            symbol.append(labelService.getLabel((IElement)role));
        }
        symbol.append(" --> ");
        if (feature != null) {
            symbol.append(labelService.getLabel((IElement)feature));
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitCallBehaviorAction(ICallBehaviorAction theCallBehaviorAction) {
        StringBuffer symbol = new StringBuffer();
        String callBehaviorActionName = theCallBehaviorAction.getName();
        IBehavior behavior = theCallBehaviorAction.getCalled();
        if (behavior != null && (callBehaviorActionName.equals("Unnamed") || callBehaviorActionName.equals(""))) {
            symbol.append(behavior.getName());
        } else {
            symbol.append(callBehaviorActionName);
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitCallOperationAction(ICallOperationAction theCallOperationAction) {
        StringBuffer symbol = new StringBuffer();
        String callOperationActionName = theCallOperationAction.getName();
        IOperation operation = theCallOperationAction.getCalled();
        if (operation != null && (callOperationActionName.equals("Unnamed") || callOperationActionName.equals(""))) {
            symbol.append(operation.getName());
        } else {
            symbol.append(callOperationActionName);
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitClassAssociation(IClassAssociation theClassAssociation) {
        StringBuffer symbol = new StringBuffer();
        IClass theClass = theClassAssociation.getClassPart();
        if (theClass != null) {
            symbol.append(theClass.getName());
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitClause(IClause theClause) {
        StringBuffer symbol = new StringBuffer();
        symbol.append("[");
        String test = theClause.getTest();
        if (test.length() == 0) {
            symbol.append("Conditional clause");
        } else {
            symbol.append(test);
        }
        symbol.append("]");
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitCollaborationUse(ICollaborationUse theCollaborationUse) {
        StringBuffer symbol = new StringBuffer();
        symbol.append(theCollaborationUse.getName());
        ICollaboration base = theCollaborationUse.getType();
        symbol.append(": ");
        if (base != null) {
            symbol.append(base.getName());
        } else {
            symbol.append(Audit.I18N.getString("AuditEntryDialog.NoBase"));
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitCommunicationChannel(ICommunicationChannel theCommunicationChannel) {
        StringBuffer symbol = new StringBuffer();
        ILink channel = theCommunicationChannel.getChannel();
        if (channel != null) {
            AuditElementLabelService labelService = new AuditElementLabelService();
            symbol.append(labelService.getLabel((IElement)channel));
        } else {
            symbol.append(theCommunicationChannel.getName());
        }
        ICommunicationNode dest = theCommunicationChannel.getEnd();
        if (dest != null) {
            symbol.append(" : ");
            symbol.append(dest.getName());
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitCommunicationMessage(ICommunicationMessage theCommunicationMessage) {
        StringBuffer symbol = new StringBuffer();
        String name = theCommunicationMessage.getName();
        ObMessageSortEnum messageSort = theCommunicationMessage.getSortOfMessage();
        if (name.equals("")) {
            symbol.append(Audit.I18N.getString(messageSort.name()));
        } else {
            symbol.append(name);
        }
        if (messageSort != ObMessageSortEnum.SYNC_CALL && messageSort != ObMessageSortEnum.CREATE_MESSAGE) {
            symbol.append("(");
            symbol.append(theCommunicationMessage.getArgument());
            symbol.append(")");
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitCommunicationNode(ICommunicationNode theCommunicationNode) {
        StringBuffer symbol = new StringBuffer();
        IInstance instance = theCommunicationNode.getRepresented();
        if (instance != null) {
            AuditElementLabelService labelService = new AuditElementLabelService();
            symbol.append(labelService.getLabel((IElement)instance));
        } else {
            symbol.append(theCommunicationNode.getName());
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitDataFlow(IDataFlow theDataFlow) {
        StringBuffer symbol = new StringBuffer();
        ISignal signal = theDataFlow.getSModel();
        if (signal != null) {
            symbol.append(signal.getName());
        } else {
            symbol.append(theDataFlow.getName());
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitDependency(IDependency theDependency) {
        StringBuffer symbol = new StringBuffer();
        IModelElement destination = theDependency.getDependsOn();
        if (destination != null) {
            symbol.append("Dependency ");
            symbol.append(destination.getName());
            IModelTree owner = null;
            if (destination instanceof IModelTree) {
                owner = ((IModelTree)destination).getOwner();
            }
            if (owner != null) {
                symbol.append(" (from ");
                symbol.append(owner.getName());
                symbol.append(")");
            }
        } else {
            symbol.append("<No destination>");
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitElement(IElement theElement) {
        this.elementLabel = theElement.getClass().getSimpleName();
        return null;
    }

    public Object visitElementImport(IElementImport theElementImport) {
        StringBuffer symbol = new StringBuffer();
        INameSpace importedNamespace = theElementImport.getImportedElement();
        if (importedNamespace != null) {
            symbol.append("access ");
            symbol.append(importedNamespace.getName());
            IModelTree owner = importedNamespace.getOwner();
            if (owner != null) {
                symbol.append(" (from ");
                symbol.append(owner.getName());
                symbol.append(")");
            }
        } else {
            symbol.append("<No destination>");
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitEvent(IEvent theEvent) {
        StringBuffer symbol = new StringBuffer();
        IOperation operation = theEvent.getCalled();
        ISignal signal = theEvent.getModel();
        if (operation != null) {
            symbol.append(operation.getName());
        } else if (signal != null) {
            symbol.append(signal.getName());
        } else if (theEvent.getName().equals("")) {
            symbol.append(theEvent.getExpression());
        } else {
            symbol.append(theEvent.getName());
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitExtensionPoint(IExtensionPoint theExtensionPoint) {
        StringBuffer symbol = new StringBuffer();
        ObVisibilityModeEnum visibility = theExtensionPoint.getVisibility();
        if (visibility == ObVisibilityModeEnum.PUBLIC) {
            symbol.append("+");
        } else if (visibility == ObVisibilityModeEnum.PROTECTED) {
            symbol.append("#");
        } else if (visibility == ObVisibilityModeEnum.PRIVATE) {
            symbol.append("-");
        } else if (visibility == ObVisibilityModeEnum.PACKAGE_VISIBILITY) {
            symbol.append("~");
        }
        symbol.append(theExtensionPoint.getName());
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitFeature(IFeature theFeature) {
        StringBuffer symbol = new StringBuffer();
        ObVisibilityModeEnum visibility = theFeature.getVisibility();
        if (visibility == ObVisibilityModeEnum.PUBLIC) {
            symbol.append("+");
        } else if (visibility == ObVisibilityModeEnum.PROTECTED) {
            symbol.append("#");
        } else if (visibility == ObVisibilityModeEnum.PRIVATE) {
            symbol.append("-");
        } else if (visibility == ObVisibilityModeEnum.PACKAGE_VISIBILITY) {
            symbol.append("~");
        }
        symbol.append(theFeature.getName());
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitGeneralization(IGeneralization theGeneralization) {
        StringBuffer symbol = new StringBuffer();
        symbol.append("is_a ");
        AuditElementLabelService labelService = new AuditElementLabelService();
        INameSpace parent = theGeneralization.getSuperType();
        if (parent != null) {
            symbol.append(labelService.getLabel((IElement)parent));
            IModelTree owner = parent.getOwner();
            if (owner != null) {
                symbol.append(" (from ");
                symbol.append(owner.getName());
                symbol.append(")");
            }
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitInformationFlow(IInformationFlow theInformationFlow) {
        StringBuffer symbol = new StringBuffer();
        ObList classifiers = theInformationFlow.getConveyed();
        if (classifiers.size() > 0) {
            int i = 0;
            while (i < classifiers.size()) {
                if (i > 0) {
                    symbol.append(", ");
                }
                symbol.append(((IClassifier)classifiers.get(i)).getName());
                ++i;
            }
        } else {
            symbol.append(theInformationFlow.getName());
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitInstance(IInstance theInstance) {
        StringBuffer symbol = new StringBuffer();
        symbol.append(theInstance.getName());
        INameSpace base = theInstance.getBase();
        symbol.append(": ");
        if (base != null) {
            symbol.append(base.getName());
        } else {
            symbol.append(Audit.I18N.getString("AuditEntryDialog.NoBase"));
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitInstanceNode(IInstanceNode theInstanceNode) {
        StringBuffer symbol = new StringBuffer();
        IInstance instance = theInstanceNode.getRepresented();
        IAttribute attribut = theInstanceNode.getRepresentedAttribute();
        IAssociationEnd assocEnd = theInstanceNode.getRepresentedRole();
        IBehaviorParameter behaviorParameter = theInstanceNode.getRepresentedRealParameter();
        IGeneralClass type = theInstanceNode.getType();
        if (type != null) {
            symbol.append(theInstanceNode.getName());
            symbol.append(": ");
            symbol.append(type.getName());
        } else if (instance != null) {
            AuditElementLabelService labelService = new AuditElementLabelService();
            symbol.append(labelService.getLabel((IElement)instance));
        } else if (attribut != null) {
            AuditElementLabelService labelService = new AuditElementLabelService();
            symbol.append(labelService.getLabel((IElement)attribut));
        } else if (assocEnd != null) {
            AuditElementLabelService labelService = new AuditElementLabelService();
            symbol.append(labelService.getLabel((IElement)assocEnd));
        } else if (behaviorParameter != null) {
            AuditElementLabelService labelService = new AuditElementLabelService();
            symbol.append(labelService.getLabel((IElement)behaviorParameter));
        } else {
            symbol.append(theInstanceNode.getName());
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitInterfaceRealization(IInterfaceRealization theInterfaceRealization) {
        StringBuffer symbol = new StringBuffer();
        AuditElementLabelService labelService = new AuditElementLabelService();
        IInterface implemented = theInterfaceRealization.getImplemented();
        if (implemented != null) {
            symbol.append(labelService.getLabel((IElement)implemented));
            IModelTree owner = implemented.getOwner();
            if (owner != null) {
                symbol.append(" (from ");
                symbol.append(owner.getName());
                symbol.append(")");
            }
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitInternalTransition(IInternalTransition theInternalTransition) {
        super.visitInternalTransition(theInternalTransition);
        if (this.elementLabel.equals("")) {
            this.elementLabel = "/";
        }
        return null;
    }

    public Object visitLink(ILink theLink) {
        StringBuffer symbol = new StringBuffer();
        IAssociation association = theLink.getBase();
        if (association != null) {
            AuditElementLabelService labelService = new AuditElementLabelService();
            symbol.append(labelService.getLabel((IElement)association));
        } else {
            String linkName = theLink.getName();
            if (linkName.equals("")) {
                symbol.append(Audit.I18N.getString("AuditEntryDialog.NoName"));
            } else {
                symbol.append(linkName);
            }
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitLinkEnd(ILinkEnd theLinkEnd) {
        StringBuffer symbol = new StringBuffer();
        List relatedLinkEnds = this.getRelatedLinkEnds(theLinkEnd);
        String linkEndName = theLinkEnd.getName();
        if (relatedLinkEnds.size() == 0) {
            if (linkEndName.equals("")) {
                symbol.append(Audit.I18N.getString("AuditEntryDialog.NoName"));
            } else {
                symbol.append(linkEndName);
            }
        } else if (relatedLinkEnds.size() == 1) {
            if (linkEndName.equals("")) {
                symbol.append(Audit.I18N.getString("AuditEntryDialog.NoName"));
            } else {
                symbol.append(linkEndName);
            }
            IInstance linked = ((ILinkEnd)relatedLinkEnds.get(0)).getLinked();
            if (linked != null) {
                symbol.append("::");
                symbol.append(linked.getName());
            }
        } else {
            int i = 0;
            while (i < relatedLinkEnds.size()) {
                String endName;
                ILinkEnd end = (ILinkEnd)relatedLinkEnds.get(i);
                if (i > 0) {
                    symbol.append(", ");
                }
                if ((endName = end.getName()).equals("")) {
                    symbol.append(Audit.I18N.getString("AuditEntryDialog.NoName"));
                } else {
                    symbol.append(endName);
                }
                IInstance linked = end.getLinked();
                if (linked != null) {
                    symbol.append("::");
                    String linkedName = linked.getName();
                    if (linkedName.equals("")) {
                        symbol.append(Audit.I18N.getString("AuditEntryDialog.NoName"));
                    } else {
                        symbol.append(linkedName);
                    }
                }
                ++i;
            }
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitManifestation(IManifestation theManifestation) {
        StringBuffer symbol = new StringBuffer();
        IModelElement destination = theManifestation.getUtilizedElement();
        if (destination != null) {
            symbol.append("manifested ");
            symbol.append(destination.getName());
            IModelTree owner = null;
            if (destination instanceof IModelTree) {
                owner = ((IModelTree)destination).getOwner();
            }
            if (owner != null) {
                symbol.append(" (from ");
                symbol.append(owner.getName());
                symbol.append(")");
            }
        } else {
            symbol.append("<No destination>");
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitModelElement(IModelElement theModelElement) {
        this.elementLabel = theModelElement.getName();
        return null;
    }

    public Object visitObjectNode(IObjectNode theObjectNode) {
        StringBuffer symbol = new StringBuffer();
        IBehaviorParameter parameter = theObjectNode.getRepresentedRealParameter();
        IInstance instance = theObjectNode.getRepresented();
        IAttribute attribute = theObjectNode.getRepresentedAttribute();
        IAssociationEnd role = theObjectNode.getRepresentedRole();
        AuditElementLabelService labelService = new AuditElementLabelService();
        if (parameter != null) {
            symbol.append(labelService.getLabel((IElement)parameter));
        } else if (instance != null) {
            symbol.append(labelService.getLabel((IElement)instance));
        } else if (attribute != null) {
            symbol.append(labelService.getLabel((IElement)attribute));
        } else if (role != null) {
            symbol.append(labelService.getLabel((IElement)role));
        } else {
            IGeneralClass type = theObjectNode.getType();
            symbol.append(theObjectNode.getName());
            String upperbound = theObjectNode.getUpperBound();
            if (upperbound.length() > 0 && !upperbound.equals("1")) {
                symbol.append("[");
                symbol.append(upperbound);
                symbol.append("]");
            }
            if (type != null) {
                symbol.append(" : ");
                symbol.append(type.getName());
            }
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitOperation(IOperation theOperation) {
        StringBuffer symbol = new StringBuffer();
        ObVisibilityModeEnum visibility = theOperation.getVisibility();
        if (visibility == ObVisibilityModeEnum.PUBLIC) {
            symbol.append("+");
        } else if (visibility == ObVisibilityModeEnum.PROTECTED) {
            symbol.append("#");
        } else if (visibility == ObVisibilityModeEnum.PRIVATE) {
            symbol.append("-");
        } else if (visibility == ObVisibilityModeEnum.PACKAGE_VISIBILITY) {
            symbol.append("~");
        }
        symbol.append(theOperation.getName());
        symbol.append("(");
        ObList parameters = theOperation.getIO();
        int parameterNumber = parameters.size();
        int i = 0;
        while (i < parameterNumber) {
            symbol.append(this.getParameterSymbol((IParameter)parameters.get(i)));
            if (i < parameterNumber - 1) {
                symbol.append(", ");
            }
            ++i;
        }
        symbol.append(")");
        IParameter returnParameter = theOperation.getReturn();
        if (returnParameter != null) {
            IGeneralClass type = returnParameter.getType();
            symbol.append(":");
            symbol.append(" ");
            if (type != null) {
                symbol.append(type.getName());
            } else {
                symbol.append(Audit.I18N.getString("AuditEntryDialog.NoType"));
            }
            symbol.append(this.getParameterMultiplicity(returnParameter));
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitPackageImport(IPackageImport thePackageImport) {
        StringBuffer symbol = new StringBuffer();
        IPackage importedNamespace = thePackageImport.getImportedPackage();
        if (importedNamespace != null) {
            symbol.append("access all ");
            symbol.append(importedNamespace.getName());
            IModelTree owner = importedNamespace.getOwner();
            if (owner != null) {
                symbol.append(" (from ");
                symbol.append(owner.getName());
                symbol.append(")");
            }
        } else {
            symbol.append("<No destination>");
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitPackageMerge(IPackageMerge thePackageMerge) {
        StringBuffer symbol = new StringBuffer();
        IPackage mergedPackage = thePackageMerge.getMergedPackage();
        if (mergedPackage != null) {
            symbol.append("merge ");
            symbol.append(mergedPackage.getName());
            IModelTree owner = mergedPackage.getOwner();
            if (owner != null) {
                symbol.append(" (from ");
                symbol.append(owner.getName());
                symbol.append(")");
            }
        } else {
            symbol.append("<No destination>");
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitParameter(IParameter theParameter) {
        this.elementLabel = this.getParameterSymbol(theParameter).toString();
        return null;
    }

    public Object visitPort(IPort thePort) {
        StringBuffer symbol = new StringBuffer();
        symbol.append(thePort.getName());
        INameSpace type = this.getType(thePort);
        if (type != null) {
            symbol.append(" : ");
            symbol.append(type.getName());
        }
        if (symbol.length() == 0) {
            ObList providedInterfaces;
            ObList requiredInterfaces = thePort.getRequired();
            if (requiredInterfaces.size() > 0) {
                symbol.append("R = ");
                int i = 0;
                while (i < requiredInterfaces.size()) {
                    if (i > 0) {
                        symbol.append(", ");
                    }
                    AuditElementLabelService labelService = new AuditElementLabelService();
                    symbol.append(labelService.getLabel((IElement)requiredInterfaces.get(i)));
                    ++i;
                }
            }
            if ((providedInterfaces = thePort.getProvided()).size() > 0) {
                if (requiredInterfaces.size() > 0) {
                    symbol.append(", ");
                }
                symbol.append("P = ");
                int i = 0;
                while (i < providedInterfaces.size()) {
                    if (i > 0) {
                        symbol.append(", ");
                    }
                    AuditElementLabelService labelService = new AuditElementLabelService();
                    symbol.append(labelService.getLabel((IElement)providedInterfaces.get(i)));
                    ++i;
                }
            }
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitProvidedInterface(IProvidedInterface theProvidedInterface) {
        StringBuffer symbol = new StringBuffer();
        ObList providedElements = theProvidedInterface.getProvidedElement();
        if (providedElements.size() > 0) {
            int i = 0;
            while (i < providedElements.size()) {
                if (i > 0) {
                    symbol.append(", ");
                }
                AuditElementLabelService labelService = new AuditElementLabelService();
                symbol.append(labelService.getLabel((IElement)providedElements.get(i)));
                ++i;
            }
        } else {
            symbol.append("none");
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitRaisedException(IRaisedException theRaisedException) {
        StringBuffer symbol = new StringBuffer();
        symbol.append("throws ");
        AuditElementLabelService labelService = new AuditElementLabelService();
        IClassifier thrownType = theRaisedException.getThrownType();
        if (thrownType != null) {
            symbol.append(labelService.getLabel((IElement)thrownType));
            IModelTree owner = thrownType.getOwner();
            if (owner != null) {
                symbol.append(" (from ");
                symbol.append(owner.getName());
                symbol.append(")");
            }
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitRequiredInterface(IRequiredInterface theRequiredInterface) {
        StringBuffer symbol = new StringBuffer();
        ObList requiredElements = theRequiredInterface.getRequiredElement();
        if (requiredElements.size() > 0) {
            int i = 0;
            while (i < requiredElements.size()) {
                if (i > 0) {
                    symbol.append(", ");
                }
                AuditElementLabelService labelService = new AuditElementLabelService();
                symbol.append(labelService.getLabel((IElement)requiredElements.get(i)));
                ++i;
            }
        } else {
            symbol.append("none");
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitSendSignalAction(ISendSignalAction theSendSignalAction) {
        StringBuffer symbol = new StringBuffer();
        String sendSignalActionName = theSendSignalAction.getName();
        ISignal signal = theSendSignalAction.getSent();
        if (signal != null && (sendSignalActionName.equals("Unnamed") || sendSignalActionName.equals(""))) {
            symbol.append(signal.getName());
        } else {
            symbol.append(sendSignalActionName);
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitTemplateBinding(ITemplateBinding theTemplateBinding) {
        StringBuffer symbol = new StringBuffer();
        INameSpace namespace = theTemplateBinding.getInstanciatedTemplate();
        if (namespace != null) {
            symbol.append(namespace.getName());
        } else {
            IOperation operation = theTemplateBinding.getInstanciatedTemplateOperation();
            if (operation != null) {
                symbol.append(operation.getName());
            }
        }
        symbol.append("<");
        ObList substitutions = theTemplateBinding.getParameterSubstitution();
        int i = 0;
        while (i < substitutions.size()) {
            if (i != 0) {
                symbol.append(", ");
            }
            AuditElementLabelService labelService = new AuditElementLabelService();
            symbol.append(labelService.getLabel((IElement)substitutions.get(i)));
            ++i;
        }
        symbol.append(">");
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitTemplateParameter(ITemplateParameter theTemplateParameter) {
        StringBuffer symbol = new StringBuffer();
        symbol.append(theTemplateParameter.getName());
        IModelElement type = theTemplateParameter.getType();
        if (type != null) {
            if (theTemplateParameter.isValueParameter()) {
                symbol.append(":");
                AuditElementLabelService labelService = new AuditElementLabelService();
                symbol.append(labelService.getLabel((IElement)type));
                symbol.append(" expression");
            } else {
                boolean isConstrained = false;
                if (type instanceof INameSpace) {
                    INameSpace nsType = (INameSpace)type;
                    boolean bl = isConstrained = nsType.getSpecialization().size() > 0;
                }
                if (isConstrained) {
                    symbol.append(" > ");
                    AuditElementLabelService labelService = new AuditElementLabelService();
                    symbol.append(labelService.getLabel((IElement)type));
                } else if (type.getClass() != IClass.class || type.getExtension().size() != 0) {
                    symbol.append(" : ");
                    symbol.append(type.getMetaclassName());
                }
            }
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitTemplateParameterSubstitution(ITemplateParameterSubstitution theTemplateParameterSubstitution) {
        String value;
        StringBuffer symbol = new StringBuffer();
        AuditElementLabelService labelService = new AuditElementLabelService();
        ITemplateParameter templateParameter = theTemplateParameterSubstitution.getFormalParameter();
        if (templateParameter != null) {
            symbol.append(labelService.getLabel((IElement)templateParameter));
        }
        if (!(value = theTemplateParameterSubstitution.getValue()).equals("")) {
            symbol.append(" = ");
            symbol.append(value);
        } else {
            IModelElement actual = theTemplateParameterSubstitution.getActual();
            if (actual != null) {
                if (actual.equals((Object)theTemplateParameterSubstitution.getOwner())) {
                    symbol.append(actual.getName());
                } else {
                    symbol.append(labelService.getLabel((IElement)actual));
                }
            }
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitTransition(ITransition theTransition) {
        IOperation operation;
        StringBuffer symbol = new StringBuffer();
        IStateVertex targetVertex = theTransition.getTarget();
        IEvent trigger = theTransition.getTrigger();
        if (trigger != null) {
            symbol.append(trigger.getName());
        } else {
            symbol.append(theTransition.getReceivedEvents());
        }
        String condition = theTransition.getGuard();
        if (condition != null && !condition.equals("")) {
            symbol.append("[");
            symbol.append(condition);
            symbol.append("]");
        }
        if ((operation = theTransition.getProcessed()) != null) {
            symbol.append("/");
            symbol.append(operation.getName());
            symbol.append("()");
        } else {
            String effect = theTransition.getEffect();
            if (effect.length() > 0) {
                symbol.append("/");
                symbol.append(effect);
            }
        }
        ISignal effects = theTransition.getEffects();
        if (effects != null) {
            symbol.append("^");
            symbol.append(effects.getName());
            symbol.append("()");
        } else {
            String sentEvents = theTransition.getSentEvents();
            if (sentEvents.length() > 0) {
                symbol.append("^");
                symbol.append(sentEvents);
            }
        }
        String postCondition = theTransition.getPostCondition();
        if (postCondition != null && !postCondition.equals("")) {
            symbol.append("{");
            symbol.append(postCondition);
            symbol.append("}");
        }
        if (symbol.length() == 0) {
            symbol.append(theTransition.getName());
            if (targetVertex != null) {
                symbol.append("::");
                symbol.append(targetVertex.getName());
            }
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public Object visitUsage(IUsage theUsage) {
        StringBuffer symbol = new StringBuffer();
        IModelElement destination = theUsage.getDependsOn();
        if (destination != null) {
            symbol.append("usage ");
            symbol.append(destination.getName());
            IModelTree owner = null;
            if (destination instanceof IModelTree) {
                owner = ((IModelTree)destination).getOwner();
            }
            if (owner != null) {
                symbol.append(" (from ");
                symbol.append(owner.getName());
                symbol.append(")");
            }
        } else {
            symbol.append("<No destination>");
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    private StringBuffer getAssociationEndMultiplicity(IAssociationEnd theAssociationEnd) {
        StringBuffer multiplicity = new StringBuffer();
        String multiplicityMinStr = theAssociationEnd.getMultiplicityMin();
        String multiplicityMaxStr = theAssociationEnd.getMultiplicityMax();
        String separator = "";
        if (!multiplicityMinStr.equals("") || !multiplicityMaxStr.equals("")) {
            multiplicity.append(" [");
            if (multiplicityMinStr.equals(multiplicityMaxStr)) {
                multiplicity.append(multiplicityMinStr);
            } else if (multiplicityMinStr.equals("0") && multiplicityMaxStr.equals("*")) {
                multiplicity.append("*");
            } else {
                if (!multiplicityMinStr.equals("") && !multiplicityMaxStr.equals("")) {
                    separator = "..";
                }
                multiplicity.append(multiplicityMinStr);
                multiplicity.append(separator);
                multiplicity.append(multiplicityMaxStr);
            }
            multiplicity.append("]");
        }
        return multiplicity;
    }

    private StringBuffer getAttributeMultiplicity(IAttribute theAttribute) {
        StringBuffer multiplicity = new StringBuffer();
        String multiplicityMinStr = theAttribute.getMultiplicityMin();
        String multiplicityMaxStr = theAttribute.getMultiplicityMax();
        String separator = "";
        if (multiplicityMinStr.equals("1") && multiplicityMaxStr.equals("1")) {
            return multiplicity;
        }
        if (!multiplicityMinStr.equals("") || !multiplicityMaxStr.equals("")) {
            multiplicity.append(" [");
            if (multiplicityMinStr.equals(multiplicityMaxStr)) {
                multiplicity.append(multiplicityMinStr);
            } else if (multiplicityMinStr.equals("0") && multiplicityMaxStr.equals("*")) {
                multiplicity.append("*");
            } else {
                if (!multiplicityMinStr.equals("") && !multiplicityMaxStr.equals("")) {
                    separator = "..";
                }
                multiplicity.append(multiplicityMinStr);
                multiplicity.append(separator);
                multiplicity.append(multiplicityMaxStr);
            }
            multiplicity.append("]");
        }
        return multiplicity;
    }

    private StringBuffer getParameterMultiplicity(IParameter theParameter) {
        StringBuffer multiplicity = new StringBuffer();
        String multiplicityMinStr = theParameter.getMultiplicityMin();
        String multiplicityMaxStr = theParameter.getMultiplicityMax();
        String separator = "";
        if (multiplicityMinStr.equals("1") && multiplicityMaxStr.equals("1")) {
            return multiplicity;
        }
        if (!multiplicityMinStr.equals("") || !multiplicityMaxStr.equals("")) {
            multiplicity.append(" [");
            if (multiplicityMinStr.equals(multiplicityMaxStr)) {
                multiplicity.append(multiplicityMinStr);
            } else if (multiplicityMinStr.equals("0") && multiplicityMaxStr.equals("*")) {
                multiplicity.append("*");
            } else {
                if (!multiplicityMinStr.equals("") && !multiplicityMaxStr.equals("")) {
                    separator = "..";
                }
                multiplicity.append(multiplicityMinStr);
                multiplicity.append(separator);
                multiplicity.append(multiplicityMaxStr);
            }
            multiplicity.append("]");
        }
        return multiplicity;
    }

    private StringBuffer getParameterSymbol(IParameter theParameter) {
        StringBuffer symbol = new StringBuffer();
        ObPassingModeEnum passingMode = theParameter.getParameterPassing();
        IGeneralClass type = theParameter.getType();
        if (theParameter.getReturned() != null) {
            symbol.append("out");
            symbol.append(" : ");
            if (type != null) {
                symbol.append(type.getName());
            } else {
                symbol.append(Audit.I18N.getString("AuditEntryDialog.NoType"));
            }
            symbol.append(this.getParameterMultiplicity(theParameter));
        } else if (theParameter.getComposed() != null) {
            symbol.append(theParameter.getName());
            symbol.append(" ");
            if (passingMode == ObPassingModeEnum.IN) {
                symbol.append("in");
            }
            if (passingMode == ObPassingModeEnum.OUT) {
                symbol.append("out");
            }
            if (passingMode == ObPassingModeEnum.INOUT) {
                symbol.append("inout");
            }
            symbol.append(" : ");
            if (type != null) {
                symbol.append(type.getName());
            } else {
                symbol.append(Audit.I18N.getString("AuditEntryDialog.NoType"));
            }
            symbol.append(this.getParameterMultiplicity(theParameter));
        }
        return symbol;
    }

    private List<IAssociationEnd> getRelatedAssociationEnds(IAssociationEnd theAssociationEnd) {
        ArrayList<IAssociationEnd> relatedAssociationEndsList = new ArrayList<IAssociationEnd>();
        IAssociation assoc = theAssociationEnd.getRelated();
        if (assoc != null) {
            ObList ends = assoc.getConnection();
            for (IAssociationEnd end : ends) {
                if (theAssociationEnd.equals((Object)end)) continue;
                relatedAssociationEndsList.add(end);
            }
        }
        return relatedAssociationEndsList;
    }

    private List<ILinkEnd> getRelatedLinkEnds(ILinkEnd theLinkEnd) {
        ArrayList<ILinkEnd> relatedLinkEndsList = new ArrayList<ILinkEnd>();
        ILink link = theLinkEnd.getLinkNode();
        ObList ends = link.getConnection();
        for (ILinkEnd end : ends) {
            if (theLinkEnd.equals((Object)end)) continue;
            relatedLinkEndsList.add(end);
        }
        return relatedLinkEndsList;
    }

    private INameSpace getType(IPort thePort) {
        IModelElement represented = thePort.getRepresentedFeature();
        if (represented == null) {
            return thePort.getBase();
        }
        if (this.hasTypeCycles(thePort)) {
            return null;
        }
        if (represented instanceof IAttribute) {
            return ((IAttribute)represented).getType();
        }
        if (represented instanceof IAssociationEnd) {
            List ends = this.getRelatedAssociationEnds((IAssociationEnd)represented);
            if (ends.size() == 1) {
                return ((IAssociationEnd)ends.get(0)).getOwner();
            }
            return null;
        }
        if (represented instanceof IInstance) {
            return ((IInstance)represented).getBase();
        }
        if (represented instanceof IParameter) {
            return ((IParameter)represented).getType();
        }
        return null;
    }

    private boolean hasTypeCycles(IPort thePort) {
        IPort currentInstance = thePort;
        boolean hasCycle = false;
        while (currentInstance != null && !hasCycle) {
            IModelElement currentRepresented = currentInstance.getRepresentedFeature();
            if (currentRepresented != null && currentRepresented instanceof IBindableInstance) {
                currentInstance = (IBindableInstance)currentRepresented;
                if (!thePort.equals((Object)currentInstance)) continue;
                hasCycle = true;
                continue;
            }
            currentInstance = null;
        }
        return hasCycle;
    }

    public Object visitUseCaseDependency(IUseCaseDependency theUseCaseDependency) {
        IUseCase target;
        StringBuffer symbol = new StringBuffer();
        ObList stereotypes = theUseCaseDependency.getExtension();
        if (stereotypes.size() > 0) {
            symbol.append("<<");
            symbol.append(((IStereotype)stereotypes.get(0)).getName());
            symbol.append(">>");
        }
        if ((target = theUseCaseDependency.getTarget()) != null) {
            symbol.append(target.getName());
        }
        this.elementLabel = symbol.toString();
        return null;
    }

    public String getElementLabel() {
        return this.elementLabel;
    }
}

