/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.audit.dialog.auditEntry;

import com.modeliosoft.modelio.api.ui.ModelioDialog;
import com.modeliosoft.modelio.audit.dialog.auditEntry.LinkedElementContentProvider;
import com.modeliosoft.modelio.audit.dialog.auditEntry.LinkedElementLabelProvider;
import com.modeliosoft.modelio.audit.engine.core.IAuditEntry;
import com.modeliosoft.modelio.audit.plugin.Audit;
import com.modeliosoft.modelio.audit.view.model.DiagnosticFormatter;
import com.modeliosoft.modelio.core.IModelingSession;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.osgi.framework.Bundle;

public class AuditEntryDialog
extends ModelioDialog {
    private IAuditEntry entry = null;
    private IModelingSession modelingSession = null;
    private static String HELP_BASE_URL = "com.modeliosoft.modelio.documentation.modeler/html/";
    private URL ruleUrl;
    private Composite area = null;
    private Image selectImage;
    private Browser browser;

    public AuditEntryDialog(Shell parentShell, IAuditEntry entry, IModelingSession modelingSession) {
        super(parentShell);
        this.entry = entry;
        this.modelingSession = modelingSession;
    }

    public void addButtonsInButtonBar(Composite parent) {
        this.createButton(parent, 0, Audit.I18N.getString("AuditEntryDialog.Close"), true);
    }

    public Control createContentArea(Composite parent) {
        Bundle bundle = Platform.getBundle((String)"org.modelio.audit");
        URL bitmapUrl = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/select.png"), null);
        this.selectImage = ImageDescriptor.createFromURL((URL)bitmapUrl).createImage();
        parent.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.area = new Composite(parent, 0);
        this.area.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(1, false);
        this.area.setLayout((Layout)layout);
        Group descriptionGroup = this.createEntryDescription(this.entry);
        GridData layoutData = new GridData(4, 4, true, false);
        descriptionGroup.setLayoutData((Object)layoutData);
        Group linkedElementsGroup = this.createLinkedElementsList();
        layoutData = new GridData(4, 4, true, false);
        linkedElementsGroup.setLayoutData((Object)layoutData);
        Group ruleDocumentationGroup = this.createRuleDocumentation(this.entry.getRuleId());
        layoutData = new GridData(4, 4, true, true);
        ruleDocumentationGroup.setLayoutData((Object)layoutData);
        return this.area;
    }

    public void init() {
        this.setLogoImage(null);
        this.getShell().setText(Audit.I18N.getString("AuditEntryDialog.DialogTitle"));
        this.setTitle(Audit.I18N.getString("AuditEntryDialog.DialogTitle"));
        this.getShell().setSize(600, 700);
        this.getShell().setMinimumSize(600, 550);
    }

    private Group createRuleDocumentation(String ruleId) {
        Group group = new Group(this.area, 0);
        group.setText(ruleId);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        group.setLayout((Layout)gl);
        this.browser = new Browser((Composite)group, 2048);
        GridData gd = new GridData(4, 4, true, true);
        this.browser.setLayoutData((Object)gd);
        this.browser.setMenu(new Menu((Control)this.browser));
        this.browser.setJavascriptEnabled(false);
        this.browser.addLocationListener((LocationListener)new /* Unavailable Anonymous Inner Class!! */);
        IWorkbenchHelpSystem h = PlatformUI.getWorkbench().getHelpSystem();
        this.ruleUrl = h.resolve(String.valueOf(HELP_BASE_URL) + "Modeler_audit_rules_" + ruleId + ".html", true);
        this.browser.setUrl(this.ruleUrl.toString());
        return group;
    }

    private Group createEntryDescription(IAuditEntry entryToDescribe) {
        Group descriptionGroup = new Group(this.area, 0);
        descriptionGroup.setText(Audit.I18N.getString("AuditEntryDialog.DescriptionGroup.Label"));
        GridLayout layout = new GridLayout(2, false);
        descriptionGroup.setLayout((Layout)layout);
        Label auditMessage = new Label((Composite)descriptionGroup, 72);
        String message = DiagnosticFormatter.getMessage((IAuditEntry)entryToDescribe);
        auditMessage.setText(message);
        auditMessage.setCapture(false);
        Button navigationButton = new Button((Composite)descriptionGroup, 0);
        navigationButton.setImage(this.selectImage);
        navigationButton.setToolTipText(Audit.I18N.getString("AuditEntryDialog.ElementLabel.ClickToNavigate"));
        navigationButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        GridData layoutData = new GridData(4, 4, true, true);
        auditMessage.setLayoutData((Object)layoutData);
        layoutData = new GridData(4, 4, false, true);
        navigationButton.setLayoutData((Object)layoutData);
        return descriptionGroup;
    }

    private Group createLinkedElementsList() {
        Group group = new Group(this.area, 0);
        group.setText(Audit.I18N.getString("AuditEntryDialog.LinkedElements.Label"));
        group.setLayout((Layout)new GridLayout(1, false));
        TableViewer linkedElementsList = new TableViewer((Composite)group, 2048);
        linkedElementsList.setContentProvider((IContentProvider)new LinkedElementContentProvider());
        linkedElementsList.setLabelProvider((IBaseLabelProvider)new LinkedElementLabelProvider(this.modelingSession));
        linkedElementsList.setInput((Object)this.entry);
        linkedElementsList.getControl().setToolTipText("Double-click an element to select it in the explorer");
        GridData gd_linkedElementsList = new GridData(4, 4, true, true);
        linkedElementsList.getTable().setLayoutData((Object)gd_linkedElementsList);
        linkedElementsList.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        return group;
    }

    static /* synthetic */ Image access$0(AuditEntryDialog auditEntryDialog) {
        return auditEntryDialog.selectImage;
    }

    static /* synthetic */ Browser access$1(AuditEntryDialog auditEntryDialog) {
        return auditEntryDialog.browser;
    }

    static /* synthetic */ URL access$2(AuditEntryDialog auditEntryDialog) {
        return auditEntryDialog.ruleUrl;
    }
}

