/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.audit.engine;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.audit.engine.AuditRunningMode;
import com.modeliosoft.modelio.audit.engine.core.AuditRunnerStatus;
import com.modeliosoft.modelio.audit.engine.core.IAuditListener;
import com.modeliosoft.modelio.audit.engine.core.IAuditMonitor;
import com.modeliosoft.modelio.audit.engine.core.IRule;
import com.modeliosoft.modelio.audit.engine.impl.AuditDiagnostic;
import com.modeliosoft.modelio.audit.engine.impl.AuditDispatcher;
import com.modeliosoft.modelio.audit.engine.impl.AuditPlan;
import com.modeliosoft.modelio.audit.engine.impl.AuditRunner;
import com.modeliosoft.modelio.audit.engine.impl.CheckProgram;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.model.change.IModelChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class AuditEngine {
    private AuditRunner auditRunner = null;
    private CheckProgram controlProgram = null;
    private AuditDispatcher auditDispatcher = null;
    private AuditPlan activePlan = null;
    private Thread auditThread;
    public AuditDiagnostic auditDiagnostic = null;
    private AuditRunningMode runningMode = AuditRunningMode.AUTO;
    private static /* synthetic */ int[] $SWITCH_TABLE$com$modeliosoft$modelio$audit$engine$AuditRunningMode;

    public AuditEngine() {
        this.controlProgram = new CheckProgram();
        this.auditDiagnostic = new AuditDiagnostic();
        this.auditRunner = new AuditRunner(this.controlProgram, this.auditDiagnostic);
        this.auditDispatcher = new AuditDispatcher(this.controlProgram);
    }

    public void setPlan(AuditPlan plan) {
        this.pause();
        this.activePlan = plan;
        this.auditDispatcher.setPlan(this.activePlan);
        HashSet allRules = new HashSet();
        for (ArrayList ruleList : plan.getRules(1).values()) {
            allRules.addAll(ruleList);
        }
        for (ArrayList ruleList : plan.getRules(8).values()) {
            allRules.addAll(ruleList);
        }
        for (ArrayList ruleList : plan.getRules(2).values()) {
            allRules.addAll(ruleList);
        }
        HashMap<String, IRule> rules = new HashMap<String, IRule>();
        for (IRule rule : allRules) {
            rules.put(rule.getRuleId(), rule);
        }
        this.auditDiagnostic.auditPlanChanged(rules);
        this.resume();
    }

    public void start(IModelingSession session) {
        session.getModel().addModelListener((IModelChangeListener)this.auditDispatcher);
        this.auditThread = new Thread((Runnable)this.auditRunner);
        this.auditThread.setPriority(1);
        this.auditThread.setName("AUDIT");
        this.auditThread.start();
        this.setRunningMode(AuditRunningMode.AUTO);
        this.resume();
    }

    public void stop(IModelingSession session) {
        this.pause();
        session.getModel().removeModelListener((IModelChangeListener)this.auditDispatcher);
        this.auditRunner.terminate();
        this.auditDiagnostic.clear();
    }

    /*
     * Exception decompiling
     */
    public void setRunningMode(AuditRunningMode mode) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void pause() {
        this.auditDispatcher.stop();
        this.auditRunner.stop();
    }

    /*
     * Exception decompiling
     */
    public void resume() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void checkElement(IElement elementToCheck) {
        this.auditDispatcher.submitElement(elementToCheck);
    }

    public AuditDiagnostic getAuditDiagnostic() {
        return this.auditDiagnostic;
    }

    public AuditRunningMode getRunningMode() {
        return this.runningMode;
    }

    public AuditRunnerStatus getRunningStatus() {
        return this.auditRunner.status;
    }

    public synchronized void addAuditListener(IAuditListener listener) {
        this.auditDiagnostic.addAuditListener(listener);
    }

    public synchronized void removeAuditListener(IAuditListener listener) {
        this.auditDiagnostic.removeAuditListener(listener);
    }

    public synchronized void addAuditMonitor(IAuditMonitor monitor) {
        this.auditRunner.auditMonitors.add(monitor);
    }

    public synchronized void removeAuditMonitor(IAuditMonitor monitor) {
        this.auditRunner.auditMonitors.remove(monitor);
    }

    private void switchToAuto() {
        this.auditRunner.start();
        this.auditDispatcher.start();
    }

    private void switchToManual() {
        this.auditRunner.start();
        this.auditDispatcher.stop();
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$modeliosoft$modelio$audit$engine$AuditRunningMode() {
        if ($SWITCH_TABLE$com$modeliosoft$modelio$audit$engine$AuditRunningMode != null) {
            return $SWITCH_TABLE$com$modeliosoft$modelio$audit$engine$AuditRunningMode;
        }
        int[] nArray = new int[AuditRunningMode.values().length];
        try {
            nArray[AuditRunningMode.AUTO.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[AuditRunningMode.MANUEL.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$modeliosoft$modelio$audit$engine$AuditRunningMode = nArray;
        return nArray;
    }
}

