/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.audit.engine.handlers;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.audit.plugin.Audit;
import com.modeliosoft.modelio.core.model.CompositionServices;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;

public class CheckElementHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        HashSet setOfElements = new HashSet();
        for (IElement e : this.getSelectedElements()) {
            if (e.getElementStatus().isRamcObject()) continue;
            setOfElements.addAll(this.getComposedElement(e));
        }
        for (IElement e : setOfElements) {
            if (e.getElementStatus().isRamcObject()) continue;
            Audit.getInstance().auditEngine.checkElement(e);
        }
        return null;
    }

    private List<IElement> getSelectedElements() {
        ArrayList<IElement> selectedElements = new ArrayList<IElement>();
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            List selectedObjects = ((IStructuredSelection)selection).toList();
            for (Object selectedObject : selectedObjects) {
                IElement e;
                if (!(selectedObject instanceof IAdaptable) || (e = (IElement)((IAdaptable)selectedObject).getAdapter(IElement.class)) == null) continue;
                selectedElements.add(e);
            }
        }
        return selectedElements;
    }

    private List<IElement> getComposedElement(IElement e) {
        return CompositionServices.getAllCompositionChildren((IElement)e);
    }
}

