/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.audit.engine.impl;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.audit.engine.core.IAuditDiagnostic;
import com.modeliosoft.modelio.audit.engine.core.IAuditEntry;
import com.modeliosoft.modelio.audit.engine.core.IAuditListener;
import com.modeliosoft.modelio.audit.engine.core.IRule;
import com.modeliosoft.modelio.audit.engine.impl.AuditEntry;
import com.modeliosoft.modelio.core.audit.AuditSeverity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AuditDiagnostic
implements IAuditDiagnostic {
    private List<IAuditEntry> entries;
    private List<IAuditListener> auditListeners = new ArrayList();
    private int nErrors = 0;
    private int nWarnings = 0;
    private int nTips = 0;
    private static /* synthetic */ int[] $SWITCH_TABLE$com$modeliosoft$modelio$core$audit$AuditSeverity;

    public AuditDiagnostic() {
        this.entries = new ArrayList();
    }

    public List<IAuditEntry> getEntries() {
        return this.entries;
    }

    private IAuditEntry getDiagnosticEntry(List<IAuditEntry> diagnosticEntries, IAuditEntry searchedEntry) {
        int index = diagnosticEntries.indexOf(searchedEntry);
        if (index >= 0) {
            return diagnosticEntries.get(index);
        }
        return null;
    }

    public synchronized boolean postDiagnostic(List<IAuditEntry> diagnosticEntries) {
        boolean notifyListeners = false;
        int i = this.entries.size() - 1;
        while (i >= 0) {
            IAuditEntry entry = (IAuditEntry)this.entries.get(i);
            IElement element = entry.getElement();
            if (element == null || !element.isValid()) {
                this.doRemoveEntry(i);
                notifyListeners = true;
            } else if (diagnosticEntries.contains(entry)) {
                IAuditEntry diagnosticEntry = this.getDiagnosticEntry(diagnosticEntries, entry);
                diagnosticEntries.remove(diagnosticEntry);
                if (diagnosticEntry.getSeverity() == AuditSeverity.AuditSuccess) {
                    this.doRemoveEntry(i);
                } else {
                    this.doReplaceEntry(diagnosticEntry, i);
                }
                notifyListeners = true;
            }
            --i;
        }
        for (IAuditEntry diagnosticEntry : diagnosticEntries) {
            if (diagnosticEntry.getSeverity() == AuditSeverity.AuditSuccess) continue;
            this.doAddEntry(diagnosticEntry);
            notifyListeners = true;
        }
        if (notifyListeners) {
            this.fireAuditModelChanged();
        }
        return notifyListeners;
    }

    public void addAuditListener(IAuditListener listener) {
        this.auditListeners.add(listener);
    }

    public void removeAuditListener(IAuditListener listener) {
        this.auditListeners.remove(listener);
    }

    public int getErrorCount() {
        return this.nErrors;
    }

    public int getWarningCount() {
        return this.nWarnings;
    }

    public int getTipCount() {
        return this.nTips;
    }

    /*
     * Exception decompiling
     */
    private void doAddEntry(IAuditEntry entry) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void doReplaceEntry(IAuditEntry entry, int index) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void doRemoveEntry(int index) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized void auditPlanChanged(Map<String, IRule> configuredRules) {
        boolean notifyListeners = false;
        int i = this.entries.size() - 1;
        while (i >= 0) {
            AuditEntry entry = (AuditEntry)this.entries.get(i);
            if (!configuredRules.containsKey(entry.getRuleId())) {
                this.doRemoveEntry(i);
                notifyListeners = true;
            } else if (entry.getSeverity() != configuredRules.get(entry.getRuleId()).getSeverity()) {
                entry.setSeverity(configuredRules.get(entry.getRuleId()).getSeverity());
                notifyListeners = true;
            }
            --i;
        }
        if (notifyListeners) {
            this.fireAuditModelChanged();
        }
    }

    protected void fireAuditModelChanged() {
        for (IAuditListener listener : this.auditListeners) {
            listener.auditModelChanged((IAuditDiagnostic)this);
        }
    }

    public void clear() {
        this.nErrors = 0;
        this.nWarnings = 0;
        this.nTips = 0;
        this.entries.clear();
        this.fireAuditModelChanged();
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$modeliosoft$modelio$core$audit$AuditSeverity() {
        if ($SWITCH_TABLE$com$modeliosoft$modelio$core$audit$AuditSeverity != null) {
            return $SWITCH_TABLE$com$modeliosoft$modelio$core$audit$AuditSeverity;
        }
        int[] nArray = new int[AuditSeverity.values().length];
        try {
            nArray[AuditSeverity.AuditAdvice.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[AuditSeverity.AuditBlock.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[AuditSeverity.AuditError.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[AuditSeverity.AuditFatal.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[AuditSeverity.AuditInfo.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[AuditSeverity.AuditSuccess.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[AuditSeverity.AuditWarning.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$modeliosoft$modelio$core$audit$AuditSeverity = nArray;
        return nArray;
    }
}

