/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.audit.engine.impl;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.audit.engine.core.IRule;
import com.modeliosoft.modelio.audit.engine.impl.AuditPlan;
import com.modeliosoft.modelio.audit.engine.impl.CheckProgram;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.model.change.IElementDeletedEvent;
import com.modeliosoft.modelio.core.model.change.IElementMovedEvent;
import com.modeliosoft.modelio.core.model.change.IModelChangeEvent;
import com.modeliosoft.modelio.core.model.change.IModelChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AuditDispatcher
implements IModelChangeListener {
    public AuditPlan plan = null;
    public CheckProgram controlProgram = null;
    private boolean active;

    public void modelChanged(IModelingSession session, IModelChangeEvent event) {
        if (!this.active) {
            return;
        }
        for (IElement createdElement : event.getCreationEvents()) {
            for (IRule rule : this.getRules(createdElement, 1)) {
                this.controlProgram.postControl(rule.getCreationControl(createdElement), createdElement);
            }
        }
        Object object = event.getDeleteEvents();
        int rule = ((IElementDeletedEvent[])object).length;
        int n = 0;
        while (n < rule) {
            Object deletedEvent = object[n];
            IElement oldParent = deletedEvent.getOldParent();
            if (oldParent.isValid()) {
                for (IRule rule2 : this.getRules(oldParent, 2)) {
                    this.controlProgram.postControl(rule2.getUpdateControl(oldParent), oldParent);
                }
                for (IRule rule2 : this.getRules(deletedEvent.getDeletedElement(), 4)) {
                    this.controlProgram.postControl(rule2.getDeleteControl(oldParent), oldParent);
                }
            }
            ++n;
        }
        for (IElement updatedElement : event.getUpdateEvents()) {
            for (IRule rule3 : this.getRules(updatedElement, 2)) {
                this.controlProgram.postControl(rule3.getUpdateControl(updatedElement), updatedElement);
            }
        }
        object = event.getMoveEvents();
        int n2 = ((IElementMovedEvent[])object).length;
        int n3 = 0;
        while (n3 < n2) {
            Object moveEvent = object[n3];
            for (IRule rule4 : this.getRules(moveEvent.getMovedElement(), 8)) {
                this.controlProgram.postControl(rule4.getMoveControl((IElementMovedEvent)moveEvent), moveEvent.getMovedElement());
            }
            for (IRule rule4 : this.getRules(moveEvent.getOldParent(), 2)) {
                this.controlProgram.postControl(rule4.getUpdateControl(moveEvent.getOldParent()), moveEvent.getOldParent());
            }
            ++n3;
        }
    }

    public AuditDispatcher(CheckProgram controlProgram) {
        this.controlProgram = controlProgram;
        this.plan = new AuditPlan();
    }

    public synchronized void start() {
        this.active = true;
    }

    public synchronized void stop() {
        this.active = false;
    }

    public synchronized void setPlan(AuditPlan activePlan) {
        this.stop();
        this.plan = activePlan;
        this.start();
    }

    public void submitElement(IElement elementToCheck) {
        if (elementToCheck.getElementStatus().isRamcObject()) {
            return;
        }
        for (IRule rule : this.plan.getRules(elementToCheck.getMetaclassName(), 1)) {
            this.controlProgram.postControl(rule.getCreationControl(elementToCheck), elementToCheck);
        }
        for (IRule rule : this.plan.getRules(elementToCheck.getMetaclassName(), 2)) {
            this.controlProgram.postControl(rule.getUpdateControl(elementToCheck), elementToCheck);
        }
    }

    private List<IRule> getRules(IElement element, int trigger) {
        ArrayList<IRule> returnedRules = new ArrayList<IRule>();
        if (element.isValid()) {
            if (element.getElementStatus().isRamcObject()) {
                return Collections.emptyList();
            }
            if (element instanceof IModelElement) {
                if (element.getElementStatus().isRamcObject()) {
                    return Collections.emptyList();
                }
                IModelElement elt = (IModelElement)element;
                for (IStereotype stereotype : elt.getExtension()) {
                    returnedRules.addAll(this.plan.getRules(String.valueOf(elt.getMetaclassName()) + stereotype.getName(), trigger));
                }
            }
        }
        if (returnedRules.isEmpty()) {
            return this.plan.getRules(element.getMetaclassName(), trigger);
        }
        return returnedRules;
    }
}

