/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.audit.engine.impl;

import com.modeliosoft.modelio.audit.engine.core.IAuditPlan;
import com.modeliosoft.modelio.audit.engine.core.IRule;
import com.modeliosoft.modelio.audit.engine.impl.AuditTrigger;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;

public class AuditPlan
implements IAuditPlan {
    private Map<String, ArrayList<IRule>> createRules = new HashMap();
    private Map<String, ArrayList<IRule>> updateRules = new HashMap();
    private Map<String, ArrayList<IRule>> moveRules = new HashMap();
    private Map<String, ArrayList<IRule>> deleteRules = new HashMap();

    public void registerRule(String metaclass, IRule rule, int triggers) {
        if (AuditTrigger.isCreate((int)triggers)) {
            if (this.createRules.get(metaclass) == null) {
                this.createRules.put(metaclass, new ArrayList());
            }
            ((ArrayList)this.createRules.get(metaclass)).add(rule);
        }
        if (AuditTrigger.isUpdate((int)triggers)) {
            if (this.updateRules.get(metaclass) == null) {
                this.updateRules.put(metaclass, new ArrayList());
            }
            ((ArrayList)this.updateRules.get(metaclass)).add(rule);
        }
        if (AuditTrigger.isMove((int)triggers)) {
            if (this.moveRules.get(metaclass) == null) {
                this.moveRules.put(metaclass, new ArrayList());
            }
            ((ArrayList)this.moveRules.get(metaclass)).add(rule);
        }
        if (AuditTrigger.isDelete((int)triggers)) {
            if (this.deleteRules.get(metaclass) == null) {
                this.deleteRules.put(metaclass, new ArrayList());
            }
            ((ArrayList)this.deleteRules.get(metaclass)).add(rule);
        }
    }

    public List<IRule> getRules(String metaclass, int trigger) {
        List results = null;
        if (AuditTrigger.isCreate((int)trigger)) {
            results = (List)this.createRules.get(metaclass);
        } else if (AuditTrigger.isUpdate((int)trigger)) {
            results = (List)this.updateRules.get(metaclass);
        } else if (AuditTrigger.isMove((int)trigger)) {
            results = (List)this.moveRules.get(metaclass);
        } else if (AuditTrigger.isDelete((int)trigger)) {
            results = (List)this.deleteRules.get(metaclass);
        }
        if (results != null) {
            return results;
        }
        return Collections.emptyList();
    }

    public Map<String, ArrayList<IRule>> getRules(int trigger) {
        Map results = null;
        if (AuditTrigger.isCreate((int)trigger)) {
            results = this.createRules;
        } else if (AuditTrigger.isUpdate((int)trigger)) {
            results = this.updateRules;
        } else if (AuditTrigger.isMove((int)trigger)) {
            results = this.moveRules;
        } else if (AuditTrigger.isDelete((int)trigger)) {
            results = this.deleteRules;
        }
        if (results != null) {
            return results;
        }
        return Collections.emptyMap();
    }

    public void dump(PrintStream out) {
        out.println("-- AUDIT PLAN Composition --");
        out.println("ON CREATE");
        for (Map.Entry entry : this.getRules(1).entrySet()) {
            out.print(" - " + (String)entry.getKey() + " = ");
            for (IRule rule : (ArrayList)entry.getValue()) {
                out.print(String.valueOf(rule.getRuleId()) + " ");
            }
            out.println();
        }
        out.println("ON UPDATE");
        for (Map.Entry entry : this.getRules(2).entrySet()) {
            out.print(" - " + (String)entry.getKey() + " = ");
            for (IRule rule : (ArrayList)entry.getValue()) {
                out.print(String.valueOf(rule.getRuleId()) + " ");
            }
            out.println();
        }
        out.println("ON MOVE");
        for (Map.Entry entry : this.getRules(8).entrySet()) {
            out.print(" - " + (String)entry.getKey() + " = ");
            for (IRule rule : (ArrayList)entry.getValue()) {
                out.print(String.valueOf(rule.getRuleId()) + " ");
            }
            out.println();
        }
        out.println("-- --");
    }

    public void dump(IPath iPath) {
        try {
            PrintStream fout = new PrintStream(new FileOutputStream(iPath.toFile()));
            this.dump(fout);
            fout.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

