/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.audit.plugin;

import com.modeliosoft.modelio.audit.dialog.CoreAuditListener;
import com.modeliosoft.modelio.audit.engine.AuditEngine;
import com.modeliosoft.modelio.audit.engine.impl.AuditPlan;
import com.modeliosoft.modelio.audit.preferences.AuditConfigurator;
import com.modeliosoft.modelio.audit.view.AuditView;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.audit.ICoreAuditListener;
import com.modeliosoft.modelio.core.log.PluginLogger;
import com.modeliosoft.modelio.internal.app.IProject;
import com.modeliosoft.modelio.ui.i18n.BundledMessages;
import java.io.File;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class Audit {
    public static final String PLUGIN_ID = "org.modelio.audit";
    private static final Audit INSTANCE = new Audit();
    public static PluginLogger LOG = new PluginLogger("org.modelio.audit");
    public static BundledMessages I18N = new BundledMessages("org.modelio.audit", ResourceBundle.getBundle("audit"));
    private IModelingSession modelingSession = null;
    public AuditEngine auditEngine = new AuditEngine();
    private CoreAuditListener coreAuditListener;

    public void projectOpened(IProject project) {
        this.modelingSession = project.getSession();
        this.coreAuditListener = new CoreAuditListener();
        this.modelingSession.getAudit().addAuditDiagnosticListener((ICoreAuditListener)this.coreAuditListener);
        File configFile = this.getLocalConfigFileDescriptor();
        if (!configFile.exists()) {
            this.installFactorySettings();
        }
        this.initAuditEngine(this.modelingSession);
    }

    public void sessionOpened(IModelingSession session) {
    }

    public void sessionClosed(IModelingSession session) {
        this.auditEngine.stop(session);
        this.modelingSession.getAudit().removeAuditDiagnosticListener((ICoreAuditListener)this.coreAuditListener);
        this.coreAuditListener = null;
        this.modelingSession = null;
    }

    public void restart() {
        if (this.modelingSession == null) {
            return;
        }
        File configFile = this.getLocalConfigFileDescriptor();
        AuditConfigurator auditConfigurator = new AuditConfigurator(configFile);
        AuditPlan auditPlan = auditConfigurator.createPlan();
        auditPlan.dump(Platform.getLogFileLocation());
        this.auditEngine.setPlan(auditPlan);
    }

    public static Audit getInstance() {
        return INSTANCE;
    }

    public IModelingSession getModelingSession() {
        return this.modelingSession;
    }

    public File getLocalConfigFileDescriptor() {
        assert (this.modelingSession != null);
        return new File(this.modelingSession.getProjectSpacePath().getPath(), "/.config/auditconfiguration.xml");
    }

    private void initAuditEngine(IModelingSession session) {
        File configFile = this.getLocalConfigFileDescriptor();
        AuditConfigurator auditConfigurator = new AuditConfigurator(configFile);
        AuditPlan auditPlan = auditConfigurator.createPlan();
        this.auditEngine.setPlan(auditPlan);
        this.auditEngine.start(session);
    }

    private void installFactorySettings() {
        File configFile = this.getLocalConfigFileDescriptor();
        AuditConfigurator configurator = new AuditConfigurator(null);
        configurator.saveAs(configFile);
    }

    private AuditView getAuditView() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        return (AuditView)page.findViewReference("com.modeliosoft.modelio.audit.AuditViewID").getView(false);
    }
}

