/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.audit.preferences;

import com.modeliosoft.modelio.audit.engine.core.IAuditPlan;
import com.modeliosoft.modelio.audit.engine.core.IRule;
import com.modeliosoft.modelio.audit.engine.impl.AuditPlan;
import com.modeliosoft.modelio.audit.preferences.config.ActivationStatus;
import com.modeliosoft.modelio.audit.preferences.config.Configuration;
import com.modeliosoft.modelio.audit.preferences.config.Rule;
import com.modeliosoft.modelio.audit.preferences.config.RuleGroup;
import com.modeliosoft.modelio.audit.preferences.config.Severity;
import com.modeliosoft.modelio.audit.preferences.model.PrefModel;
import com.modeliosoft.modelio.audit.preferences.model.RulePref;
import com.modeliosoft.modelio.core.audit.AuditSeverity;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class AuditConfigurator {
    private File configFile;
    private static /* synthetic */ int[] $SWITCH_TABLE$com$modeliosoft$modelio$audit$preferences$config$Severity;
    private static /* synthetic */ int[] $SWITCH_TABLE$com$modeliosoft$modelio$audit$preferences$config$ActivationStatus;
    private static /* synthetic */ int[] $SWITCH_TABLE$com$modeliosoft$modelio$core$audit$AuditSeverity;

    public AuditConfigurator(File configFile) {
        this.configFile = configFile;
    }

    private Configuration readConfig() {
        Configuration config = null;
        InputStream is = null;
        try {
            is = this.configFile != null ? new FileInputStream(this.configFile) : this.openFactorySettings();
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Configuration.class});
            Unmarshaller u = jc.createUnmarshaller();
            Configuration configuration = config = (Configuration)u.unmarshal(is);
            return configuration;
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public AuditPlan createPlan() {
        Configuration config = this.readConfig();
        AuditPlan auditPlan = new AuditPlan();
        for (RuleGroup ruleGroup : config.getRuleGroup()) {
            for (Rule ruleEntry : ruleGroup.getRule()) {
                if (ruleEntry.getStatus() != ActivationStatus.ENABLED) continue;
                String className = ruleEntry.getDriver().getClazz();
                try {
                    Class<?> ruleClass = Class.forName(className);
                    if (!IRule.class.isAssignableFrom(ruleClass)) continue;
                    IRule rule = (IRule)ruleClass.newInstance();
                    rule.setSeverity(this.convertConfigSeverityToAuditSeverity(ruleEntry.getSeverity()));
                    rule.autoRegister((IAuditPlan)auditPlan);
                }
                catch (ClassNotFoundException ruleClass) {
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        return auditPlan;
    }

    /*
     * Exception decompiling
     */
    private AuditSeverity convertConfigSeverityToAuditSeverity(Severity configSeverity) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public PrefModel createPrefModel() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void apply(PrefModel prefModel) {
        Configuration config = this.readConfig();
        int nPrefs = prefModel.getCount();
        int index = 0;
        while (index < nPrefs) {
            RulePref rulePref = prefModel.get(index);
            Rule rule = this.getRule(config, rulePref.category, rulePref.ruleId);
            if (rule != null && rule.getStatus() != ActivationStatus.OBSOLETE) {
                rule.setStatus(rulePref.enabled ? ActivationStatus.ENABLED : ActivationStatus.DISABLED);
                rule.setSeverity(this.convertAuditSeverityToConfigSeverity(rulePref.severity));
            }
            ++index;
        }
        this.writeConfig(config, this.configFile);
    }

    public void saveAs(File targetFile) {
        Configuration config = this.readConfig();
        this.writeConfig(config, targetFile);
    }

    private void writeConfig(Configuration config, File targetFile) {
        FileOutputStream os = null;
        try {
            try {
                os = new FileOutputStream(targetFile);
                JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Configuration.class});
                Marshaller u = jc.createMarshaller();
                u.marshal((Object)config, (OutputStream)os);
            }
            catch (JAXBException e) {
                e.printStackTrace();
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Rule getRule(Configuration config, String category, String ruleId) {
        for (RuleGroup ruleGroup : config.getRuleGroup()) {
            if (!ruleGroup.getCategory().equals(category)) continue;
            for (Rule ruleEntry : ruleGroup.getRule()) {
                if (!ruleEntry.getRuleId().equals(ruleId)) continue;
                return ruleEntry;
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private Severity convertAuditSeverityToConfigSeverity(AuditSeverity auditSeverity) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public AuditConfigurator() {
        this.configFile = null;
    }

    InputStream openFactorySettings() {
        Bundle bundle = Platform.getBundle((String)"org.modelio.audit");
        InputStream is = null;
        try {
            is = FileLocator.openStream((Bundle)bundle, (IPath)new Path("res/auditconfiguration.xml"), (boolean)false);
            return is;
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$modeliosoft$modelio$audit$preferences$config$Severity() {
        if ($SWITCH_TABLE$com$modeliosoft$modelio$audit$preferences$config$Severity != null) {
            return $SWITCH_TABLE$com$modeliosoft$modelio$audit$preferences$config$Severity;
        }
        int[] nArray = new int[Severity.values().length];
        try {
            nArray[Severity.ERROR.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Severity.TIP.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Severity.WARNING.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$modeliosoft$modelio$audit$preferences$config$Severity = nArray;
        return nArray;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$modeliosoft$modelio$audit$preferences$config$ActivationStatus() {
        if ($SWITCH_TABLE$com$modeliosoft$modelio$audit$preferences$config$ActivationStatus != null) {
            return $SWITCH_TABLE$com$modeliosoft$modelio$audit$preferences$config$ActivationStatus;
        }
        int[] nArray = new int[ActivationStatus.values().length];
        try {
            nArray[ActivationStatus.DISABLED.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ActivationStatus.ENABLED.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ActivationStatus.OBSOLETE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$modeliosoft$modelio$audit$preferences$config$ActivationStatus = nArray;
        return nArray;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$modeliosoft$modelio$core$audit$AuditSeverity() {
        if ($SWITCH_TABLE$com$modeliosoft$modelio$core$audit$AuditSeverity != null) {
            return $SWITCH_TABLE$com$modeliosoft$modelio$core$audit$AuditSeverity;
        }
        int[] nArray = new int[AuditSeverity.values().length];
        try {
            nArray[AuditSeverity.AuditAdvice.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[AuditSeverity.AuditBlock.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[AuditSeverity.AuditError.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[AuditSeverity.AuditFatal.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[AuditSeverity.AuditInfo.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[AuditSeverity.AuditSuccess.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[AuditSeverity.AuditWarning.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$modeliosoft$modelio$core$audit$AuditSeverity = nArray;
        return nArray;
    }
}

