/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.audit.preferences;

import com.modeliosoft.modelio.api.ui.UIColor;
import com.modeliosoft.modelio.audit.plugin.Audit;
import com.modeliosoft.modelio.audit.preferences.AuditConfigurator;
import com.modeliosoft.modelio.audit.preferences.TableSorter;
import com.modeliosoft.modelio.audit.preferences.model.PrefKModel;
import com.modeliosoft.modelio.audit.preferences.model.PrefModel;
import de.kupzog.ktable.KTable;
import de.kupzog.ktable.KTableCellSelectionListener;
import de.kupzog.ktable.KTableModel;
import de.kupzog.ktable.KTableSortedModel;
import java.io.File;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class AuditPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
Listener {
    private Text descriptionText = null;
    private Button exportToFile;
    private Button importFromFile;
    private Button factory;
    private KTable kTable;
    private PrefModel preferences;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.app.internal", (String)"icons/modelio_16.png");
        if (desc != null) {
            this.setImageDescriptor(desc);
        }
        this.kTable = this.createTableViewer(parent);
        GridData kTableData = new GridData(4, 4, true, true);
        this.kTable.setLayoutData((Object)kTableData);
        this.descriptionText = this.createDescription(parent);
        GridData gd_descriptionText = new GridData(4, 4, true, false);
        gd_descriptionText.widthHint = 400;
        this.descriptionText.setLayoutData((Object)gd_descriptionText);
        this.noDefaultAndApplyButton();
        Composite composite = new Composite(parent, 0);
        GridData dataComposite = new GridData(4, 4, true, false);
        composite.setLayoutData((Object)dataComposite);
        composite.setLayout((Layout)new RowLayout(256));
        this.exportToFile = new Button(composite, 0);
        this.exportToFile.setText(Audit.I18N.getMessage("Preferences.Audit.Export.Label", new String[0]));
        this.exportToFile.setToolTipText(Audit.I18N.getMessage("Preferences.Audit.Export.Tooltip", new String[0]));
        this.importFromFile = new Button(composite, 0);
        this.importFromFile.setText(Audit.I18N.getMessage("Preferences.Audit.Import.Label", new String[0]));
        this.importFromFile.setToolTipText(Audit.I18N.getMessage("Preferences.Audit.Import.Tooltip", new String[0]));
        this.factory = new Button(composite, 0);
        this.factory.setText(Audit.I18N.getMessage("Preferences.Audit.Factory.Label", new String[0]));
        this.factory.setToolTipText(Audit.I18N.getMessage("Preferences.Audit.Factory.Tooltip", new String[0]));
        this.addListeners();
        return null;
    }

    private Text createDescription(Composite parent) {
        Text descriptionText = new Text(parent, 66);
        descriptionText.setEditable(false);
        descriptionText.setForeground(UIColor.LABEL_TIP_FG);
        descriptionText.setText(Audit.I18N.getString("Preferences.Audit.Description"));
        return descriptionText;
    }

    public boolean performOk() {
        AuditConfigurator configurator = new AuditConfigurator(Audit.getInstance().getLocalConfigFileDescriptor());
        configurator.apply(this.preferences);
        Audit.getInstance().restart();
        return true;
    }

    protected void initializeDialogUnits(Control testControl) {
        super.initializeDialogUnits(testControl);
    }

    private void addListeners() {
        this.exportToFile.addListener(13, (Listener)this);
        this.importFromFile.addListener(13, (Listener)this);
        this.factory.addListener(13, (Listener)this);
    }

    public void handleEvent(Event event) {
        if (event.widget.equals(this.importFromFile)) {
            Shell parentShell = Display.getDefault().getActiveShell();
            FileDialog dlg = new FileDialog(parentShell, 4096);
            dlg.setFilterExtensions(new String[]{"*.xml"});
            dlg.setFilterNames(new String[]{Audit.I18N.getString("Preferences.Audit.Export.FileType")});
            dlg.open();
            File file = new File(dlg.getFilterPath(), dlg.getFileName());
            AuditConfigurator configurator = new AuditConfigurator(file);
            this.preferences = configurator.createPrefModel();
            this.kTable.setModel((KTableModel)new PrefKModel(this.preferences, this.kTable));
        } else if (event.widget.equals(this.exportToFile)) {
            Shell parentShell = Display.getDefault().getActiveShell();
            FileDialog dlg = new FileDialog(parentShell, 8192);
            dlg.setFilterExtensions(new String[]{"*.xml"});
            dlg.setFilterNames(new String[]{Audit.I18N.getString("Preferences.Audit.Import.FileType")});
            dlg.open();
            File file = new File(dlg.getFilterPath(), dlg.getFileName());
            if (!file.getName().endsWith(".xml")) {
                file = new File(String.valueOf(file.getAbsolutePath()) + ".xml");
            }
            System.out.println("File = " + file.toString());
            AuditConfigurator configurator = new AuditConfigurator(Audit.getInstance().getLocalConfigFileDescriptor());
            configurator.apply(this.preferences);
            configurator.saveAs(file);
        } else if (event.widget.equals(this.factory)) {
            AuditConfigurator configurator = new AuditConfigurator(null);
            this.preferences = configurator.createPrefModel();
            this.kTable.setModel((KTableModel)new PrefKModel(this.preferences, this.kTable));
        }
    }

    private KTable createTableViewer(Composite parent) {
        int tableStyle = 200448;
        KTable kTable = new KTable(parent, tableStyle);
        AuditConfigurator configurator = new AuditConfigurator(Audit.getInstance().getLocalConfigFileDescriptor());
        this.preferences = configurator.createPrefModel();
        PrefKModel kModel = new PrefKModel(this.preferences, kTable);
        kTable.setModel((KTableModel)kModel);
        TableSorter sorter = new TableSorter(kTable, (KTableSortedModel)kModel);
        kTable.addCellSelectionListener((KTableCellSelectionListener)sorter);
        return kTable;
    }
}

