/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.audit.preferences;

import com.modeliosoft.modelio.audit.preferences.TableSorter;
import de.kupzog.ktable.KTable;
import de.kupzog.ktable.KTableCellSelectionAdapter;
import de.kupzog.ktable.KTableSortComparator;
import de.kupzog.ktable.KTableSortedModel;

public class TableSorter
extends KTableCellSelectionAdapter {
    private KTable table;
    private KTableSortedModel model;

    public void fixedCellSelected(int col, int row, int statemask) {
        if (row < this.model.getFixedHeaderRowCount() && col >= this.model.getFixedHeaderColumnCount()) {
            KTableSortComparator sortComparator;
            int direction = 1;
            if (this.model.getSortColumn() == col) {
                if (this.model.getSortState() == 1) {
                    direction = 2;
                } else if (this.model.getSortState() == 2) {
                    direction = -1;
                }
            }
            if ((sortComparator = this.getComparatorForColumn(col, direction)) != null) {
                sortComparator.setSortDirection(direction);
                this.model.sort(sortComparator);
                this.table.redraw();
            }
        }
    }

    private KTableSortComparator getComparatorForColumn(int col, int direction) {
        switch (col) {
            case 0: 
            case 1: 
            case 2: {
                return new SimpleStringComparator(this, this.model, col, direction);
            }
            case 3: {
                return new SeverityComparator(this.model, col, direction);
            }
            case 4: {
                return new EnablementComparator(this.model, col, direction);
            }
        }
        return null;
    }

    public TableSorter(KTable table, KTableSortedModel model) {
        this.table = table;
        this.model = model;
    }
}

