/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.audit.view;

import com.modeliosoft.modelio.audit.dialog.auditEntry.AuditEntryDialog;
import com.modeliosoft.modelio.audit.engine.AuditEngine;
import com.modeliosoft.modelio.audit.engine.core.IAuditDiagnostic;
import com.modeliosoft.modelio.audit.engine.core.IAuditEntry;
import com.modeliosoft.modelio.audit.engine.core.IAuditListener;
import com.modeliosoft.modelio.audit.engine.core.IAuditMonitor;
import com.modeliosoft.modelio.audit.plugin.Audit;
import com.modeliosoft.modelio.audit.statusbar.StatusBar;
import com.modeliosoft.modelio.audit.view.AuditView;
import com.modeliosoft.modelio.audit.view.ktable.AuditTableSorter;
import com.modeliosoft.modelio.audit.view.ktable.KTableAuditModel;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.app.events.ISessionListener;
import de.kupzog.ktable.KTable;
import de.kupzog.ktable.KTableCellDoubleClickListener;
import de.kupzog.ktable.KTableCellSelectionListener;
import de.kupzog.ktable.KTableModel;
import de.kupzog.ktable.KTableSortedModel;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;

public class AuditView
extends ViewPart
implements KTableCellDoubleClickListener,
IAuditListener,
ISessionListener {
    public static final String VIEW_ID = "com.modeliosoft.modelio.audit.AuditViewID";
    private AuditEngine auditEngine = null;
    private AuditTableSorter sorter = null;
    private final Image baseImage;
    private final Image errorImage;
    private Composite area = null;
    KTable auditTable = null;
    private StatusBar auditStatus;
    private IModelingSession modelingSession;
    public boolean autoSelectInExplorer;
    private AutoSelectCellListener autoSelectListener;
    private int errorAndWarningsCount = 0;
    private KTableAuditModel ktableAuditModel;

    public AuditView() {
        Bundle imageBundle = Platform.getBundle((String)"org.modelio.audit");
        Path basePath = new Path("icons/base.png");
        URL bitmapUrl = FileLocator.find((Bundle)imageBundle, (IPath)basePath, null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)bitmapUrl);
        this.baseImage = desc.createImage();
        Path errorPath = new Path("icons/error_flag.png");
        bitmapUrl = FileLocator.find((Bundle)imageBundle, (IPath)errorPath, null);
        desc = ImageDescriptor.createFromURL((URL)bitmapUrl);
        this.errorImage = desc.createImage();
    }

    public void dispose() {
        O.getDefault().getSessionService().removeSessionListener((ISessionListener)this);
        this.stop();
        this.baseImage.dispose();
        this.errorImage.dispose();
        this.auditTable = null;
        this.sorter = null;
        this.autoSelectListener = null;
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.area = new Composite(parent, 0x100000);
        FormLayout layout = new FormLayout();
        this.area.setLayout((Layout)layout);
        this.auditTable = this.createAuditTable(this.area);
        this.auditStatus = this.createAuditStatus(this.area);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment((Control)this.auditStatus.getComposite(), 0);
        this.auditTable.setLayoutData((Object)fd);
        FormData fd2 = new FormData();
        fd2.left = new FormAttachment(0, 0);
        fd2.right = new FormAttachment(100, 0);
        fd2.bottom = new FormAttachment(100, 0);
        this.auditStatus.getComposite().setLayoutData((Object)fd2);
        this.ktableAuditModel = new KTableAuditModel(this.auditTable, null);
        this.auditTable.setModel((KTableModel)this.ktableAuditModel);
        this.auditTable.addCellDoubleClickListener((KTableCellDoubleClickListener)this);
        this.sorter = new AuditTableSorter(this.auditTable, (KTableSortedModel)this.ktableAuditModel);
        this.auditTable.addCellSelectionListener((KTableCellSelectionListener)this.sorter);
        this.autoSelectListener = new AutoSelectCellListener(this, this);
        this.auditTable.addCellSelectionListener((KTableCellSelectionListener)this.autoSelectListener);
        O.getDefault().getSessionService().addSessionListener((ISessionListener)this);
    }

    public void sessionOpened(IModelingSession modelingSession) {
        this.modelingSession = modelingSession;
        this.auditEngine = Audit.getInstance().auditEngine;
        this.auditEngine.addAuditListener((IAuditListener)this);
        this.auditEngine.addAuditMonitor((IAuditMonitor)this.auditStatus);
        this.auditEngine.addAuditListener((IAuditListener)this.auditStatus);
        this.ktableAuditModel.setDiagnostics(this.auditEngine.getAuditDiagnostic());
    }

    public void sessionClosed(IModelingSession modelingSession) {
        this.stop();
    }

    public void stop() {
        this.auditEngine.removeAuditListener((IAuditListener)this);
        this.auditEngine.removeAuditListener((IAuditListener)this.auditStatus);
        this.auditEngine.removeAuditMonitor((IAuditMonitor)this.auditStatus);
        this.modelingSession = null;
    }

    public void setFocus() {
        this.setTitleImage(this.baseImage);
    }

    private KTable createAuditTable(Composite parent) {
        int tableStyle = 9637632;
        1 table = new /* Unavailable Anonymous Inner Class!! */;
        KTableAuditModel ktableNoAuditModel = new KTableAuditModel((KTable)table, null);
        table.setModel((KTableModel)ktableNoAuditModel);
        MenuManager popupMgr = new MenuManager();
        IMenuService menuService = (IMenuService)this.getViewSite().getService(IMenuService.class);
        menuService.populateContributionManager((ContributionManager)popupMgr, "popup:com.modeliosoft.modelio.audit.AuditViewID");
        table.setMenu(popupMgr.createContextMenu((Control)table));
        return table;
    }

    private void refresh(int oldErrorAndWarningsCount, int newErrorAndWarningsCount) {
        this.auditTable.getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void cellDoubleClicked(int col, int row, int statemask) {
        List entries = this.auditEngine.auditDiagnostic.getEntries();
        int realRow = ((KTableSortedModel)this.auditTable.getModel()).mapRowIndexToModel(row);
        IAuditEntry entry = (IAuditEntry)entries.get(realRow - 1);
        AuditEntryDialog dialog = new AuditEntryDialog(Display.getCurrent().getActiveShell(), entry, this.modelingSession);
        dialog.open();
    }

    public void fixedCellDoubleClicked(int col, int row, int statemask) {
    }

    public void auditModelChanged(IAuditDiagnostic auditDiagnostic) {
        int newErrorAndWarningsCount = auditDiagnostic.getErrorCount() + auditDiagnostic.getWarningCount();
        this.refresh(this.errorAndWarningsCount, newErrorAndWarningsCount);
        this.errorAndWarningsCount = newErrorAndWarningsCount;
    }

    private StatusBar createAuditStatus(Composite parent) {
        StatusBar statusBar = new StatusBar(parent, 0);
        return statusBar;
    }

    public IAuditEntry getSelectedDiagnosticEntry() {
        int rowIndex = this.auditTable.getRowSelection()[0];
        List entries = this.auditEngine.auditDiagnostic.getEntries();
        int realRow = ((KTableSortedModel)this.auditTable.getModel()).mapRowIndexToModel(rowIndex);
        IAuditEntry entry = (IAuditEntry)entries.get(realRow - 1);
        return entry;
    }

    public boolean isAutoSelectInExplorer() {
        return this.autoSelectInExplorer;
    }

    public void setAutoSelectInExplorer(boolean value) {
        this.autoSelectInExplorer = value;
    }

    static /* synthetic */ AuditTableSorter access$0(AuditView auditView) {
        return auditView.sorter;
    }

    static /* synthetic */ Image access$1(AuditView auditView) {
        return auditView.baseImage;
    }

    static /* synthetic */ void access$2(AuditView auditView, Image image) {
        auditView.setTitleImage(image);
    }

    static /* synthetic */ Image access$3(AuditView auditView) {
        return auditView.errorImage;
    }
}

