/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.audit.view.ktable;

import com.modeliosoft.modelio.audit.engine.core.IAuditDiagnostic;
import com.modeliosoft.modelio.audit.engine.core.IAuditEntry;
import com.modeliosoft.modelio.audit.engine.impl.AuditDiagnostic;
import com.modeliosoft.modelio.audit.plugin.Audit;
import com.modeliosoft.modelio.audit.view.ktable.KTableAuditModel;
import com.modeliosoft.modelio.audit.view.model.DiagnosticFormatter;
import com.modeliosoft.modelio.audit.view.renderers.AuditHeaderCellRenderer;
import de.kupzog.ktable.KTable;
import de.kupzog.ktable.KTableCellEditor;
import de.kupzog.ktable.KTableCellRenderer;
import de.kupzog.ktable.KTableModel;
import de.kupzog.ktable.KTableSortedModel;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public class KTableAuditModel
extends KTableSortedModel {
    private Renderers rendererFactory = null;
    private KTable table = null;
    private static final int MAX_REPORTED_DIAGNOSTICS = 100;
    public static final int TIMESTAMP_COLUMN_ID = 0;
    public static final int SEVERITY_COLUMN_ID = 1;
    public static final int RULEID_COLUMN_ID = 2;
    public static final int METACLASS_COLUMN_ID = 3;
    public static final int ELEMENT_NAME_COLUMN_ID = 4;
    public static final int DESCRIPTION_COLUMN_ID = 5;
    private IAuditDiagnostic diagnostics = null;
    private Color oddColor = null;
    private Color evenColor = null;

    public KTableAuditModel(KTable table, IAuditDiagnostic diagnostics) {
        this.table = table;
        this.diagnostics = diagnostics;
        this.oddColor = table.getDisplay().getSystemColor(1);
        this.evenColor = new Color((Device)Display.getCurrent(), 245, 245, 245);
        this.rendererFactory = new Renderers(this.table);
        this.initialize();
    }

    public KTableCellEditor doGetCellEditor(int col, int row) {
        return null;
    }

    public KTableCellRenderer doGetCellRenderer(int col, int row) {
        AuditHeaderCellRenderer renderer = null;
        if (row == 0) {
            renderer = this.rendererFactory.headerRenderer;
        } else {
            switch (col) {
                case 0: {
                    renderer = this.rendererFactory.timestampRenderer;
                    break;
                }
                case 1: {
                    renderer = this.rendererFactory.severityRenderer;
                    break;
                }
                case 2: {
                    renderer = this.rendererFactory.originRenderer;
                    break;
                }
                case 3: {
                    renderer = this.rendererFactory.metaclassRenderer;
                    break;
                }
                case 4: {
                    renderer = this.rendererFactory.descriptionRenderer;
                    break;
                }
                case 5: {
                    renderer = this.rendererFactory.descriptionRenderer;
                    break;
                }
                default: {
                    renderer = this.rendererFactory.descriptionRenderer;
                }
            }
        }
        int colorRow = this.mapRowIndexToTable(row);
        if (colorRow != 0) {
            renderer.setBackground(colorRow % 2 == 0 ? this.oddColor : this.evenColor);
        }
        return renderer;
    }

    public int doGetColumnCount() {
        return 6;
    }

    public Object doGetContentAt(int col, int row) {
        if (row == 0) {
            switch (col) {
                case 0: {
                    return Audit.I18N.getString("AuditView.Timestamp.label");
                }
                case 1: {
                    return Audit.I18N.getString("AuditView.Severity.label");
                }
                case 2: {
                    return Audit.I18N.getString("AuditView.Rule.label");
                }
                case 3: {
                    return Audit.I18N.getString("AuditView.Type.label");
                }
                case 4: {
                    return Audit.I18N.getString("AuditView.Element.label");
                }
                case 5: {
                    return Audit.I18N.getString("AuditView.Description.label");
                }
            }
        } else {
            List entries = this.diagnostics.getEntries();
            if (entries.size() < row) {
                return "";
            }
            IAuditEntry entry = (IAuditEntry)entries.get(row - 1);
            switch (col) {
                case 0: {
                    return entry.getTimestamp();
                }
                case 1: {
                    return entry.getSeverity();
                }
                case 2: {
                    return entry.getRuleId();
                }
                case 3: {
                    return entry.getElement();
                }
                case 4: {
                    if (!entry.getElement().isValid()) {
                        return "";
                    }
                    return entry.getElement().getName();
                }
                case 5: {
                    return DiagnosticFormatter.getMessage((IAuditEntry)entry);
                }
            }
        }
        return null;
    }

    public int doGetRowCount() {
        int nbLines = 1;
        if (this.diagnostics != null) {
            nbLines += Math.min(this.diagnostics.getEntries().size(), 100);
        }
        return nbLines;
    }

    public void doSetContentAt(int col, int row, Object value) {
    }

    public int getInitialColumnWidth(int column) {
        switch (column) {
            case 0: {
                return 58;
            }
            case 1: {
                return 23;
            }
            case 2: {
                return 40;
            }
            case 3: {
                return 23;
            }
            case 4: {
                return 100;
            }
            case 5: {
                return 0;
            }
        }
        return 0;
    }

    public int getInitialRowHeight(int row) {
        if (row == 0) {
            return 22;
        }
        return 18;
    }

    public int getFixedHeaderColumnCount() {
        return 0;
    }

    public int getFixedHeaderRowCount() {
        return 1;
    }

    public int getFixedSelectableColumnCount() {
        return 1;
    }

    public int getFixedSelectableRowCount() {
        return 0;
    }

    public int getRowHeightMinimum() {
        return 10;
    }

    public boolean isColumnResizable(int col) {
        return true;
    }

    public boolean isRowResizable(int row) {
        return false;
    }

    private int getOptimalColumnWidth(int column) {
        if (column >= 0 && column < this.getColumnCount()) {
            int width;
            int optWidth = 5;
            GC gc = new GC((Drawable)this.table);
            int i = 0;
            while (i < this.getFixedHeaderRowCount()) {
                width = this.getCellRenderer(column, i).getOptimalWidth(gc, column, i, this.getContentAt(column, i), true, (KTableModel)this);
                if (width > optWidth) {
                    optWidth = width;
                }
                ++i;
            }
            i = 1;
            while (i < 1 + this.getRowCount() - 1) {
                width = this.getCellRenderer(column, i).getOptimalWidth(gc, column, i, this.getContentAt(column, i), true, (KTableModel)this);
                if (width > optWidth) {
                    optWidth = width;
                }
                ++i;
            }
            gc.dispose();
            return optWidth;
        }
        return -1;
    }

    protected void finalize() throws Throwable {
        this.evenColor.dispose();
        this.evenColor = null;
        super.finalize();
    }

    public String doGetTooltipAt(int col, int row) {
        if (row == 0) {
            switch (col) {
                case 0: {
                    return Audit.I18N.getString("AuditView.Timestamp.tooltip");
                }
                case 1: {
                    return Audit.I18N.getString("AuditView.Severity.tooltip");
                }
                case 2: {
                    return Audit.I18N.getString("AuditView.Rule.tooltip");
                }
                case 3: {
                    return Audit.I18N.getString("AuditView.Type.tooltip");
                }
                case 4: {
                    return Audit.I18N.getString("AuditView.Element.tooltip");
                }
                case 5: {
                    return Audit.I18N.getString("AuditView.Description.tooltip");
                }
            }
        }
        return null;
    }

    public void setDiagnostics(AuditDiagnostic auditDiagnostic) {
        this.diagnostics = auditDiagnostic;
    }
}

