/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.audit.view.model;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.audit.engine.core.IAuditEntry;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/*
 * Exception performing whole class analysis ignored.
 */
public class DiagnosticFormatter {
    protected static final ResourceBundle bundle = ResourceBundle.getBundle("auditrules");

    public static String getMessage(IAuditEntry entry) {
        try {
            String pattern = bundle.getString(String.valueOf(entry.getRuleId()) + ".message");
            return MessageFormat.format(pattern, DiagnosticFormatter.makeInfos((List)entry.getLinkedObjects()));
        }
        catch (MissingResourceException e) {
            System.err.println("auditrules: no entry for rule " + entry.getRuleId() + ".message");
            return "!" + entry.getRuleId() + ".message!";
        }
    }

    public static String getDescription(IAuditEntry entry) {
        try {
            return bundle.getString(String.valueOf(entry.getRuleId()) + ".description");
        }
        catch (MissingResourceException e) {
            System.err.println("auditrules: no entry for rule " + entry.getRuleId() + ".description");
            return "!" + entry.getRuleId() + ".description!";
        }
    }

    private static Object[] makeInfos(List<Object> linkedObjects) {
        ArrayList<Object> infos = new ArrayList<Object>();
        for (Object o : linkedObjects) {
            if (o instanceof IModelElement) {
                IModelElement element = (IModelElement)o;
                if (!element.isValid()) continue;
                infos.add(element.getName());
                continue;
            }
            infos.add(o);
        }
        return infos.toArray();
    }
}

