/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.audit.view.renderers;

import com.modeliosoft.modelio.core.audit.AuditSeverity;
import de.kupzog.ktable.KTable;
import de.kupzog.ktable.KTableModel;
import de.kupzog.ktable.SWTX;
import de.kupzog.ktable.renderers.DefaultCellRenderer;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class AuditSeverityCellRenderer
extends DefaultCellRenderer {
    protected Text m_text;
    private Image adviceImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.audit", (String)"icons/advice.png").createImage();
    private Image blockImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.audit", (String)"icons/block.png").createImage();
    private Image errorImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.audit", (String)"icons/error.png").createImage();
    private Image fatalImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.audit", (String)"icons/fatal.png").createImage();
    private Image infoImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.audit", (String)"icons/info.png").createImage();
    private Image warningImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.audit", (String)"icons/warning.png").createImage();

    public AuditSeverityCellRenderer(KTable table, int style) {
        super(style);
    }

    public int getOptimalWidth(GC gc, int col, int row, Object content, boolean fixed, KTableModel model) {
        return SWTX.getCachedStringExtent((GC)gc, (String)content.toString()).x + 8;
    }

    public void drawCell(GC gc, Rectangle rect, int col, int row, Object content, boolean focus, boolean fixed, boolean clicked, KTableModel model) {
        this.applyFont(gc);
        AuditSeverity severity = (AuditSeverity)content;
        if (focus && (this.m_Style & 0x10) != 0) {
            rect = this.drawDefaultSolidCellLine(gc, rect, COLOR_LINE_LIGHTGRAY, COLOR_LINE_LIGHTGRAY);
            this.drawCellContent(gc, rect, "", null, this.getForeground(), COLOR_BGFOCUS);
            gc.drawFocus(rect.x, rect.y, rect.width, rect.height);
        } else if (focus && (this.m_Style & 0x20) != 0) {
            rect = this.drawDefaultSolidCellLine(gc, rect, COLOR_BGROWFOCUS, COLOR_BGROWFOCUS);
            this.drawCellContent(gc, rect, "", null, COLOR_FGROWFOCUS, COLOR_BGROWFOCUS);
        } else {
            rect = this.drawDefaultSolidCellLine(gc, rect, COLOR_LINE_LIGHTGRAY, COLOR_LINE_LIGHTGRAY);
            this.drawCellContent(gc, rect, "", null, this.getForeground(), this.getBackground());
        }
        if ((this.m_Style & 0x80) != 0) {
            this.drawCommentSign(gc, rect);
        }
        this.drawImage(gc, rect, severity);
        this.resetFont(gc);
    }

    public void setCommentIndication(boolean value) {
        this.m_Style = value ? (this.m_Style |= 0x80) : (this.m_Style &= 0xFFFFFF7F);
    }

    protected final void drawImage(GC gc, Rectangle rect, AuditSeverity severity) {
        Image image = null;
        if (severity == AuditSeverity.AuditAdvice) {
            image = this.adviceImage;
        } else if (severity == AuditSeverity.AuditBlock) {
            image = this.blockImage;
        } else if (severity == AuditSeverity.AuditError) {
            image = this.errorImage;
        } else if (severity == AuditSeverity.AuditFatal) {
            image = this.fatalImage;
        } else if (severity == AuditSeverity.AuditInfo) {
            image = this.infoImage;
        } else if (severity == AuditSeverity.AuditWarning) {
            image = this.warningImage;
        }
        if (image != null) {
            Rectangle imageRect = image.getBounds();
            gc.drawImage(image, rect.x + rect.width - imageRect.width, rect.y);
        }
    }

    protected void finalize() throws Throwable {
        this.adviceImage.dispose();
        this.adviceImage = null;
        this.blockImage.dispose();
        this.adviceImage = null;
        this.errorImage.dispose();
        this.adviceImage = null;
        this.fatalImage.dispose();
        this.adviceImage = null;
        this.infoImage.dispose();
        this.adviceImage = null;
        this.warningImage.dispose();
        this.adviceImage = null;
        super.finalize();
    }
}

