/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.intro;

import com.modeliosoft.modelio.app.intro.ScriptRunner;
import com.modeliosoft.modelio.app.intro.plugin.AppModelioIntro;
import com.modeliosoft.modelio.app.newProject.ProjectCreator;
import com.modeliosoft.modelio.app.newProject.gui.ProjectCreationDataModel;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.internal.app.IProject;
import com.modeliosoft.modelio.internal.app.IProjectSpace;
import com.modeliosoft.modelio.internal.app.IWorkspace;
import com.modeliosoft.modelio.internal.app.services.App;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class ApplicationStarter
implements Runnable {
    private String[] args = null;

    public ApplicationStarter(String[] args) {
        this.args = new String[args.length];
        System.arraycopy(args, 0, this.args, 0, args.length);
    }

    @Override
    public void run() {
        boolean openedProject;
        int i = 0;
        String projectToOpen = null;
        String scriptToRun = null;
        String workspaceToRun = null;
        String projectToCreate = null;
        String template = null;
        while (i < this.args.length) {
            if (this.args[i].equals("-project")) {
                projectToOpen = this.args[i + 1];
                i += 2;
                continue;
            }
            if (this.args[i].equals("-script")) {
                scriptToRun = this.args[i + 1];
                i += 2;
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setMinimized(true);
                continue;
            }
            if (this.args[i].equals("-workspace")) {
                workspaceToRun = this.args[i + 1];
                i += 2;
                continue;
            }
            if (this.args[i].equals("-create")) {
                projectToCreate = this.args[i + 1];
                i += 2;
                continue;
            }
            if (this.args[i].equals("-template")) {
                template = this.args[i + 1];
                i += 2;
                continue;
            }
            ++i;
        }
        if (workspaceToRun != null) {
            File wkdir = new File(workspaceToRun);
            try {
                wkdir = wkdir.getCanonicalFile();
            }
            catch (IOException e) {
                AppModelioIntro.LOG.error((Throwable)e);
            }
            if (wkdir.exists() && wkdir.isDirectory() && wkdir.canWrite()) {
                App.getInstance().getWorkspace().changeDirectory(wkdir);
            } else {
                AppModelioIntro.LOG.error("Invalid workspace directory: %s", new Object[]{workspaceToRun});
                System.exit(-1);
            }
        }
        if (projectToOpen != null && projectToCreate != null) {
            AppModelioIntro.LOG.error("Invalid workspace directory: %s %s", new Object[]{projectToOpen, projectToCreate});
            System.exit(-1);
        }
        if (projectToCreate != null) {
            if (!this.ProjectExistsInWorkspace(projectToCreate)) {
                ProjectCreationDataModel pm = new ProjectCreationDataModel(template);
                pm.setProjectName(projectToCreate);
                ProjectCreator projectCreator = new ProjectCreator(App.getInstance().getWorkspace(), pm);
                IProgressService service = PlatformUI.getWorkbench().getProgressService();
                try {
                    service.run(false, false, (IRunnableWithProgress)projectCreator);
                }
                catch (InvocationTargetException e) {
                    AppModelioIntro.LOG.error((Throwable)e);
                }
                catch (InterruptedException e) {
                    AppModelioIntro.LOG.error((Throwable)e);
                }
            } else {
                AppModelioIntro.LOG.error("The project '%s'  already exists in the workspace.", new Object[]{projectToCreate});
                System.exit(-1);
            }
        }
        if (projectToOpen != null && !this.ProjectExistsInWorkspace(projectToOpen)) {
            AppModelioIntro.LOG.error("The project '%s'  was not found in the workspace.", new Object[]{projectToOpen});
            System.exit(-1);
        }
        File scriptFile = null;
        if (!(scriptToRun == null || (scriptFile = new File(scriptToRun)).exists() && scriptFile.canRead() && scriptFile.isFile())) {
            AppModelioIntro.LOG.error("The Script file: '%s' was not found or not accessible.", new Object[]{scriptFile.getAbsolutePath()});
            System.exit(-1);
        }
        boolean bl = openedProject = projectToCreate != null || this.autoOpenProject(projectToOpen);
        if (openedProject && scriptToRun != null) {
            AppModelioIntro.LOG.info("Running script: %s", new Object[]{scriptToRun});
            if (scriptToRun.endsWith(".py")) {
                this.autoRunScript(App.getInstance().getOpenedProject(), new File(scriptToRun));
            } else {
                AppModelioIntro.LOG.error("The script must a Python script (.py), aborting...");
            }
            this.autoCloseProject();
            PlatformUI.getWorkbench().close();
        }
    }

    protected boolean ProjectExistsInWorkspace(String projectName) {
        return this.getProjectSpaceInWorkspace(projectName) != null;
    }

    protected IProjectSpace getProjectSpaceInWorkspace(String projectName) {
        IWorkspace workspace = App.getInstance().getWorkspace();
        workspace.refreshProjects();
        for (IProjectSpace p : workspace.getProjects()) {
            if (!p.getName().equals(projectName)) continue;
            return p;
        }
        return null;
    }

    protected boolean autoOpenProject(String projectName) {
        App app = App.getInstance();
        IWorkspace workspace = app.getWorkspace();
        workspace.refreshProjects();
        for (IProjectSpace p : workspace.getProjects()) {
            if (!p.getName().equals(projectName)) continue;
            try {
                app.openProject(p);
                return app.getOpenedProject().getSession().isOpen();
            }
            catch (Exception e) {
                AppModelioIntro.LOG.error(AppModelioIntro.I18N.getMessage("OpenFailedMsg", new String[]{p.getName(), e.getLocalizedMessage()}));
                return false;
            }
        }
        return false;
    }

    protected boolean autoCloseProject() {
        boolean check = App.getInstance().getOpenedProject() != null;
        App app = App.getInstance();
        app.closeProject();
        return check;
    }

    protected void autoRunScript(IProject project, File scriptFile) {
        IModelingSession session = project.getSession();
        ScriptRunner jRunner = new ScriptRunner(session, App.getInstance().getWorkspace().getDirectory(), project.getProjectSpace().getDataDirectory());
        jRunner.runScript(scriptFile);
    }
}

